/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keys.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.ECGOST3410NamedCurveTable;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.util.encoders.Hex;
import org.cesecore.certificates.util.AlgorithmTools;
import org.cesecore.config.CesecoreConfiguration;
import org.cesecore.internal.InternalResources;
import org.cesecore.util.Base64;
import org.cesecore.util.CertTools;
import org.cesecore.util.CryptoProviderTools;
import org.ejbca.cvc.PublicKeyEC;

public final class KeyTools {
    private static final Logger log = Logger.getLogger(KeyTools.class);
    private static final InternalResources intres = InternalResources.getInstance();
    private static final byte[] BAG_ATTRIBUTES = "Bag Attributes\n".getBytes();
    private static final byte[] FRIENDLY_NAME = "    friendlyName: ".getBytes();
    private static final byte[] SUBJECT_ATTRIBUTE = "subject=/".getBytes();
    private static final byte[] ISSUER_ATTRIBUTE = "issuer=/".getBytes();
    private static final byte[] BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----".getBytes();
    private static final byte[] END_CERTIFICATE = "-----END CERTIFICATE-----".getBytes();
    private static final byte[] BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----".getBytes();
    private static final byte[] END_PRIVATE_KEY = "-----END PRIVATE KEY-----".getBytes();
    private static final byte[] NL = "\n".getBytes();

    private KeyTools() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyPair genKeys(String keySpec, AlgorithmParameterSpec algSpec, String keyAlg) throws InvalidAlgorithmParameterException {
        KeyPairGenerator keygen;
        if (log.isTraceEnabled()) {
            log.trace((Object)(">genKeys(" + keySpec + ", " + keyAlg + ")"));
        }
        try {
            keygen = KeyPairGenerator.getInstance(keyAlg, "BC");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Algorithm " + keyAlg + "was not recognized.", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new IllegalStateException("BouncyCastle was not found as a provider.", noSuchProviderException);
        }
        if (StringUtils.equals((String)keyAlg, (String)"ECDSA")) {
            AlgorithmParameterSpec algorithmParameterSpec = null;
            if (keySpec != null && !StringUtils.equals((String)keySpec, (String)"implicitlyCA")) {
                log.debug((Object)("Generating named curve ECDSA key pair: " + keySpec));
                ECGenParameterSpec bcSpec = new ECGenParameterSpec(keySpec);
                keygen.initialize(bcSpec, new SecureRandom());
            } else if (algSpec != null) {
                log.debug((Object)("Generating ECDSA key pair from AlgorithmParameterSpec: " + algSpec));
                AlgorithmParameterSpec algorithmParameterSpec2 = algSpec;
                keygen.initialize(algorithmParameterSpec2, new SecureRandom());
            } else {
                if (!StringUtils.equals((String)keySpec, (String)"implicitlyCA")) throw new InvalidAlgorithmParameterException("No keySpec no algSpec and no implicitlyCA specified");
                log.debug((Object)"Generating implicitlyCA encoded ECDSA key pair");
                keygen.initialize(algorithmParameterSpec, new SecureRandom());
            }
        } else if (keyAlg.equals("ECGOST3410")) {
            void var4_12;
            Object var4_9 = null;
            if (keySpec != null) {
                log.debug((Object)("Generating keys from given key specifications : " + keySpec));
                ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECGOST3410NamedCurveTable.getParameterSpec((String)keySpec);
                if (eCNamedCurveParameterSpec == null) {
                    throw new InvalidAlgorithmParameterException("Key specification " + keySpec + " is invalid for ECGOST3410");
                }
            } else {
                if (algSpec == null) throw new InvalidAlgorithmParameterException("No key or algorithm specifications");
                log.debug((Object)("Generating keys from given algorithm parameters : " + algSpec));
                AlgorithmParameterSpec algorithmParameterSpec = algSpec;
            }
            keygen.initialize((AlgorithmParameterSpec)var4_12, new SecureRandom());
        } else if (keyAlg.equals("DSTU4145")) {
            void var4_16;
            Object var4_13 = null;
            if (keySpec != null) {
                log.debug((Object)("Generating keys from given key specifications : " + keySpec));
                AlgorithmParameterSpec algorithmParameterSpec = KeyTools.dstuOidToAlgoParams(keySpec);
                if (algorithmParameterSpec == null) {
                    throw new InvalidAlgorithmParameterException("Key specification " + keySpec + " is invalid for DSTU4145");
                }
            } else {
                if (algSpec == null) throw new InvalidAlgorithmParameterException("No key or algorithm specifications");
                log.debug((Object)("Generating keys from given algorithm parameters : " + algSpec));
                AlgorithmParameterSpec algorithmParameterSpec = algSpec;
            }
            keygen.initialize((AlgorithmParameterSpec)var4_16, new SecureRandom());
        } else if (keySpec.startsWith("DSA")) {
            int n = Integer.parseInt(keySpec.substring(3));
            keygen.initialize(n);
        } else {
            int n = Integer.parseInt(keySpec);
            keygen.initialize(n);
        }
        KeyPair keyPair = keygen.generateKeyPair();
        if (log.isDebugEnabled()) {
            PublicKey pk = keyPair.getPublic();
            int len = KeyTools.getKeyLength(pk);
            log.debug((Object)("Generated " + keyPair.getPublic().getAlgorithm() + " keys with length " + len));
        }
        log.trace((Object)"<genKeys()");
        return keyPair;
    }

    public static KeyPair genKeys(String keySpec, String keyAlg) throws InvalidAlgorithmParameterException {
        return KeyTools.genKeys(keySpec, null, keyAlg);
    }

    public static PublicKey getECPublicKeyWithParams(PublicKey pk, String keySpec) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        PublicKeyEC pkec;
        ECParameterSpec spec;
        PublicKey ret = pk;
        if (pk instanceof PublicKeyEC && keySpec != null && (spec = (pkec = (PublicKeyEC)pk).getParams()) == null) {
            ECNamedCurveParameterSpec bcspec = ECNamedCurveTable.getParameterSpec((String)keySpec);
            ECPoint p = pkec.getW();
            org.bouncycastle.math.ec.ECPoint ecp = EC5Util.convertPoint((ECCurve)bcspec.getCurve(), (ECPoint)p, (boolean)false);
            ECPublicKeySpec pubKey = new ECPublicKeySpec(ecp, (org.bouncycastle.jce.spec.ECParameterSpec)bcspec);
            KeyFactory keyfact = KeyFactory.getInstance("ECDSA", "BC");
            ret = keyfact.generatePublic((KeySpec)pubKey);
        }
        return ret;
    }

    public static PublicKey getECPublicKeyWithParams(PublicKey pk, PublicKey pkwithparams) throws InvalidKeySpecException {
        PublicKey ret = pk;
        if (pk instanceof PublicKeyEC && pkwithparams instanceof PublicKeyEC) {
            PublicKeyEC pkec = (PublicKeyEC)pk;
            ECParameterSpec spec = pkec.getParams();
            if (spec == null) {
                PublicKeyEC pkecp = (PublicKeyEC)pkwithparams;
                ECParameterSpec pkspec = pkecp.getParams();
                if (pkspec != null) {
                    KeyFactory keyfact;
                    org.bouncycastle.jce.spec.ECParameterSpec bcspec = EC5Util.convertSpec((ECParameterSpec)pkspec, (boolean)false);
                    ECPoint p = pkec.getW();
                    org.bouncycastle.math.ec.ECPoint ecp = EC5Util.convertPoint((ECParameterSpec)pkspec, (ECPoint)p, (boolean)false);
                    ECPublicKeySpec pubKey = new ECPublicKeySpec(ecp, bcspec);
                    try {
                        keyfact = KeyFactory.getInstance("ECDSA", "BC");
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalStateException("ECDSA was an unknown algorithm", e);
                    }
                    catch (NoSuchProviderException e) {
                        throw new IllegalStateException("BouncyCastle was not found as a provider.", e);
                    }
                    ret = keyfact.generatePublic((KeySpec)pubKey);
                } else {
                    log.info((Object)"pkwithparams does not have any params.");
                }
            }
        } else {
            log.info((Object)("Either pk or pkwithparams is not a PublicKeyEC: " + pk.toString() + ", " + pkwithparams.toString()));
        }
        return ret;
    }

    public static int getKeyLength(PublicKey pk) {
        int len = -1;
        if (pk instanceof RSAPublicKey) {
            RSAPublicKey rsapub = (RSAPublicKey)pk;
            len = rsapub.getModulus().bitLength();
        } else if (pk instanceof JCEECPublicKey) {
            JCEECPublicKey ecpriv = (JCEECPublicKey)pk;
            org.bouncycastle.jce.spec.ECParameterSpec spec = ecpriv.getParameters();
            len = spec != null ? spec.getN().bitLength() : 0;
        } else if (pk instanceof BCECPublicKey) {
            BCECPublicKey ecpriv = (BCECPublicKey)pk;
            org.bouncycastle.jce.spec.ECParameterSpec spec = ecpriv.getParameters();
            len = spec != null ? spec.getN().bitLength() : 0;
        } else if (pk instanceof ECPublicKey) {
            ECPublicKey ecpriv = (ECPublicKey)pk;
            ECParameterSpec spec = ecpriv.getParams();
            len = spec != null ? spec.getOrder().bitLength() : 0;
        } else if (pk instanceof DSAPublicKey) {
            DSAPublicKey dsapub = (DSAPublicKey)pk;
            len = dsapub.getParams() != null ? dsapub.getParams().getP().bitLength() : dsapub.getY().bitLength();
        }
        return len;
    }

    public static AlgorithmParameterSpec getKeyGenSpec(PublicKey pk) {
        if (pk == null) {
            return null;
        }
        AlgorithmParameterSpec ret = null;
        if (pk instanceof RSAPublicKey) {
            log.debug((Object)"getKeyGenSpec: RSA");
            RSAPublicKey rpk = (RSAPublicKey)pk;
            ret = new RSAKeyGenParameterSpec(KeyTools.getKeyLength(pk), rpk.getPublicExponent());
        } else if (pk instanceof DSAPublicKey) {
            log.debug((Object)"getKeyGenSpec: DSA");
            DSAPublicKey dpk = (DSAPublicKey)pk;
            DSAParams params = dpk.getParams();
            ret = new DSAParameterSpec(params.getP(), params.getQ(), params.getG());
        } else if (pk instanceof ECPublicKey) {
            log.debug((Object)"getKeyGenSpec: ECPublicKey");
            ECPublicKey ecpub = (ECPublicKey)pk;
            ECParameterSpec sunsp = ecpub.getParams();
            EllipticCurve ecurve = new EllipticCurve(sunsp.getCurve().getField(), sunsp.getCurve().getA(), sunsp.getCurve().getB());
            ECParameterSpec params = new ECParameterSpec(ecurve, sunsp.getGenerator(), sunsp.getOrder(), sunsp.getCofactor());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fieldsize: " + params.getCurve().getField().getFieldSize()));
                EllipticCurve curve = params.getCurve();
                log.debug((Object)("CurveA: " + curve.getA().toString(16)));
                log.debug((Object)("CurveB: " + curve.getB().toString(16)));
                log.debug((Object)("CurveSeed: " + curve.getSeed()));
                ECFieldFp field = (ECFieldFp)curve.getField();
                log.debug((Object)("CurveSfield: " + field.getP().toString(16)));
                ECPoint p = params.getGenerator();
                log.debug((Object)("Generator: " + p.getAffineX().toString(16) + ", " + p.getAffineY().toString(16)));
                log.debug((Object)("Order: " + params.getOrder().toString(16)));
                log.debug((Object)("CoFactor: " + params.getCofactor()));
            }
            ret = params;
        } else if (pk instanceof JCEECPublicKey) {
            log.debug((Object)"getKeyGenSpec: JCEECPublicKey");
            JCEECPublicKey ecpub = (JCEECPublicKey)pk;
            org.bouncycastle.jce.spec.ECParameterSpec bcsp = ecpub.getParameters();
            ECCurve curve = bcsp.getCurve();
            ECNamedCurveSpec params = new ECNamedCurveSpec(null, curve, bcsp.getG(), bcsp.getN(), bcsp.getH());
            ret = params;
        }
        return ret;
    }

    public static KeyStore createP12(String alias, PrivateKey privKey, Certificate cert, Certificate cacert) throws IOException, KeyStoreException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        Certificate[] chain = cacert == null ? null : new Certificate[]{cacert};
        return KeyTools.createP12(alias, privKey, cert, chain);
    }

    public static KeyStore createP12(String alias, PrivateKey privKey, Certificate cert, Collection<Certificate> cacerts) throws IOException, KeyStoreException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        Certificate[] chain;
        if (cacerts == null) {
            chain = null;
        } else {
            chain = new Certificate[cacerts.size()];
            chain = cacerts.toArray(chain);
        }
        return KeyTools.createP12(alias, privKey, cert, chain);
    }

    public static KeyStore createP12(String alias, PrivateKey privKey, Certificate cert, Certificate[] cachain) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException {
        int i;
        if (log.isTraceEnabled()) {
            log.trace((Object)(">createP12: alias=" + alias + ", privKey, cert=" + CertTools.getSubjectDN(cert) + ", cachain.length=" + (cachain == null ? 0 : cachain.length)));
        }
        if (cert == null) {
            throw new IllegalArgumentException("Parameter cert cannot be null.");
        }
        int len = 1;
        if (cachain != null) {
            len += cachain.length;
        }
        Certificate[] chain = new Certificate[len];
        CertificateFactory cf = CertTools.getCertificateFactory();
        chain[0] = cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
        if (cachain != null) {
            for (i = 0; i < cachain.length; ++i) {
                X509Certificate tmpcert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cachain[i].getEncoded()));
                chain[i + 1] = tmpcert;
            }
        }
        if (chain.length > 1) {
            for (i = 1; i < chain.length; ++i) {
                X509Certificate cacert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(chain[i].getEncoded()));
                try {
                    PKCS12BagAttributeCarrier caBagAttr = (PKCS12BagAttributeCarrier)chain[i];
                    String cafriendly = CertTools.getPartFromDN(CertTools.getSubjectDN(cacert), "CN");
                    if (cafriendly == null) {
                        cafriendly = CertTools.getPartFromDN(CertTools.getSubjectDN(cacert), "O");
                        cafriendly = cafriendly == null ? ((cafriendly = CertTools.getPartFromDN(CertTools.getSubjectDN(cacert), "OU")) == null ? "CA_unknown" + i : cafriendly + i) : cafriendly + i;
                    }
                    caBagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString(cafriendly));
                    continue;
                }
                catch (ClassCastException e) {
                    log.error((Object)"ClassCastException setting BagAttributes, can not set friendly name: ", (Throwable)e);
                }
            }
        }
        try {
            PKCS12BagAttributeCarrier certBagAttr = (PKCS12BagAttributeCarrier)chain[0];
            certBagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString(alias));
            certBagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)KeyTools.createSubjectKeyId(chain[0].getPublicKey()));
        }
        catch (ClassCastException e) {
            log.error((Object)"ClassCastException setting BagAttributes, can not set friendly name: ", (Throwable)e);
        }
        try {
            KeyFactory keyfact = KeyFactory.getInstance(privKey.getAlgorithm(), "BC");
            PrivateKey pk = keyfact.generatePrivate(new PKCS8EncodedKeySpec(privKey.getEncoded()));
            try {
                PKCS12BagAttributeCarrier keyBagAttr = (PKCS12BagAttributeCarrier)pk;
                keyBagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString(alias));
                keyBagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)KeyTools.createSubjectKeyId(chain[0].getPublicKey()));
            }
            catch (ClassCastException e) {
                log.error((Object)"ClassCastException setting BagAttributes, can not set friendly name: ", (Throwable)e);
            }
            KeyStore store = KeyStore.getInstance("PKCS12", "BC");
            store.load(null, null);
            store.setKeyEntry(alias, pk, null, chain);
            if (log.isTraceEnabled()) {
                log.trace((Object)("<createP12: alias=" + alias + ", privKey, cert=" + CertTools.getSubjectDN(cert) + ", cachain.length=" + (cachain == null ? 0 : cachain.length)));
            }
            return store;
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("BouncyCastle provider was not found.", e);
        }
    }

    public static KeyStore createJKS(String alias, PrivateKey privKey, String password, X509Certificate cert, Certificate[] cachain) throws KeyStoreException {
        KeyStore store;
        if (log.isTraceEnabled()) {
            log.trace((Object)(">createJKS: alias=" + alias + ", privKey, cert=" + CertTools.getSubjectDN(cert) + ", cachain.length=" + (cachain == null ? 0 : cachain.length)));
        }
        String caAlias = "cacert";
        if (cert == null) {
            throw new IllegalArgumentException("Parameter cert cannot be null.");
        }
        int len = 1;
        if (cachain != null) {
            len += cachain.length;
        }
        Certificate[] chain = new Certificate[len];
        chain[0] = cert;
        if (cachain != null) {
            System.arraycopy(cachain, 0, chain, 1, cachain.length);
        }
        try {
            store = KeyStore.getInstance("JKS");
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("No JKS implementation found in provider", e);
        }
        try {
            store.load(null, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (CertificateException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        Certificate[] usercert = new X509Certificate[]{cert};
        try {
            store.setKeyEntry(alias, privKey, password.toCharArray(), usercert);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Keystore apparently hasn't been loaded?", e);
        }
        if (cachain != null) {
            if (!CertTools.isSelfSigned(cachain[cachain.length - 1])) {
                throw new IllegalArgumentException("Root cert is not self-signed.");
            }
            store.setCertificateEntry("cacert", cachain[cachain.length - 1]);
        }
        log.debug((Object)("Storing cert chain of length " + chain.length));
        store.setKeyEntry(alias, privKey, password.toCharArray(), chain);
        if (log.isTraceEnabled()) {
            log.trace((Object)("<createJKS: alias=" + alias + ", privKey, cert=" + CertTools.getSubjectDN(cert) + ", cachain.length=" + (cachain == null ? 0 : cachain.length)));
        }
        return store;
    }

    public static byte[] getSinglePemFromKeyStore(KeyStore ks, char[] password) throws KeyStoreException, CertificateEncodingException, IOException, UnrecoverableKeyException, NoSuchAlgorithmException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Enumeration<String> e = ks.aliases();
        String o = null;
        String alias = "";
        Key serverPrivKey = null;
        while (e.hasMoreElements()) {
            o = e.nextElement();
            if (!(o instanceof String) || !ks.isKeyEntry(o) || (serverPrivKey = (PrivateKey)ks.getKey(o, password)) == null) continue;
            alias = o;
            break;
        }
        byte[] privKeyEncoded = "".getBytes();
        if (serverPrivKey != null) {
            privKeyEncoded = serverPrivKey.getEncoded();
        }
        Certificate[] chain = KeyTools.getCertChain(ks, o);
        X509Certificate userX509Certificate = (X509Certificate)chain[0];
        byte[] output = userX509Certificate.getEncoded();
        String sn = CertTools.getSubjectDN(userX509Certificate);
        String subjectdnpem = sn.replace(',', '/');
        String issuerdnpem = CertTools.getIssuerDN(userX509Certificate).replace(',', '/');
        buffer.write(BAG_ATTRIBUTES);
        buffer.write(FRIENDLY_NAME);
        buffer.write(alias.getBytes());
        buffer.write(NL);
        buffer.write(BEGIN_PRIVATE_KEY);
        buffer.write(NL);
        byte[] privKey = Base64.encode(privKeyEncoded);
        buffer.write(privKey);
        buffer.write(NL);
        buffer.write(END_PRIVATE_KEY);
        buffer.write(NL);
        buffer.write(BAG_ATTRIBUTES);
        buffer.write(FRIENDLY_NAME);
        buffer.write(alias.getBytes());
        buffer.write(NL);
        buffer.write(SUBJECT_ATTRIBUTE);
        buffer.write(subjectdnpem.getBytes());
        buffer.write(NL);
        buffer.write(ISSUER_ATTRIBUTE);
        buffer.write(issuerdnpem.getBytes());
        buffer.write(NL);
        buffer.write(BEGIN_CERTIFICATE);
        buffer.write(NL);
        byte[] userCertB64 = Base64.encode(output);
        buffer.write(userCertB64);
        buffer.write(NL);
        buffer.write(END_CERTIFICATE);
        buffer.write(NL);
        if (!CertTools.isSelfSigned(userX509Certificate)) {
            for (int num = 1; num < chain.length; ++num) {
                X509Certificate tmpX509Cert = (X509Certificate)chain[num];
                sn = CertTools.getSubjectDN(tmpX509Cert);
                String cn = CertTools.getPartFromDN(sn, "CN");
                if (StringUtils.isEmpty((String)cn)) {
                    cn = "Unknown";
                }
                subjectdnpem = sn.replace(',', '/');
                issuerdnpem = CertTools.getIssuerDN(tmpX509Cert).replace(',', '/');
                buffer.write(BAG_ATTRIBUTES);
                buffer.write(FRIENDLY_NAME);
                buffer.write(cn.getBytes());
                buffer.write(NL);
                buffer.write(SUBJECT_ATTRIBUTE);
                buffer.write(subjectdnpem.getBytes());
                buffer.write(NL);
                buffer.write(ISSUER_ATTRIBUTE);
                buffer.write(issuerdnpem.getBytes());
                buffer.write(NL);
                byte[] tmpOutput = tmpX509Cert.getEncoded();
                buffer.write(BEGIN_CERTIFICATE);
                buffer.write(NL);
                byte[] tmpCACertB64 = Base64.encode(tmpOutput);
                buffer.write(tmpCACertB64);
                buffer.write(NL);
                buffer.write(END_CERTIFICATE);
                buffer.write(NL);
            }
        }
        return buffer.toByteArray();
    }

    public static String getAsPem(PublicKey publicKey) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)new OutputStreamWriter(baos));
        pemWriter.writeObject((Object)publicKey);
        pemWriter.close();
        return new String(baos.toByteArray(), "UTF8");
    }

    public static Certificate[] getCertChain(KeyStore keyStore, String privateKeyAlias) throws KeyStoreException {
        Certificate[] certchain;
        if (log.isTraceEnabled()) {
            log.trace((Object)(">getCertChain: alias='" + privateKeyAlias + "'"));
        }
        if ((certchain = keyStore.getCertificateChain(privateKeyAlias)) == null) {
            return null;
        }
        log.debug((Object)("Certchain retrieved from alias '" + privateKeyAlias + "' has length " + certchain.length));
        if (certchain.length < 1) {
            log.error((Object)("Cannot load certificate chain with alias '" + privateKeyAlias + "' from keystore."));
            if (log.isTraceEnabled()) {
                log.trace((Object)("<getCertChain: alias='" + privateKeyAlias + "', retlength=" + certchain.length));
            }
            return certchain;
        }
        if (certchain.length > 0 && CertTools.isSelfSigned(certchain[certchain.length - 1])) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Issuer='" + CertTools.getIssuerDN(certchain[certchain.length - 1]) + "'."));
                log.debug((Object)("Subject='" + CertTools.getSubjectDN(certchain[certchain.length - 1]) + "'."));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("<getCertChain: alias='" + privateKeyAlias + "', retlength=" + certchain.length));
            }
            return certchain;
        }
        ArrayList<Certificate> array = new ArrayList<Certificate>();
        for (int i = 0; i < certchain.length; ++i) {
            array.add(certchain[i]);
        }
        boolean stop = false;
        while (!stop) {
            X509Certificate cert = (X509Certificate)array.get(array.size() - 1);
            String ialias = CertTools.getPartFromDN(CertTools.getIssuerDN(cert), "CN");
            Certificate[] chain1 = keyStore.getCertificateChain(ialias);
            if (chain1 == null) {
                stop = true;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loaded certificate chain with length " + chain1.length + " with alias '" + ialias + "'."));
            }
            if (chain1.length == 0) {
                log.error((Object)"No RootCA certificate found!");
                stop = true;
            }
            for (int j = 0; j < chain1.length; ++j) {
                array.add(chain1[j]);
                if (!CertTools.isSelfSigned(chain1[j])) continue;
                stop = true;
            }
        }
        Certificate[] ret = new Certificate[array.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Certificate)array.get(i);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Issuer='" + CertTools.getIssuerDN(ret[i]) + "'."));
            log.debug((Object)("Subject='" + CertTools.getSubjectDN(ret[i]) + "'."));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("<getCertChain: alias='" + privateKeyAlias + "', retlength=" + ret.length));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubjectKeyIdentifier createSubjectKeyId(PublicKey pubKey) {
        SubjectKeyIdentifier subjectKeyIdentifier;
        ASN1InputStream pubKeyAsn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(pubKey.getEncoded()));
        try {
            ASN1Sequence keyASN1Sequence;
            ASN1Primitive keyObject = pubKeyAsn1InputStream.readObject();
            if (keyObject instanceof ASN1Sequence) {
                keyASN1Sequence = (ASN1Sequence)keyObject;
            } else {
                PublicKey altKey = (PublicKey)KeyFactory.getInstance(pubKey.getAlgorithm(), "BC").translateKey(pubKey);
                try (ASN1InputStream altKeyAsn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(altKey.getEncoded()));){
                    keyASN1Sequence = (ASN1Sequence)altKeyAsn1InputStream.readObject();
                }
            }
            BcX509ExtensionUtils x509ExtensionUtils = new BcX509ExtensionUtils();
            subjectKeyIdentifier = x509ExtensionUtils.createSubjectKeyIdentifier(new SubjectPublicKeyInfo(keyASN1Sequence));
        }
        catch (Throwable throwable) {
            try {
                pubKeyAsn1InputStream.close();
                throw throwable;
            }
            catch (Exception e) {
                RuntimeException e2 = new RuntimeException("error creating key");
                e2.initCause(e);
                throw e2;
            }
        }
        pubKeyAsn1InputStream.close();
        return subjectKeyIdentifier;
    }

    public static boolean isUsingExportableCryptography() {
        return CryptoProviderTools.isUsingExportableCryptography();
    }

    public static byte[] signData(PrivateKey privateKey, String signatureAlgorithm, byte[] data) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        Signature signer = Signature.getInstance(signatureAlgorithm);
        signer.initSign(privateKey);
        signer.update(data);
        return signer.sign();
    }

    public static boolean verifyData(PublicKey publicKey, String signatureAlgorithm, byte[] data, byte[] signature) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        Signature signer = Signature.getInstance(signatureAlgorithm);
        signer.initVerify(publicKey);
        signer.update(data);
        return signer.verify(signature);
    }

    public static void testKey(PrivateKey priv, PublicKey pub, String provider) throws InvalidKeyException {
        String testSigAlg;
        byte[] input = "Lillan gick pa vagen ut, motte dar en katt...".getBytes();
        Iterator<String> i = AlgorithmTools.getSignatureAlgorithms(pub).iterator();
        String tmp = i.hasNext() ? i.next() : null;
        String string = testSigAlg = tmp != null ? tmp : "SHA1WithRSA";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Testing keys with algorithm: " + pub.getAlgorithm()));
            log.debug((Object)("testSigAlg: " + testSigAlg));
            log.debug((Object)("provider: " + provider));
            log.trace((Object)("privateKey: " + priv));
            log.trace((Object)("privateKey class: " + priv.getClass().getName()));
            log.trace((Object)("publicKey: " + pub));
            log.trace((Object)("publicKey class: " + pub.getClass().getName()));
        }
        try {
            Signature signature;
            Provider prov = Security.getProvider(provider != null ? provider : "BC");
            Signature signature2 = Signature.getInstance(testSigAlg, prov);
            signature2.initSign(priv);
            signature2.update(input);
            byte[] signBV = signature2.sign();
            if (signBV == null) {
                throw new InvalidKeyException("Result from signing is null.");
            }
            if (log.isDebugEnabled()) {
                log.trace((Object)("Created signature of size: " + signBV.length));
                log.trace((Object)("Created signature: " + new String(Hex.encode((byte[])signBV))));
            }
            try {
                signature = Signature.getInstance(testSigAlg, "BC");
            }
            catch (NoSuchProviderException e) {
                throw new IllegalStateException("BouncyCastle was not found as a provider.", e);
            }
            signature.initVerify(pub);
            signature.update(input);
            if (!signature.verify(signBV)) {
                throw new InvalidKeyException("Not possible to sign and then verify with key pair.");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException("Exception testing key: " + e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new InvalidKeyException("Exception testing key: " + e.getMessage(), e);
        }
    }

    public static void printPublicKeyInfo(PublicKey publK, PrintStream ps) {
        if (publK instanceof RSAPublicKey) {
            ps.println("RSA key:");
            RSAPublicKey rsa = (RSAPublicKey)publK;
            ps.println("  modulus: " + rsa.getModulus().toString(16));
            ps.println("  public exponent: " + rsa.getPublicExponent().toString(16));
            return;
        }
        if (publK instanceof ECPublicKey) {
            ps.println("Elliptic curve key:");
            ECPublicKey ec = (ECPublicKey)publK;
            ps.println("  the affine x-coordinate: " + ec.getW().getAffineX().toString(16));
            ps.println("  the affine y-coordinate: " + ec.getW().getAffineY().toString(16));
            return;
        }
        if (publK instanceof DHPublicKey) {
            ps.println("DH key:");
            DHPublicKey dh = (DHPublicKey)publK;
            ps.println("  the public value y: " + dh.getY().toString(16));
            return;
        }
        if (publK instanceof DSAPublicKey) {
            ps.println("DSA key:");
            DSAPublicKey dsa = (DSAPublicKey)publK;
            ps.println("  the public value y: " + dsa.getY().toString(16));
            return;
        }
    }

    public static boolean isPrivateKeyExtractable(PrivateKey privK) {
        if (privK instanceof RSAPrivateKey) {
            RSAPrivateKey rsa = (RSAPrivateKey)privK;
            BigInteger result = rsa.getPrivateExponent();
            return result != null && result.bitLength() > 0;
        }
        if (privK instanceof ECPrivateKey) {
            ECPrivateKey ec = (ECPrivateKey)privK;
            BigInteger result = ec.getS();
            return result != null && result.bitLength() > 0;
        }
        if (privK instanceof DHPrivateKey) {
            DHPrivateKey dh = (DHPrivateKey)privK;
            BigInteger result = dh.getX();
            return result != null && result.bitLength() > 0;
        }
        if (privK instanceof DSAPrivateKey) {
            DSAPrivateKey dsa = (DSAPrivateKey)privK;
            BigInteger result = dsa.getX();
            return result != null && result.bitLength() > 0;
        }
        return false;
    }

    public static void checkValidKeyLength(String keyspec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int len;
        String keyAlg = KeyTools.keyspecToKeyalg(keyspec);
        if (keyAlg.equals("RSA")) {
            len = Integer.valueOf(keyspec);
        } else if (keyAlg.equals("DSA")) {
            len = Integer.valueOf(keyspec.substring(3));
        } else {
            KeyPair kp = KeyTools.genKeys(keyspec, keyAlg);
            len = KeyTools.getKeyLength(kp.getPublic());
        }
        KeyTools.checkValidKeyLength(keyAlg, len);
    }

    public static void checkValidKeyLength(PublicKey pk) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        String keyAlg = AlgorithmTools.getKeyAlgorithm(pk);
        int len = KeyTools.getKeyLength(pk);
        KeyTools.checkValidKeyLength(keyAlg, len);
    }

    public static void checkValidKeyLength(String keyAlg, int len) throws InvalidKeyException {
        boolean isDstu4145;
        boolean isEcdsa = "ECDSA".equals(keyAlg);
        boolean isGost3410 = AlgorithmTools.isGost3410Enabled() && "ECGOST3410".equals(keyAlg);
        boolean bl = isDstu4145 = AlgorithmTools.isDstu4145Enabled() && keyAlg.startsWith(CesecoreConfiguration.getOidDstu4145() + ".");
        if (isEcdsa || isGost3410 || isDstu4145) {
            if (len > 0 && len < 224) {
                String msg = intres.getLocalizedMessage("catoken.invalidkeylength", "ECDSA", "224", len);
                throw new InvalidKeyException(msg);
            }
        } else if (("RSA".equals(keyAlg) || "DSA".equals(keyAlg)) && len < 1024) {
            String msg = intres.getLocalizedMessage("catoken.invalidkeylength", "RSA/DSA", "1024", len);
            throw new InvalidKeyException(msg);
        }
    }

    public static AlgorithmParameterSpec dstuOidToAlgoParams(String dstuOid) {
        return new ECGenParameterSpec(dstuOid);
    }

    public static String keyspecToKeyalg(String keyspec) {
        if (StringUtils.isNumeric((String)keyspec)) {
            return "RSA";
        }
        if (keyspec.startsWith("DSA")) {
            return "DSA";
        }
        if (AlgorithmTools.isGost3410Enabled() && keyspec.startsWith("GostR3410-")) {
            return "ECGOST3410";
        }
        if (AlgorithmTools.isDstu4145Enabled() && keyspec.startsWith(CesecoreConfiguration.getOidDstu4145() + ".")) {
            return "DSTU4145";
        }
        return "ECDSA";
    }

    public static String shortenKeySpec(String keyspec) {
        if (keyspec.startsWith("DSA")) {
            return keyspec.substring(3);
        }
        return keyspec;
    }

    public static String keyalgspecToKeyspec(String keyalg, String keyspec) {
        if ("DSA".equals(keyalg)) {
            return "DSA" + keyspec;
        }
        return keyspec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKey getPublicKeyFromBytes(byte[] asn1EncodedPublicKey) {
        PublicKey pubKey = null;
        ASN1InputStream in = new ASN1InputStream(asn1EncodedPublicKey);
        try {
            SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance((Object)in.readObject());
            AlgorithmIdentifier keyAlg = keyInfo.getAlgorithm();
            X509EncodedKeySpec xKeySpec = new X509EncodedKeySpec(new DERBitString((ASN1Encodable)keyInfo).getBytes());
            KeyFactory keyFact = KeyFactory.getInstance(keyAlg.getAlgorithm().getId(), "BC");
            pubKey = keyFact.generatePublic(xKeySpec);
        }
        catch (IOException e) {
            log.debug((Object)"Unable to decode PublicKey.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.debug((Object)"Unable to decode PublicKey.", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            log.debug((Object)"Unable to decode PublicKey.", (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            log.debug((Object)"Unable to decode PublicKey.", (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                log.debug((Object)"Unable to close input stream.");
            }
        }
        return pubKey;
    }

    public static byte[] getBytesFromPEM(String pem, String beginMarker, String endMarker) {
        int start = pem.indexOf(beginMarker);
        int end = pem.indexOf(endMarker, start);
        if (start == -1 || end == -1) {
            log.debug((Object)("Could not find " + beginMarker + " and " + endMarker + " lines in PEM"));
            return null;
        }
        String base64 = pem.substring(start + beginMarker.length(), end);
        try {
            return Base64.decode(base64.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            log.debug((Object)"Invalid byte in PEM data");
            return null;
        }
    }

    public static byte[] getBytesFromPublicKeyFile(byte[] file) {
        String fileText = Charset.forName("ASCII").decode(ByteBuffer.wrap(file)).toString();
        byte[] asn1bytes = KeyTools.getBytesFromPEM(fileText, "-----BEGIN PUBLIC KEY-----", "-----END PUBLIC KEY-----");
        if (asn1bytes != null) {
            return asn1bytes;
        }
        return file;
    }
}

