/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.keys.util;

import java.io.Serializable;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class PublicKeyWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    final byte[] encodedKey;
    final String algorithm;
    transient PublicKey publicKey;

    public PublicKeyWrapper(PublicKey publicKey) {
        this.encodedKey = publicKey.getEncoded();
        this.algorithm = publicKey.getAlgorithm();
    }

    public PublicKey getPublicKey() {
        if (this.publicKey == null) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(this.algorithm, "BC");
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(this.encodedKey);
                this.publicKey = keyFactory.generatePublic(keySpec);
            }
            catch (NoSuchProviderException e) {
                throw new IllegalStateException("BouncyCastle was not a known provider.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Algorithm " + this.algorithm + " was not known at deserialisation", e);
            }
            catch (InvalidKeySpecException e) {
                throw new IllegalStateException("The incorrect key specification was implemented.", e);
            }
        }
        return this.publicKey;
    }
}

