/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import com.novell.ldap.LDAPDN;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PrivateKeyUsagePeriod;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.X509KeyUsage;
import org.bouncycastle.jce.provider.PKIXNameConstraintValidator;
import org.bouncycastle.jce.provider.PKIXNameConstraintValidatorException;
import org.bouncycastle.operator.BufferingContentSigner;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.encoders.Hex;
import org.cesecore.certificates.ca.IllegalNameException;
import org.cesecore.certificates.crl.RevokedCertInfo;
import org.cesecore.certificates.ocsp.SHA1DigestCalculator;
import org.cesecore.certificates.util.DnComponents;
import org.cesecore.config.OcspConfiguration;
import org.cesecore.internal.InternalResources;
import org.cesecore.util.Base64;
import org.cesecore.util.CeSecoreNameStyle;
import org.cesecore.util.CryptoProviderTools;
import org.cesecore.util.StringTools;
import org.ejbca.cvc.AuthorizationRole;
import org.ejbca.cvc.CVCAuthorizationTemplate;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.CardVerifiableCertificate;
import org.ejbca.cvc.CertificateParser;
import org.ejbca.cvc.exception.ConstructionException;
import org.ejbca.cvc.exception.ParseException;

public abstract class CertTools {
    private static final Logger log = Logger.getLogger(CertTools.class);
    private static final InternalResources intres = InternalResources.getInstance();
    public static final String EMAIL = "rfc822name";
    public static final String EMAIL1 = "email";
    public static final String EMAIL2 = "EmailAddress";
    public static final String EMAIL3 = "E";
    public static final String DNS = "dNSName";
    public static final String URI = "uniformResourceIdentifier";
    public static final String URI1 = "uri";
    public static final String URI2 = "uniformResourceId";
    public static final String IPADDR = "iPAddress";
    public static final String DIRECTORYNAME = "directoryName";
    public static final String KRB5PRINCIPAL = "krb5principal";
    public static final String KRB5PRINCIPAL_OBJECTID = "1.3.6.1.5.2.2";
    public static final String UPN = "upn";
    public static final String UPN_OBJECTID = "1.3.6.1.4.1.311.20.2.3";
    public static final String PERMANENTIDENTIFIER = "permanentIdentifier";
    public static final String PERMANENTIDENTIFIER_OBJECTID = "1.3.6.1.5.5.7.8.3";
    public static final String PERMANENTIDENTIFIER_SEP = "/";
    public static final String GUID = "guid";
    public static final String GUID_OBJECTID = "1.3.6.1.4.1.311.25.1";
    public static final String EFS_OBJECTID = "1.3.6.1.4.1.311.10.3.4";
    public static final String EFSR_OBJECTID = "1.3.6.1.4.1.311.10.3.4.1";
    public static final String MS_DOCUMENT_SIGNING_OBJECTID = "1.3.6.1.4.1.311.10.3.12";
    public static final String id_pkix = "1.3.6.1.5.5.7";
    public static final String id_kp = "1.3.6.1.5.5.7.3";
    public static final String id_pda = "1.3.6.1.5.5.7.9";
    public static final String id_pda_dateOfBirth = "1.3.6.1.5.5.7.9.1";
    public static final String id_pda_placeOfBirth = "1.3.6.1.5.5.7.9.2";
    public static final String id_pda_gender = "1.3.6.1.5.5.7.9.3";
    public static final String id_pda_countryOfCitizenship = "1.3.6.1.5.5.7.9.4";
    public static final String id_pda_countryOfResidence = "1.3.6.1.5.5.7.9.5";
    public static final String OID_MSTEMPLATE = "1.3.6.1.4.1.311.20.2";
    public static final String Intel_amt = "2.16.840.1.113741.1.2.3";
    public static final String id_ct_redacted_domains = "1.3.6.1.4.1.11129.2.4.6";
    private static final String[] EMAILIDS;
    public static final String BEGIN_CERTIFICATE_REQUEST = "-----BEGIN CERTIFICATE REQUEST-----";
    public static final String END_CERTIFICATE_REQUEST = "-----END CERTIFICATE REQUEST-----";
    public static final String BEGIN_KEYTOOL_CERTIFICATE_REQUEST = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    public static final String END_KEYTOOL_CERTIFICATE_REQUEST = "-----END NEW CERTIFICATE REQUEST-----";
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    public static final String BEGIN_PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----";
    public static final String END_PUBLIC_KEY = "-----END PUBLIC KEY-----";
    public static final String BEGIN_X509_CRL_KEY = "-----BEGIN X509 CRL-----";
    public static final String END_X509_CRL_KEY = "-----END X509 CRL-----";

    public static X500Name stringToBcX500Name(String dn) {
        X500NameStyle nameStyle = CeSecoreNameStyle.INSTANCE;
        return CertTools.stringToBcX500Name(dn, nameStyle, true);
    }

    public static X500Name stringToBcX500Name(String dn, boolean ldapOrder) {
        X500NameStyle nameStyle = CeSecoreNameStyle.INSTANCE;
        return CertTools.stringToBcX500Name(dn, nameStyle, ldapOrder);
    }

    public static X500Name stringToBcX500Name(String dn, X500NameStyle nameStyle, boolean ldaporder) {
        X500Name x500Name = CertTools.stringToUnorderedX500Name(dn, nameStyle);
        if (x500Name == null) {
            return null;
        }
        X500Name orderedX500Name = CertTools.getOrderedX500Name(x500Name, ldaporder, nameStyle);
        if (log.isTraceEnabled()) {
            log.trace((Object)(">stringToBcX500Name: x500Name=" + x500Name.toString() + " orderedX500Name=" + orderedX500Name.toString()));
        }
        return orderedX500Name;
    }

    public static X500Name stringToUnorderedX500Name(String dn, X500NameStyle nameStyle) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(">stringToUnorderedX500Name: " + dn));
        }
        if (dn == null) {
            return null;
        }
        if (dn.length() > 2 && dn.charAt(0) == '\"' && dn.charAt(dn.length() - 1) == '\"') {
            dn = dn.substring(1, dn.length() - 1);
        }
        X500NameBuilder nameBuilder = new X500NameBuilder(nameStyle);
        boolean quoted = false;
        boolean escapeNext = false;
        int currentStartPosition = -1;
        String currentPartName = null;
        for (int i = 0; i < dn.length(); ++i) {
            char current = dn.charAt(i);
            if (!escapeNext && current == '\"') {
                boolean bl = quoted = !quoted;
            }
            if (currentStartPosition == -1 && !quoted && !escapeNext && current == '=' && 1 <= i) {
                int startIndexOfPartName;
                int endIndexOfPartName;
                for (endIndexOfPartName = i; endIndexOfPartName > 0 && dn.charAt(endIndexOfPartName - 1) == ' '; --endIndexOfPartName) {
                }
                String endOfPartNameSearchChars = ", +";
                for (startIndexOfPartName = endIndexOfPartName - 1; startIndexOfPartName > 0 && ", +".indexOf(dn.charAt(startIndexOfPartName - 1)) == -1; --startIndexOfPartName) {
                }
                currentPartName = dn.substring(startIndexOfPartName, endIndexOfPartName);
                currentStartPosition = i + 1;
            }
            if (!(currentStartPosition == -1 || (quoted || escapeNext || current != ',' && current != '+') && i != dn.length() - 1)) {
                int endPosition;
                int n = endPosition = i == dn.length() - 1 ? dn.length() - 1 : i - 1;
                while (endPosition > currentStartPosition && dn.charAt(endPosition) == ' ') {
                    --endPosition;
                }
                while (endPosition > currentStartPosition && dn.charAt(currentStartPosition) == ' ') {
                    ++currentStartPosition;
                }
                if (currentStartPosition < dn.length() && dn.charAt(currentStartPosition) == '\"' && dn.charAt(endPosition) == '\"') {
                    ++currentStartPosition;
                    --endPosition;
                }
                String currentValue = dn.substring(currentStartPosition, endPosition + 1);
                currentValue = CertTools.unescapeValue(new StringBuilder(currentValue)).toString();
                try {
                    ASN1ObjectIdentifier oid = DnComponents.getOid(currentPartName);
                    if (oid == null) {
                        oid = new ASN1ObjectIdentifier(currentPartName);
                    }
                    nameBuilder.addRDN(oid, currentValue);
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)("Unknown DN component ignored and silently dropped: " + currentPartName));
                }
                currentStartPosition = -1;
                currentPartName = null;
            }
            if (escapeNext) {
                escapeNext = false;
                continue;
            }
            if (quoted || current != '\\') continue;
            escapeNext = true;
        }
        X500Name x500Name = nameBuilder.build();
        if (log.isTraceEnabled()) {
            log.trace((Object)(">stringToUnorderedX500Name: x500Name=" + x500Name.toString()));
        }
        return x500Name;
    }

    private static StringBuilder unescapeValue(StringBuilder sb) {
        boolean esq = false;
        int index = 0;
        while (index < sb.length() - 1) {
            if (!esq && sb.charAt(index) == '\\' && sb.charAt(index + 1) != '#') {
                esq = true;
                sb.deleteCharAt(index);
                continue;
            }
            esq = false;
            ++index;
        }
        return sb;
    }

    public static String getUnescapedPlus(String value) {
        StringBuilder buf = new StringBuilder(value);
        int end = buf.length();
        for (int index = 0; index < end; ++index) {
            char c;
            if (buf.charAt(index) != '\\' || index + 1 == end || (c = buf.charAt(index + 1)) != '+') continue;
            buf.deleteCharAt(index);
            --end;
        }
        return buf.toString();
    }

    public static String handleUnescapedPlus(String dn) {
        if (dn == null) {
            return dn;
        }
        StringBuilder buf = new StringBuilder(dn);
        int end = buf.length();
        for (int index = 0; index < end; ++index) {
            if (buf.charAt(index) == '+') {
                log.warn((Object)("DN \"" + dn + "\" contains an unescaped '+'-character that will be automatically escaped. RFC 2253 reservs this " + "for multi-valued RelativeDistinguishedNames. Encourage clients to use '\\+' instead, since future behaviour might change."));
                buf.insert(index, '\\');
                ++index;
                continue;
            }
            if (buf.charAt(index) != '\\') continue;
            ++index;
        }
        return buf.toString();
    }

    public static String stringToBCDNString(String dn) {
        if (CertTools.isDNReversed(dn = CertTools.handleUnescapedPlus(dn))) {
            dn = CertTools.reverseDN(dn);
        }
        String ret = null;
        X500Name name = CertTools.stringToBcX500Name(dn);
        if (name != null) {
            ret = name.toString();
        }
        if (ret != null && ret.length() > 250) {
            log.info((Object)("Warning! DN is more than 250 characters long. Some databases have only 250 characters in the database for SubjectDN. Clipping may occur! DN (" + ret.length() + " chars): " + ret));
        }
        return ret;
    }

    public static ArrayList<String> getEmailFromDN(String dn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(">getEmailFromDN(" + dn + ")"));
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < EMAILIDS.length; ++i) {
            List<String> emails = CertTools.getPartsFromDN(dn, EMAILIDS[i]);
            if (emails.isEmpty()) continue;
            ret.addAll(emails);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("<getEmailFromDN(" + dn + "): " + ret.size()));
        }
        return ret;
    }

    public static String getEMailAddress(Certificate certificate) {
        log.debug((Object)"Searching for EMail Address in SubjectAltName");
        if (certificate == null) {
            return null;
        }
        if (certificate instanceof X509Certificate) {
            X509Certificate x509cert = (X509Certificate)certificate;
            try {
                if (x509cert.getSubjectAlternativeNames() != null) {
                    for (List<?> item : x509cert.getSubjectAlternativeNames()) {
                        Integer type = (Integer)item.get(0);
                        if (type != 1) continue;
                        return (String)item.get(1);
                    }
                }
            }
            catch (CertificateParsingException e) {
                log.error((Object)"Error parsing certificate: ", (Throwable)e);
            }
            log.debug((Object)"Searching for EMail Address in Subject DN");
            ArrayList<String> emails = CertTools.getEmailFromDN(x509cert.getSubjectDN().getName());
            if (!emails.isEmpty()) {
                return emails.get(0);
            }
        }
        return null;
    }

    public static String reverseDN(String dn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(">reverseDN: dn: " + dn));
        }
        String ret = null;
        if (dn != null) {
            BasicX509NameTokenizer xt = new BasicX509NameTokenizer(dn);
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            while (xt.hasMoreTokens()) {
                String o = xt.nextToken();
                if (!first) {
                    buf.insert(0, ",");
                } else {
                    first = false;
                }
                buf.insert(0, o);
            }
            if (buf.length() > 0) {
                ret = buf.toString();
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("<reverseDN: resulting dn: " + ret));
        }
        return ret;
    }

    public static boolean isDNReversed(String dn) {
        boolean ret = false;
        if (dn != null) {
            String first = null;
            String last = null;
            X509NameTokenizer xt = new X509NameTokenizer(dn);
            if (xt.hasMoreTokens()) {
                first = xt.nextToken().trim();
            }
            while (xt.hasMoreTokens()) {
                last = xt.nextToken().trim();
            }
            String[] dNObjects = DnComponents.getDnObjects(true);
            if (first != null && last != null) {
                first = first.substring(0, first.indexOf(61));
                last = last.substring(0, last.indexOf(61));
                int firsti = 0;
                int lasti = 0;
                for (int i = 0; i < dNObjects.length; ++i) {
                    if (first.equalsIgnoreCase(dNObjects[i])) {
                        firsti = i;
                    }
                    if (!last.equalsIgnoreCase(dNObjects[i])) continue;
                    lasti = i;
                }
                if (lasti < firsti) {
                    ret = true;
                }
            }
        }
        return ret;
    }

    public static boolean dnHasMultipleComponents(String dn) {
        X509NameTokenizer xt = new X509NameTokenizer(dn);
        if (xt.hasMoreTokens()) {
            xt.nextToken();
            return xt.hasMoreTokens();
        }
        return false;
    }

    public static String getPartFromDN(String dn, String dnpart) {
        String part = null;
        List<String> dnParts = CertTools.getPartsFromDNInternal(dn, dnpart, true);
        if (!dnParts.isEmpty()) {
            part = dnParts.get(0);
        }
        return part;
    }

    public static List<String> getPartsFromDN(String dn, String dnpart) {
        return CertTools.getPartsFromDNInternal(dn, dnpart, false);
    }

    public static List<String> getPartsFromDNInternal(String dn, String dnPart, boolean onlyReturnFirstMatch) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(">getPartsFromDNInternal: dn:'" + dn + "', dnpart=" + dnPart + ", onlyReturnFirstMatch=" + onlyReturnFirstMatch));
        }
        ArrayList<String> parts = new ArrayList<String>();
        if (dn != null && dnPart != null) {
            String dnPartLowerCase = dnPart.toLowerCase();
            int dnPartLenght = dnPart.length();
            boolean quoted = false;
            boolean escapeNext = false;
            int currentStartPosition = -1;
            for (int i = 0; i < dn.length(); ++i) {
                char current = dn.charAt(i);
                if (!escapeNext && current == '\"') {
                    boolean bl = quoted = !quoted;
                }
                if (!(quoted || escapeNext || current != '=' || dnPartLenght > i || i - dnPartLenght - 1 >= 0 && Character.isLetter(dn.charAt(i - dnPartLenght - 1)))) {
                    boolean match = true;
                    for (int j = 0; j < dnPartLenght; ++j) {
                        if (Character.toLowerCase(dn.charAt(i - dnPartLenght + j)) == dnPartLowerCase.charAt(j)) continue;
                        match = false;
                        break;
                    }
                    if (match) {
                        currentStartPosition = i + 1;
                    }
                }
                if (!(currentStartPosition == -1 || (quoted || escapeNext || current != ',' && current != '+') && i != dn.length() - 1)) {
                    int endPosition;
                    int n = endPosition = i == dn.length() - 1 ? dn.length() - 1 : i - 1;
                    while (endPosition > currentStartPosition && dn.charAt(endPosition) == ' ') {
                        --endPosition;
                    }
                    while (endPosition > currentStartPosition && dn.charAt(currentStartPosition) == ' ') {
                        ++currentStartPosition;
                    }
                    if (dn.charAt(currentStartPosition) == '\"' && dn.charAt(endPosition) == '\"') {
                        ++currentStartPosition;
                        --endPosition;
                    }
                    parts.add(dn.substring(currentStartPosition, endPosition + 1));
                    if (onlyReturnFirstMatch) break;
                    currentStartPosition = -1;
                }
                if (escapeNext) {
                    escapeNext = false;
                    continue;
                }
                if (quoted || current != '\\') continue;
                escapeNext = true;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("<getPartsFromDNInternal: resulting DN part=" + ((Object)parts).toString()));
        }
        return parts;
    }

    public static ArrayList<String> getCustomOids(String dn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(">getCustomOids: dn:'" + dn));
        }
        ArrayList<String> parts = new ArrayList<String>();
        if (dn != null) {
            X509NameTokenizer xt = new X509NameTokenizer(dn);
            while (xt.hasMoreTokens()) {
                String o = xt.nextToken().trim();
                try {
                    String oid;
                    int i = o.indexOf(61);
                    if (i <= 2 || o.charAt(1) != '.' || parts.contains(oid = o.substring(0, i))) continue;
                    new ASN1ObjectIdentifier(oid);
                    parts.add(oid);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("<getCustomOids: resulting DN part=" + parts.toString()));
        }
        return parts;
    }

    public static String getSubjectDN(Certificate cert) {
        return CertTools.getDN(cert, 1);
    }

    public static String getIssuerDN(Certificate cert) {
        return CertTools.getDN(cert, 2);
    }

    private static String getDN(Certificate cert, int which) {
        String ret = null;
        if (cert == null) {
            return null;
        }
        if (cert instanceof X509Certificate) {
            try {
                CertificateFactory cf = CertTools.getCertificateFactory();
                X509Certificate x509cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
                String dn = null;
                dn = which == 1 ? x509cert.getSubjectDN().toString() : x509cert.getIssuerDN().toString();
                ret = CertTools.stringToBCDNString(dn);
            }
            catch (CertificateException ce) {
                log.info((Object)("Could not get DN from X509Certificate. " + ce.getMessage()));
                log.debug((Object)"", (Throwable)ce);
                return null;
            }
        }
        if (StringUtils.equals((String)cert.getType(), (String)"CVC")) {
            CardVerifiableCertificate cvccert = (CardVerifiableCertificate)cert;
            try {
                Object rf = null;
                rf = which == 1 ? cvccert.getCVCertificate().getCertificateBody().getHolderReference() : cvccert.getCVCertificate().getCertificateBody().getAuthorityReference();
                if (rf != null) {
                    String dn = "";
                    if (rf.getMnemonic() != null) {
                        if (StringUtils.isNotEmpty((String)dn)) {
                            dn = dn + ", ";
                        }
                        dn = dn + "CN=" + rf.getMnemonic();
                    }
                    if (rf.getCountry() != null) {
                        if (StringUtils.isNotEmpty((String)dn)) {
                            dn = dn + ", ";
                        }
                        dn = dn + "C=" + rf.getCountry();
                    }
                    ret = CertTools.stringToBCDNString(dn);
                }
            }
            catch (NoSuchFieldException e) {
                log.error((Object)"NoSuchFieldException: ", (Throwable)e);
                return null;
            }
        }
        return ret;
    }

    public static BigInteger getSerialNumber(Certificate cert) {
        if (cert == null) {
            throw new IllegalArgumentException("Null input");
        }
        BigInteger ret = null;
        if (cert instanceof X509Certificate) {
            X509Certificate xcert = (X509Certificate)cert;
            ret = xcert.getSerialNumber();
        } else if (StringUtils.equals((String)cert.getType(), (String)"CVC")) {
            CardVerifiableCertificate cvccert = (CardVerifiableCertificate)cert;
            try {
                String sequence = cvccert.getCVCertificate().getCertificateBody().getHolderReference().getSequence();
                ret = CertTools.getSerialNumberFromString(sequence);
            }
            catch (NoSuchFieldException e) {
                log.error((Object)"getSerialNumber: NoSuchFieldException: ", (Throwable)e);
                ret = BigInteger.valueOf(0L);
            }
        } else {
            throw new IllegalArgumentException("getSerialNumber: Certificate of type " + cert.getType() + " is not implemented");
        }
        return ret;
    }

    public static BigInteger getSerialNumberFromString(String sernoString) {
        BigInteger ret;
        if (sernoString == null) {
            throw new IllegalArgumentException("getSerialNumberFromString: cert is null");
        }
        if (sernoString.length() != 5) {
            ret = new BigInteger(sernoString, 16);
        } else {
            try {
                if (NumberUtils.isNumber((String)sernoString)) {
                    ret = NumberUtils.createBigInteger((String)sernoString);
                } else {
                    log.info((Object)"getSerialNumber: Sequence is not a numeric string, trying to extract numerical sequence part.");
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < sernoString.length(); ++i) {
                        char c = sernoString.charAt(i);
                        if (!CharUtils.isAsciiNumeric((char)c)) continue;
                        buf.append(c);
                    }
                    if (buf.length() > 0) {
                        ret = NumberUtils.createBigInteger((String)buf.toString());
                    } else {
                        log.info((Object)"getSerialNumber: can not extract numeric sequence part, trying alfanumeric value (radix 36).");
                        if (sernoString.matches("[0-9A-Z]{1,5}")) {
                            int numSeq = Integer.parseInt(sernoString, 36);
                            ret = BigInteger.valueOf(numSeq);
                        } else {
                            log.info((Object)"getSerialNumber: Sequence does not contain any numeric parts, returning 0.");
                            ret = BigInteger.valueOf(0L);
                        }
                    }
                }
            }
            catch (NumberFormatException e) {
                log.debug((Object)("getSerialNumber: NumberFormatException for sequence: " + sernoString));
                ret = BigInteger.valueOf(0L);
            }
        }
        return ret;
    }

    public static String getSerialNumberAsString(Certificate cert) {
        String ret = null;
        if (cert == null) {
            throw new IllegalArgumentException("getSerialNumber: cert is null");
        }
        if (cert instanceof X509Certificate) {
            X509Certificate xcert = (X509Certificate)cert;
            ret = xcert.getSerialNumber().toString(16).toUpperCase();
        } else if (StringUtils.equals((String)cert.getType(), (String)"CVC")) {
            CardVerifiableCertificate cvccert = (CardVerifiableCertificate)cert;
            try {
                ret = cvccert.getCVCertificate().getCertificateBody().getHolderReference().getSequence();
            }
            catch (NoSuchFieldException e) {
                log.error((Object)"getSerialNumber: NoSuchFieldException: ", (Throwable)e);
                ret = "N/A";
            }
        } else {
            throw new IllegalArgumentException("getSerialNumber: Certificate of type " + cert.getType() + " is not implemented");
        }
        return ret;
    }

    public static byte[] getSignature(Certificate cert) {
        byte[] ret = null;
        if (cert == null) {
            ret = new byte[]{};
        } else if (cert instanceof X509Certificate) {
            X509Certificate xcert = (X509Certificate)cert;
            ret = xcert.getSignature();
        } else if (StringUtils.equals((String)cert.getType(), (String)"CVC")) {
            CardVerifiableCertificate cvccert = (CardVerifiableCertificate)cert;
            try {
                ret = cvccert.getCVCertificate().getSignature();
            }
            catch (NoSuchFieldException e) {
                log.error((Object)"NoSuchFieldException: ", (Throwable)e);
                return null;
            }
        }
        return ret;
    }

    public static String getIssuerDN(X509CRL crl) {
        String dn = null;
        try {
            CertificateFactory cf = CertTools.getCertificateFactory();
            X509CRL x509crl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(crl.getEncoded()));
            dn = x509crl.getIssuerDN().toString();
        }
        catch (CRLException ce) {
            log.error((Object)"CRLException: ", (Throwable)ce);
            return null;
        }
        return CertTools.stringToBCDNString(dn);
    }

    public static Date getNotBefore(Certificate cert) {
        Date ret = null;
        if (cert == null) {
            throw new IllegalArgumentException("getNotBefore: cert is null");
        }
        if (cert instanceof X509Certificate) {
            X509Certificate xcert = (X509Certificate)cert;
            ret = xcert.getNotBefore();
        } else if (StringUtils.equals((String)cert.getType(), (String)"CVC")) {
            CardVerifiableCertificate cvccert = (CardVerifiableCertificate)cert;
            try {
                ret = cvccert.getCVCertificate().getCertificateBody().getValidFrom();
            }
            catch (NoSuchFieldException e) {
                log.debug((Object)("NoSuchFieldException: " + e.getMessage()));
                return null;
            }
        }
        return ret;
    }

    public static Date getNotAfter(Certificate cert) {
        Date ret = null;
        if (cert == null) {
            throw new IllegalArgumentException("getNotAfter: cert is null");
        }
        if (cert instanceof X509Certificate) {
            X509Certificate xcert = (X509Certificate)cert;
            ret = xcert.getNotAfter();
        } else if (StringUtils.equals((String)cert.getType(), (String)"CVC")) {
            CardVerifiableCertificate cvccert = (CardVerifiableCertificate)cert;
            try {
                ret = cvccert.getCVCertificate().getCertificateBody().getValidTo();
            }
            catch (NoSuchFieldException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NoSuchFieldException: " + e.getMessage()));
                }
                return null;
            }
        }
        return ret;
    }

    public static CertificateFactory getCertificateFactory(String provider) {
        String prov = provider == null ? "BC" : provider;
        if ("BC".equals(prov)) {
            CryptoProviderTools.installBCProviderIfNotAvailable();
        }
        try {
            return CertificateFactory.getInstance("X.509", prov);
        }
        catch (NoSuchProviderException nspe) {
            log.error((Object)"NoSuchProvider: ", (Throwable)nspe);
        }
        catch (CertificateException ce) {
            log.error((Object)"CertificateException: ", (Throwable)ce);
        }
        return null;
    }

    public static CertificateFactory getCertificateFactory() {
        return CertTools.getCertificateFactory("BC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Certificate> getCertsFromPEM(String certFilename) throws FileNotFoundException, CertificateParsingException {
        List<Certificate> certs;
        if (log.isTraceEnabled()) {
            log.trace((Object)(">getCertfromPEM: certFilename=" + certFilename));
        }
        FileInputStream inStrm = null;
        try {
            inStrm = new FileInputStream(certFilename);
            certs = CertTools.getCertsFromPEM(inStrm);
        }
        finally {
            if (inStrm != null) {
                try {
                    ((InputStream)inStrm).close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not clode input stream", e);
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("<getCertfromPEM: certFile=" + certFilename));
        }
        return certs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Certificate> getCertsFromPEM(InputStream certstream) throws CertificateParsingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)">getCertfromPEM");
        }
        ArrayList<Certificate> ret = new ArrayList<Certificate>();
        String beginKeyTrust = "-----BEGIN TRUSTED CERTIFICATE-----";
        String endKeyTrust = "-----END TRUSTED CERTIFICATE-----";
        BufferedReader bufRdr = null;
        ByteArrayOutputStream ostr = null;
        PrintStream opstr = null;
        try {
            try {
                bufRdr = new BufferedReader(new InputStreamReader(certstream));
                while (bufRdr.ready()) {
                    String temp;
                    ostr = new ByteArrayOutputStream();
                    opstr = new PrintStream(ostr);
                    while ((temp = bufRdr.readLine()) != null && !temp.equals(BEGIN_CERTIFICATE) && !temp.equals(beginKeyTrust)) {
                    }
                    if (temp == null) {
                        if (ret.isEmpty()) {
                            throw new CertificateParsingException("Error in " + certstream.toString() + ", missing " + BEGIN_CERTIFICATE + " boundary");
                        }
                        break;
                    }
                    while ((temp = bufRdr.readLine()) != null && !temp.equals(END_CERTIFICATE) && !temp.equals(endKeyTrust)) {
                        opstr.print(temp);
                    }
                    if (temp == null) {
                        throw new IllegalArgumentException("Error in " + certstream.toString() + ", missing " + END_CERTIFICATE + " boundary");
                    }
                    opstr.close();
                    byte[] certbuf = Base64.decode(ostr.toByteArray());
                    ostr.close();
                    Certificate cert = CertTools.getCertfromByteArray(certbuf);
                    ret.add(cert);
                }
            }
            finally {
                if (bufRdr != null) {
                    bufRdr.close();
                }
                if (opstr != null) {
                    opstr.close();
                }
                if (ostr != null) {
                    ostr.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception caught when attempting to read stream, see underlying IOException", e);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("<getcertfromPEM:" + ret.size()));
        }
        return ret;
    }

    public static Collection<Certificate> getCertCollectionFromArray(Certificate[] certs, String provider) throws CertificateException, NoSuchProviderException {
        if (log.isTraceEnabled()) {
            log.trace((Object)(">getCertCollectionFromArray: " + provider));
        }
        ArrayList<Certificate> ret = new ArrayList<Certificate>();
        String prov = provider;
        if (prov == null) {
            prov = "BC";
        }
        for (int i = 0; i < certs.length; ++i) {
            Certificate cert = certs[i];
            Certificate newcert = CertTools.getCertfromByteArray(cert.getEncoded(), prov);
            ret.add(newcert);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("<getCertCollectionFromArray: " + ret.size()));
        }
        return ret;
    }

    @Deprecated
    public static byte[] getPEMFromCerts(Collection<Certificate> certs) throws CertificateException {
        return CertTools.getPemFromCertificateChain(certs);
    }

    public static byte[] getPemFromCertificateChain(Collection<Certificate> certs) throws CertificateEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(baos);
        for (Certificate certificate : certs) {
            printStream.println("Subject: " + CertTools.getSubjectDN(certificate));
            printStream.println("Issuer: " + CertTools.getIssuerDN(certificate));
            CertTools.writeAsPemEncoded(printStream, certificate.getEncoded(), BEGIN_CERTIFICATE, END_CERTIFICATE);
        }
        printStream.close();
        return baos.toByteArray();
    }

    public static byte[] getPEMFromCrl(byte[] crlBytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(baos);
        CertTools.writeAsPemEncoded(printStream, crlBytes, BEGIN_X509_CRL_KEY, END_X509_CRL_KEY);
        printStream.close();
        return baos.toByteArray();
    }

    public static byte[] getPEMFromPublicKey(byte[] publicKeyBytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(baos);
        CertTools.writeAsPemEncoded(printStream, publicKeyBytes, BEGIN_PUBLIC_KEY, END_PUBLIC_KEY);
        printStream.close();
        return baos.toByteArray();
    }

    public static byte[] getPEMFromCertificateRequest(byte[] certificateRequestBytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(baos);
        CertTools.writeAsPemEncoded(printStream, certificateRequestBytes, BEGIN_CERTIFICATE_REQUEST, END_CERTIFICATE_REQUEST);
        printStream.close();
        return baos.toByteArray();
    }

    private static void writeAsPemEncoded(PrintStream printStream, byte[] unencodedData, String beginKey, String endKey) {
        printStream.println(beginKey);
        printStream.println(new String(Base64.encode(unencodedData)));
        printStream.println(endKey);
    }

    public static Certificate getCertfromByteArray(byte[] cert, String provider) throws CertificateParsingException {
        Certificate ret = null;
        String prov = provider;
        if (provider == null) {
            prov = "BC";
        }
        try {
            CertificateFactory cf = CertTools.getCertificateFactory(prov);
            ret = cf.generateCertificate(new ByteArrayInputStream(cert));
        }
        catch (CertificateException e) {
            log.debug((Object)"CertificateException trying to read X509Certificate.", (Throwable)e);
        }
        if (ret == null) {
            try {
                CVCertificate parsedObject = CertificateParser.parseCertificate((byte[])cert);
                ret = new CardVerifiableCertificate(parsedObject);
            }
            catch (ParseException e) {
                log.debug((Object)"ParseException trying to read CVCCertificate.", (Throwable)e);
            }
            catch (ConstructionException e) {
                log.debug((Object)"ConstructionException trying to read CVCCertificate.", (Throwable)e);
            }
        }
        if (ret == null) {
            throw new CertificateParsingException("No certificate could be parsed from byte array. See debug logs for details.");
        }
        return ret;
    }

    public static Certificate getCertfromByteArray(byte[] cert) throws CertificateParsingException {
        return CertTools.getCertfromByteArray(cert, "BC");
    }

    public static X509CRL getCRLfromByteArray(byte[] crl) throws CRLException {
        log.trace((Object)">getCRLfromByteArray");
        CertificateFactory cf = CertTools.getCertificateFactory();
        X509CRL x509crl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(crl));
        log.trace((Object)"<getCRLfromByteArray");
        return x509crl;
    }

    public static boolean isSelfSigned(Certificate cert) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(">isSelfSigned: cert: " + CertTools.getIssuerDN(cert) + "\n" + CertTools.getSubjectDN(cert)));
        }
        boolean ret = CertTools.getSubjectDN(cert).equals(CertTools.getIssuerDN(cert));
        if (log.isTraceEnabled()) {
            log.trace((Object)("<isSelfSigned:" + ret));
        }
        return ret;
    }

    public static boolean isCertificateValid(X509Certificate signerCert) {
        try {
            signerCert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            log.error((Object)intres.getLocalizedMessage("ocsp.errorcerthasexpired", signerCert.getSerialNumber(), signerCert.getIssuerDN()));
            return false;
        }
        catch (CertificateNotYetValidException e) {
            log.error((Object)intres.getLocalizedMessage("ocsp.errornotyetvalid", signerCert.getSerialNumber(), signerCert.getIssuerDN()));
            return false;
        }
        long warnBeforeExpirationTime = OcspConfiguration.getWarningBeforeExpirationTime();
        if (warnBeforeExpirationTime < 1L) {
            return true;
        }
        Date warnDate = new Date(new Date().getTime() + warnBeforeExpirationTime);
        try {
            signerCert.checkValidity(warnDate);
        }
        catch (CertificateExpiredException e) {
            log.warn((Object)intres.getLocalizedMessage("ocsp.warncertwillexpire", signerCert.getSerialNumber(), signerCert.getIssuerDN(), signerCert.getNotAfter()));
        }
        catch (CertificateNotYetValidException e) {
            throw new Error("This should never happen.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Time for \"certificate will soon expire\" not yet reached. You will be warned after: " + new Date(signerCert.getNotAfter().getTime() - warnBeforeExpirationTime)));
        }
        return true;
    }

    public static boolean isCA(Certificate cert) {
        if (log.isTraceEnabled()) {
            log.trace((Object)">isCA");
        }
        boolean ret = false;
        if (cert instanceof X509Certificate) {
            X509Certificate x509cert = (X509Certificate)cert;
            if (x509cert.getBasicConstraints() > -1) {
                ret = true;
            }
        } else if (StringUtils.equals((String)cert.getType(), (String)"CVC")) {
            CardVerifiableCertificate cvccert = (CardVerifiableCertificate)cert;
            try {
                CVCAuthorizationTemplate templ = cvccert.getCVCertificate().getCertificateBody().getAuthorizationTemplate();
                AuthorizationRole role = templ.getAuthorizationField().getAuthRole();
                if (role.isCVCA() || role.isDV()) {
                    ret = true;
                }
            }
            catch (NoSuchFieldException e) {
                log.error((Object)"NoSuchFieldException: ", (Throwable)e);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("<isCA:" + ret));
        }
        return ret;
    }

    public static boolean isOCSPCert(X509Certificate cert) {
        List<String> keyUsages;
        try {
            keyUsages = cert.getExtendedKeyUsage();
        }
        catch (CertificateParsingException e) {
            return false;
        }
        return keyUsages != null && keyUsages.contains(KeyPurposeId.id_kp_OCSPSigning.getId());
    }

    public static X509Certificate genSelfCert(String dn, long validity, String policyId, PrivateKey privKey, PublicKey pubKey, String sigAlg, boolean isCA) throws OperatorCreationException, CertificateException {
        return CertTools.genSelfCert(dn, validity, policyId, privKey, pubKey, sigAlg, isCA, "BC");
    }

    public static X509Certificate genSelfCert(String dn, long validity, String policyId, PrivateKey privKey, PublicKey pubKey, String sigAlg, boolean isCA, String provider, boolean ldapOrder) throws CertificateParsingException, OperatorCreationException {
        int keyUsage = isCA ? 6 : 0;
        return CertTools.genSelfCertForPurpose(dn, validity, policyId, privKey, pubKey, sigAlg, isCA, keyUsage, null, null, provider, ldapOrder);
    }

    public static X509Certificate genSelfCert(String dn, long validity, String policyId, PrivateKey privKey, PublicKey pubKey, String sigAlg, boolean isCA, String provider) throws OperatorCreationException, CertificateException {
        return CertTools.genSelfCert(dn, validity, policyId, privKey, pubKey, sigAlg, isCA, provider, true);
    }

    public static X509Certificate genSelfCertForPurpose(String dn, long validity, String policyId, PrivateKey privKey, PublicKey pubKey, String sigAlg, boolean isCA, int keyusage, boolean ldapOrder) throws CertificateParsingException, OperatorCreationException {
        return CertTools.genSelfCertForPurpose(dn, validity, policyId, privKey, pubKey, sigAlg, isCA, keyusage, null, null, "BC", ldapOrder);
    }

    public static X509Certificate genSelfCertForPurpose(String dn, long validity, String policyId, PrivateKey privKey, PublicKey pubKey, String sigAlg, boolean isCA, int keyusage, Date privateKeyNotBefore, Date privateKeyNotAfter, String provider) throws CertificateParsingException, OperatorCreationException {
        return CertTools.genSelfCertForPurpose(dn, validity, policyId, privKey, pubKey, sigAlg, isCA, keyusage, privateKeyNotBefore, privateKeyNotAfter, provider, true);
    }

    public static X509Certificate genSelfCertForPurpose(String dn, long validity, String policyId, PrivateKey privKey, PublicKey pubKey, String sigAlg, boolean isCA, int keyusage, Date privateKeyNotBefore, Date privateKeyNotAfter, String provider, boolean ldapOrder) throws CertificateParsingException, OperatorCreationException {
        try {
            return CertTools.genSelfCertForPurpose(dn, validity, policyId, privKey, pubKey, sigAlg, isCA, keyusage, privateKeyNotBefore, privateKeyNotAfter, provider, ldapOrder, null);
        }
        catch (CertIOException e) {
            throw new IllegalStateException("CertIOException was thrown due to an invalid extension, but no extensions were provided.", e);
        }
    }

    public static X509Certificate genSelfCertForPurpose(String dn, long validity, String policyId, PrivateKey privKey, PublicKey pubKey, String sigAlg, boolean isCA, int keyusage, Date privateKeyNotBefore, Date privateKeyNotAfter, String provider, boolean ldapOrder, List<Extension> additionalExtensions) throws CertificateParsingException, OperatorCreationException, CertIOException {
        Date firstDate = new Date();
        firstDate.setTime(firstDate.getTime() - 600000L);
        Date lastDate = new Date();
        lastDate.setTime(lastDate.getTime() + validity * 86400000L);
        return CertTools.genSelfCertForPurpose(dn, firstDate, lastDate, policyId, privKey, pubKey, sigAlg, isCA, keyusage, privateKeyNotBefore, privateKeyNotAfter, provider, ldapOrder, additionalExtensions);
    }

    public static X509Certificate genSelfCertForPurpose(String dn, Date firstDate, Date lastDate, String policyId, PrivateKey privKey, PublicKey pubKey, String sigAlg, boolean isCA, int keyusage, Date privateKeyNotBefore, Date privateKeyNotAfter, String provider, boolean ldapOrder, List<Extension> additionalExtensions) throws CertificateParsingException, OperatorCreationException, CertIOException {
        X509Certificate selfcert;
        SubjectPublicKeyInfo pkinfo;
        SecureRandom random;
        PublicKey publicKey;
        block34: {
            publicKey = null;
            if (pubKey instanceof RSAPublicKey) {
                RSAPublicKey rsapk = (RSAPublicKey)pubKey;
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rsapk.getModulus(), rsapk.getPublicExponent());
                try {
                    publicKey = KeyFactory.getInstance("RSA").generatePublic(rSAPublicKeySpec);
                }
                catch (InvalidKeySpecException e) {
                    log.error((Object)"Error creating RSAPublicKey from spec: ", (Throwable)e);
                    publicKey = pubKey;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("RSA was not a known algorithm", e);
                }
            } else if (pubKey instanceof ECPublicKey) {
                ECPublicKey ecpk = (ECPublicKey)pubKey;
                try {
                    ECPublicKeySpec ecspec = new ECPublicKeySpec(ecpk.getW(), ecpk.getParams());
                    String algo = ecpk.getAlgorithm();
                    if (algo.equals("ECGOST3410")) {
                        try {
                            publicKey = KeyFactory.getInstance("ECGOST3410").generatePublic(ecspec);
                            break block34;
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new IllegalStateException("ECGOST3410 was not a known algorithm", e);
                        }
                    }
                    if (algo.equals("DSTU4145")) {
                        try {
                            publicKey = KeyFactory.getInstance("DSTU4145").generatePublic(ecspec);
                            break block34;
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new IllegalStateException("DSTU4145 was not a known algorithm", e);
                        }
                    }
                    try {
                        publicKey = KeyFactory.getInstance("EC").generatePublic(ecspec);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalStateException("EC was not a known algorithm", e);
                    }
                }
                catch (InvalidKeySpecException e) {
                    log.error((Object)"Error creating ECPublicKey from spec: ", (Throwable)e);
                    publicKey = pubKey;
                }
                catch (NullPointerException e) {
                    log.debug((Object)("NullPointerException, probably it is implicitlyCA generated keys: " + e.getMessage()));
                    publicKey = pubKey;
                }
            } else {
                log.debug((Object)("Not converting key of class. " + pubKey.getClass().getName()));
                publicKey = pubKey;
            }
        }
        byte[] serno = new byte[8];
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA1PRNG was not a known algorithm", e);
        }
        random.setSeed(new Date().getTime());
        random.nextBytes(serno);
        try {
            pkinfo = new SubjectPublicKeyInfo((ASN1Sequence)ASN1Primitive.fromByteArray((byte[])publicKey.getEncoded()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Provided public key could not be read to ASN1Primitive", e);
        }
        X509v3CertificateBuilder certbuilder = new X509v3CertificateBuilder(CertTools.stringToBcX500Name(dn, ldapOrder), new BigInteger(serno).abs(), firstDate, lastDate, CertTools.stringToBcX500Name(dn, ldapOrder), pkinfo);
        BasicConstraints bc = new BasicConstraints(isCA);
        certbuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)bc);
        if (isCA || keyusage != 0) {
            X509KeyUsage ku = new X509KeyUsage(keyusage);
            certbuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)ku);
        }
        if (privateKeyNotBefore != null || privateKeyNotAfter != null) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            if (privateKeyNotBefore != null) {
                v.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new DERGeneralizedTime(privateKeyNotBefore)));
            }
            if (privateKeyNotAfter != null) {
                v.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DERGeneralizedTime(privateKeyNotAfter)));
            }
            certbuilder.addExtension(Extension.privateKeyUsagePeriod, false, (ASN1Encodable)new DERSequence(v));
        }
        try {
            if (isCA) {
                JcaX509ExtensionUtils extensionUtils = new JcaX509ExtensionUtils((DigestCalculator)SHA1DigestCalculator.buildSha1Instance());
                SubjectKeyIdentifier ski = extensionUtils.createSubjectKeyIdentifier(publicKey);
                AuthorityKeyIdentifier aki = extensionUtils.createAuthorityKeyIdentifier(publicKey);
                certbuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)ski);
                certbuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)aki);
            }
        }
        catch (IOException extensionUtils) {
            // empty catch block
        }
        if (policyId != null) {
            PolicyInformation pi = new PolicyInformation(new ASN1ObjectIdentifier(policyId));
            DERSequence seq = new DERSequence((ASN1Encodable)pi);
            certbuilder.addExtension(Extension.certificatePolicies, false, (ASN1Encodable)seq);
        }
        if (additionalExtensions != null) {
            for (Extension extension : additionalExtensions) {
                certbuilder.addExtension(extension.getExtnId(), extension.isCritical(), extension.getParsedValue());
            }
        }
        BufferingContentSigner signer = new BufferingContentSigner(new JcaContentSignerBuilder(sigAlg).setProvider(provider).build(privKey), 20480);
        X509CertificateHolder certHolder = certbuilder.build((ContentSigner)signer);
        try {
            selfcert = (X509Certificate)CertTools.getCertfromByteArray(certHolder.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException was caught.", e);
        }
        return selfcert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static byte[] getAuthorityKeyId(Certificate cert) {
        if (cert == null) {
            return null;
        }
        if (cert instanceof X509Certificate) {
            X509Certificate x509cert = (X509Certificate)cert;
            byte[] extvalue = x509cert.getExtensionValue("2.5.29.35");
            if (extvalue == null) {
                return null;
            }
            try (ASN1InputStream octAsn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(extvalue));){
                byte[] byArray;
                DEROctetString oct = (DEROctetString)octAsn1InputStream.readObject();
                ASN1InputStream keyAsn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
                try {
                    AuthorityKeyIdentifier keyId = AuthorityKeyIdentifier.getInstance((Object)((ASN1Sequence)keyAsn1InputStream.readObject()));
                    byArray = keyId.getKeyIdentifier();
                }
                catch (Throwable throwable) {
                    keyAsn1InputStream.close();
                    throw throwable;
                }
                keyAsn1InputStream.close();
                return byArray;
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not parse authority key identifier from certificate.", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static byte[] getSubjectKeyId(Certificate cert) {
        if (cert == null) {
            return null;
        }
        if (cert instanceof X509Certificate) {
            X509Certificate x509cert = (X509Certificate)cert;
            byte[] extvalue = x509cert.getExtensionValue("2.5.29.14");
            if (extvalue == null) {
                return null;
            }
            ASN1InputStream extvalueAsn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(extvalue));
            try {
                try {
                    byte[] byArray;
                    ASN1OctetString str = ASN1OctetString.getInstance((Object)extvalueAsn1InputStream.readObject());
                    ASN1InputStream strAsn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(str.getOctets()));
                    try {
                        SubjectKeyIdentifier keyId = SubjectKeyIdentifier.getInstance((Object)strAsn1InputStream.readObject());
                        byArray = keyId.getKeyIdentifier();
                    }
                    catch (Throwable throwable) {
                        strAsn1InputStream.close();
                        throw throwable;
                    }
                    strAsn1InputStream.close();
                    return byArray;
                }
                finally {
                    extvalueAsn1InputStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not parse subject key ID from certificate.", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCertificatePolicyId(Certificate cert, int pos) throws IOException {
        String ret = null;
        if (cert instanceof X509Certificate) {
            X509Certificate x509cert = (X509Certificate)cert;
            byte[] extvalue = x509cert.getExtensionValue(Extension.certificatePolicies.getId());
            if (extvalue == null) {
                return null;
            }
            try (ASN1InputStream extAsn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(extvalue));){
                DEROctetString oct = (DEROctetString)extAsn1InputStream.readObject();
                try (ASN1InputStream octAsn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));){
                    ASN1Sequence seq = (ASN1Sequence)octAsn1InputStream.readObject();
                    if (seq.size() < pos + 1) {
                        String string = null;
                        return string;
                    }
                    PolicyInformation pol = PolicyInformation.getInstance((Object)((ASN1Sequence)seq.getObjectAt(pos)));
                    ret = pol.getPolicyIdentifier().getId();
                }
            }
        }
        return ret;
    }

    public static String getUPNAltName(Certificate cert) throws IOException, CertificateParsingException {
        String ret;
        block1: {
            ASN1Sequence seq;
            X509Certificate x509cert;
            Collection<List<?>> altNames;
            ret = null;
            if (!(cert instanceof X509Certificate) || (altNames = (x509cert = (X509Certificate)cert).getSubjectAlternativeNames()) == null) break block1;
            Iterator<List<?>> i = altNames.iterator();
            while (i.hasNext() && (ret = CertTools.getUPNStringFromSequence(seq = CertTools.getAltnameSequence(i.next()))) == null) {
            }
        }
        return ret;
    }

    private static String getUPNStringFromSequence(ASN1Sequence seq) {
        ASN1ObjectIdentifier id;
        if (seq != null && (id = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(0))).getId().equals(UPN_OBJECTID)) {
            ASN1TaggedObject oobj = (ASN1TaggedObject)seq.getObjectAt(1);
            ASN1Primitive obj = oobj.getObject();
            if (obj instanceof ASN1TaggedObject) {
                obj = ASN1TaggedObject.getInstance((Object)obj).getObject();
            }
            DERUTF8String str = DERUTF8String.getInstance((Object)obj);
            return str.getString();
        }
        return null;
    }

    public static String getPermanentIdentifierAltName(Certificate cert) throws IOException, CertificateParsingException {
        String ret;
        block1: {
            ASN1Sequence seq;
            X509Certificate x509cert;
            Collection<List<?>> altNames;
            ret = null;
            if (!(cert instanceof X509Certificate) || (altNames = (x509cert = (X509Certificate)cert).getSubjectAlternativeNames()) == null) break block1;
            Iterator<List<?>> i = altNames.iterator();
            while (i.hasNext() && (ret = CertTools.getPermanentIdentifierStringFromSequence(seq = CertTools.getAltnameSequence(i.next()))) == null) {
            }
        }
        return ret;
    }

    static String getPermanentIdentifierStringFromSequence(ASN1Sequence seq) {
        ASN1ObjectIdentifier id;
        if (seq != null && (id = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(0))).getId().equals(PERMANENTIDENTIFIER_OBJECTID)) {
            ASN1Sequence piSeq;
            Enumeration e;
            String identifierValue = null;
            String assigner = null;
            ASN1TaggedObject oobj = (ASN1TaggedObject)seq.getObjectAt(1);
            ASN1Primitive obj = oobj.getObject();
            if (obj instanceof ASN1TaggedObject) {
                obj = ASN1TaggedObject.getInstance((Object)obj).getObject();
            }
            if ((e = (piSeq = ASN1Sequence.getInstance((Object)obj)).getObjects()).hasMoreElements()) {
                Object element = e.nextElement();
                if (element instanceof DERUTF8String) {
                    identifierValue = ((DERUTF8String)element).getString();
                    if (e.hasMoreElements()) {
                        element = e.nextElement();
                    }
                }
                if (element instanceof ASN1ObjectIdentifier) {
                    assigner = ((ASN1ObjectIdentifier)element).getId();
                }
            }
            StringBuilder buff = new StringBuilder();
            if (identifierValue != null) {
                buff.append(CertTools.escapePermanentIdentifierValue(identifierValue));
            }
            buff.append(PERMANENTIDENTIFIER_SEP);
            if (assigner != null) {
                buff.append(assigner);
            }
            return buff.toString();
        }
        return null;
    }

    private static String escapePermanentIdentifierValue(String realValue) {
        return realValue.replace(PERMANENTIDENTIFIER_SEP, "\\/");
    }

    private static String unescapePermanentIdentifierValue(String escapedValue) {
        return escapedValue.replace("\\permanentIdentifier", PERMANENTIDENTIFIER);
    }

    static String[] getPermanentIdentifierValues(String permanentIdentifierString) {
        String[] result = new String[2];
        int sepPos = permanentIdentifierString.lastIndexOf(PERMANENTIDENTIFIER_SEP);
        if (sepPos == -1) {
            if (!permanentIdentifierString.isEmpty()) {
                result[0] = CertTools.unescapePermanentIdentifierValue(permanentIdentifierString);
            }
        } else if (sepPos == 0) {
            if (permanentIdentifierString.length() > 1) {
                result[1] = permanentIdentifierString.substring(1);
            }
        } else if (permanentIdentifierString.charAt(sepPos - PERMANENTIDENTIFIER_SEP.length()) != '\\') {
            result[0] = CertTools.unescapePermanentIdentifierValue(permanentIdentifierString.substring(0, sepPos));
            if (permanentIdentifierString.length() > sepPos + PERMANENTIDENTIFIER_SEP.length()) {
                result[1] = permanentIdentifierString.substring(sepPos + 1);
            }
        }
        return result;
    }

    private static String getGUIDStringFromSequence(ASN1Sequence seq) {
        ASN1ObjectIdentifier id;
        String ret = null;
        if (seq != null && (id = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(0))).getId().equals(GUID_OBJECTID)) {
            ASN1TaggedObject oobj = (ASN1TaggedObject)seq.getObjectAt(1);
            ASN1Primitive obj = oobj.getObject();
            if (obj instanceof ASN1TaggedObject) {
                obj = ASN1TaggedObject.getInstance((Object)obj).getObject();
            }
            ASN1OctetString str = ASN1OctetString.getInstance((Object)obj);
            ret = new String(Hex.encode((byte[])str.getOctets()));
        }
        return ret;
    }

    protected static String getKrb5PrincipalNameFromSequence(ASN1Sequence seq) {
        ASN1ObjectIdentifier id;
        String ret = null;
        if (seq != null && (id = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(0))).getId().equals(KRB5PRINCIPAL_OBJECTID)) {
            ASN1TaggedObject oobj = (ASN1TaggedObject)seq.getObjectAt(1);
            ASN1Primitive obj = oobj.getObject();
            if (obj instanceof ASN1TaggedObject) {
                obj = ASN1TaggedObject.getInstance((Object)obj).getObject();
            }
            ASN1Sequence krb5Seq = ASN1Sequence.getInstance((Object)obj);
            ASN1TaggedObject robj = (ASN1TaggedObject)krb5Seq.getObjectAt(0);
            DERGeneralString realmObj = DERGeneralString.getInstance((Object)robj.getObject());
            String realm = realmObj.getString();
            ASN1TaggedObject pobj = (ASN1TaggedObject)krb5Seq.getObjectAt(1);
            ASN1Sequence nseq = ASN1Sequence.getInstance((Object)pobj.getObject());
            ASN1TaggedObject nobj = (ASN1TaggedObject)nseq.getObjectAt(1);
            ASN1Sequence sseq = ASN1Sequence.getInstance((Object)nobj.getObject());
            Enumeration en = sseq.getObjects();
            while (en.hasMoreElements()) {
                ASN1Primitive o = (ASN1Primitive)en.nextElement();
                DERGeneralString str = DERGeneralString.getInstance((Object)o);
                if (ret != null) {
                    ret = ret + PERMANENTIDENTIFIER_SEP + str.getString();
                    continue;
                }
                ret = str.getString();
            }
            ret = ret + "@" + realm;
        }
        return ret;
    }

    public static String getGuidAltName(Certificate cert) throws IOException, CertificateParsingException {
        X509Certificate x509cert;
        Collection<List<?>> altNames;
        if (cert instanceof X509Certificate && (altNames = (x509cert = (X509Certificate)cert).getSubjectAlternativeNames()) != null) {
            Iterator<List<?>> i = altNames.iterator();
            while (i.hasNext()) {
                String guid;
                ASN1Sequence seq = CertTools.getAltnameSequence(i.next());
                if (seq == null || (guid = CertTools.getGUIDStringFromSequence(seq)) == null) continue;
                return guid;
            }
        }
        return null;
    }

    private static ASN1Sequence getAltnameSequence(List<?> listitem) {
        Integer no = (Integer)listitem.get(0);
        if (no == 0) {
            byte[] altName = (byte[])listitem.get(1);
            return CertTools.getAltnameSequence(altName);
        }
        return null;
    }

    private static ASN1Sequence getAltnameSequence(byte[] value) {
        ASN1Primitive oct = null;
        try {
            oct = new ASN1InputStream((InputStream)new ByteArrayInputStream(value)).readObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read ASN1InputStream", e);
        }
        if (oct instanceof ASN1TaggedObject) {
            oct = ((ASN1TaggedObject)oct).getObject();
        }
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)oct);
        return seq;
    }

    public static String getAltNameStringFromExtension(Extension ext) {
        String altName = null;
        GeneralNames names = CertTools.getGeneralNamesFromExtension(ext);
        if (names != null) {
            try {
                GeneralName[] gns;
                for (GeneralName gn : gns = names.getNames()) {
                    ASN1Encodable name;
                    int tag = gn.getTagNo();
                    String str = CertTools.getGeneralNameString(tag, name = gn.getName());
                    if (str == null) continue;
                    altName = altName == null ? str : altName + ", " + str;
                }
            }
            catch (IOException e) {
                log.error((Object)"IOException parsing altNames: ", (Throwable)e);
                return null;
            }
        }
        return altName;
    }

    public static GeneralNames getGeneralNamesFromExtension(Extension ext) {
        ASN1Encodable gnames = ext.getParsedValue();
        if (gnames != null) {
            GeneralNames names = GeneralNames.getInstance((Object)gnames);
            return names;
        }
        return null;
    }

    public static String getSubjectAlternativeName(Certificate certificate) {
        if (log.isTraceEnabled()) {
            log.trace((Object)">getSubjectAlternativeName");
        }
        String result = "";
        if (certificate instanceof X509Certificate) {
            X509Certificate x509cert = (X509Certificate)certificate;
            Collection<List<?>> altNames = null;
            try {
                altNames = x509cert.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException e) {
                throw new RuntimeException("Could not parse certificate", e);
            }
            if (altNames == null) {
                return null;
            }
            Iterator<List<?>> iter = altNames.iterator();
            String append = "";
            block12: while (iter.hasNext()) {
                List<?> item = iter.next();
                Integer type = (Integer)item.get(0);
                Object value = item.get(1);
                if (!StringUtils.isEmpty((String)result)) {
                    append = ", ";
                }
                switch (type) {
                    case 0: {
                        ASN1Sequence seq = CertTools.getAltnameSequence(item);
                        String upn = CertTools.getUPNStringFromSequence(seq);
                        if (upn != null) {
                            result = result + append + UPN + "=" + upn;
                            break;
                        }
                        String permanentIdentifier = CertTools.getPermanentIdentifierStringFromSequence(seq);
                        if (permanentIdentifier != null) {
                            result = result + append + PERMANENTIDENTIFIER + "=" + permanentIdentifier;
                            break;
                        }
                        String krb5Principal = CertTools.getKrb5PrincipalNameFromSequence(seq);
                        if (krb5Principal != null) {
                            result = result + append + KRB5PRINCIPAL + "=" + krb5Principal;
                            break;
                        }
                        String guid = CertTools.getGUIDStringFromSequence(seq);
                        if (guid == null) continue block12;
                        result = result + append + GUID + "=" + guid;
                        break;
                    }
                    case 1: {
                        result = result + append + EMAIL + "=" + (String)value;
                        break;
                    }
                    case 2: {
                        result = result + append + DNS + "=" + (String)value;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        result = result + append + DIRECTORYNAME + "=" + (String)value;
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        result = result + append + URI + "=" + (String)value;
                        break;
                    }
                    case 7: {
                        result = result + append + IPADDR + "=" + (String)value;
                        break;
                    }
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("<getSubjectAlternativeName: " + result));
            }
            if (StringUtils.isEmpty((String)result)) {
                return null;
            }
        }
        return result;
    }

    public static GeneralNames getGeneralNamesFromAltName(String altName) {
        ASN1EncodableVector v;
        if (log.isTraceEnabled()) {
            log.trace((Object)(">getGeneralNamesFromAltName: " + altName));
        }
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (String email : CertTools.getEmailFromDN(altName)) {
            vec.add((ASN1Encodable)new GeneralName(1, email));
        }
        for (String dns : CertTools.getPartsFromDN(altName, DNS)) {
            vec.add((ASN1Encodable)new GeneralName(2, (ASN1Encodable)new DERIA5String(dns)));
        }
        String directoryName = CertTools.getDirectoryStringFromAltName(altName);
        if (directoryName != null) {
            X500Name x500DirectoryName = new X500Name(LDAPDN.unescapeRDN((String)directoryName));
            GeneralName gn = new GeneralName(4, (ASN1Encodable)x500DirectoryName);
            vec.add((ASN1Encodable)gn);
        }
        for (String uri : CertTools.getPartsFromDN(altName, URI)) {
            vec.add((ASN1Encodable)new GeneralName(6, (ASN1Encodable)new DERIA5String(uri)));
        }
        for (String uri : CertTools.getPartsFromDN(altName, URI1)) {
            vec.add((ASN1Encodable)new GeneralName(6, (ASN1Encodable)new DERIA5String(uri)));
        }
        for (String uri : CertTools.getPartsFromDN(altName, URI2)) {
            vec.add((ASN1Encodable)new GeneralName(6, (ASN1Encodable)new DERIA5String(uri)));
        }
        for (String addr : CertTools.getPartsFromDN(altName, IPADDR)) {
            byte[] ipoctets = StringTools.ipStringToOctets(addr);
            if (ipoctets.length > 0) {
                GeneralName gn = new GeneralName(7, (ASN1Encodable)new DEROctetString(ipoctets));
                vec.add((ASN1Encodable)gn);
                continue;
            }
            log.error((Object)("Cannot parse/encode ip address, ignoring: " + addr));
        }
        for (String upn : CertTools.getPartsFromDN(altName, UPN)) {
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier(UPN_OBJECTID));
            v.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(upn)));
            vec.add((ASN1Encodable)GeneralName.getInstance((Object)new DERTaggedObject(false, 0, (ASN1Encodable)new DERSequence(v))));
        }
        for (String permanentIdentifier : CertTools.getPartsFromDN(altName, PERMANENTIDENTIFIER)) {
            String[] values = CertTools.getPermanentIdentifierValues(permanentIdentifier);
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            v2.add((ASN1Encodable)new ASN1ObjectIdentifier(PERMANENTIDENTIFIER_OBJECTID));
            ASN1EncodableVector piSeq = new ASN1EncodableVector();
            if (values[0] != null) {
                piSeq.add((ASN1Encodable)new DERUTF8String(values[0]));
            }
            if (values[1] != null) {
                piSeq.add((ASN1Encodable)new ASN1ObjectIdentifier(values[1]));
            }
            v2.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence(piSeq)));
            DERTaggedObject gn = new DERTaggedObject(false, 0, (ASN1Encodable)new DERSequence(v2));
            vec.add((ASN1Encodable)gn);
        }
        for (String guid : CertTools.getPartsFromDN(altName, GUID)) {
            v = new ASN1EncodableVector();
            byte[] guidbytes = Hex.decode((String)guid);
            if (guidbytes != null) {
                v.add((ASN1Encodable)new ASN1ObjectIdentifier(GUID_OBJECTID));
                v.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DEROctetString(guidbytes)));
                DERTaggedObject gn = new DERTaggedObject(false, 0, (ASN1Encodable)new DERSequence(v));
                vec.add((ASN1Encodable)gn);
                continue;
            }
            log.error((Object)("Cannot decode hexadecimal guid, ignoring: " + guid));
        }
        for (String principalString : CertTools.getPartsFromDN(altName, KRB5PRINCIPAL)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("principalString: " + principalString));
            }
            int index = principalString.lastIndexOf(64);
            String realm = "";
            if (index > 0) {
                realm = principalString.substring(index + 1);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("realm: " + realm));
            }
            ArrayList<String> principalarr = new ArrayList<String>();
            int jndex = 0;
            int bindex = 0;
            while (jndex < index) {
                jndex = principalString.indexOf(47, bindex);
                if (jndex == -1) {
                    jndex = index;
                }
                String s = principalString.substring(bindex, jndex);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding principal name: " + s));
                }
                principalarr.add(s);
                bindex = jndex + 1;
            }
            ASN1EncodableVector v3 = new ASN1EncodableVector();
            v3.add((ASN1Encodable)new ASN1ObjectIdentifier(KRB5PRINCIPAL_OBJECTID));
            ASN1EncodableVector krb5p = new ASN1EncodableVector();
            krb5p.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERGeneralString(realm)));
            ASN1EncodableVector principals = new ASN1EncodableVector();
            principals.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new ASN1Integer(0L)));
            Iterator i = principalarr.iterator();
            ASN1EncodableVector names = new ASN1EncodableVector();
            while (i.hasNext()) {
                String principalName = (String)i.next();
                names.add((ASN1Encodable)new DERGeneralString(principalName));
            }
            principals.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new DERSequence(names)));
            krb5p.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new DERSequence(principals)));
            v3.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence(krb5p)));
            DERTaggedObject gn = new DERTaggedObject(false, 0, (ASN1Encodable)new DERSequence(v3));
            vec.add((ASN1Encodable)gn);
        }
        for (String oid : CertTools.getCustomOids(altName)) {
            for (String oidValue : CertTools.getPartsFromDN(altName, oid)) {
                ASN1EncodableVector v4 = new ASN1EncodableVector();
                v4.add((ASN1Encodable)new ASN1ObjectIdentifier(oid));
                v4.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(oidValue)));
                DERTaggedObject gn = new DERTaggedObject(false, 0, (ASN1Encodable)new DERSequence(v4));
                vec.add((ASN1Encodable)gn);
            }
        }
        if (vec.size() > 0) {
            return GeneralNames.getInstance((Object)new DERSequence(vec));
        }
        return null;
    }

    public static String getGeneralNameString(int tag, ASN1Encodable value) throws IOException {
        String ret = null;
        switch (tag) {
            case 0: {
                ASN1Sequence seq = CertTools.getAltnameSequence(value.toASN1Primitive().getEncoded());
                String upn = CertTools.getUPNStringFromSequence(seq);
                if (upn != null) {
                    ret = "upn=" + upn;
                    break;
                }
                String permanentIdentifier = CertTools.getPermanentIdentifierStringFromSequence(seq);
                if (permanentIdentifier != null) {
                    ret = "permanentIdentifier=" + permanentIdentifier;
                    break;
                }
                String krb5Principal = CertTools.getKrb5PrincipalNameFromSequence(seq);
                if (krb5Principal == null) break;
                ret = "krb5principal=" + krb5Principal;
                break;
            }
            case 1: {
                ret = "rfc822name=" + DERIA5String.getInstance((Object)value).getString();
                break;
            }
            case 2: {
                ret = "dNSName=" + DERIA5String.getInstance((Object)value).getString();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                X500Name name = X500Name.getInstance((Object)value);
                ret = "directoryName=" + name.toString();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                ret = "uniformResourceIdentifier=" + DERIA5String.getInstance((Object)value).getString();
                break;
            }
            case 7: {
                ASN1OctetString oct = ASN1OctetString.getInstance((Object)value);
                ret = "iPAddress=" + StringTools.ipOctetsToString(oct.getOctets());
                break;
            }
        }
        return ret;
    }

    public static boolean verify(Certificate certificate, Collection<Certificate> caCertChain, Date date, PKIXCertPathChecker ... pkixCertPathCheckers) throws Exception {
        try {
            ArrayList<Certificate> certlist = new ArrayList<Certificate>();
            certlist.add(certificate);
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            CertPath cp = cf.generateCertPath(certlist);
            X509Certificate[] cac = caCertChain.toArray(new X509Certificate[0]);
            TrustAnchor anchor = new TrustAnchor(cac[0], null);
            PKIXParameters params = new PKIXParameters(Collections.singleton(anchor));
            for (PKIXCertPathChecker pkixCertPathChecker : pkixCertPathCheckers) {
                params.addCertPathChecker(pkixCertPathChecker);
            }
            params.setRevocationEnabled(false);
            params.setDate(date);
            CertPathValidator cpv = CertPathValidator.getInstance("PKIX", "BC");
            PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)cpv.validate(cp, params);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Certificate verify result: " + result.toString()));
            }
        }
        catch (CertPathValidatorException cpve) {
            throw new Exception("Invalid certificate or certificate not issued by specified CA: " + cpve.getMessage());
        }
        catch (Exception e) {
            throw new Exception("Error checking certificate chain: " + e.getMessage());
        }
        return true;
    }

    public static boolean verify(Certificate certificate, Collection<Certificate> caCertChain) throws Exception {
        return CertTools.verify(certificate, caCertChain, null, new PKIXCertPathChecker[0]);
    }

    public static boolean verifyWithTrustedCertificates(Certificate certificate, Collection<Collection<Certificate>> trustedCertificates, PKIXCertPathChecker ... pkixCertPathCheckers) {
        if (trustedCertificates == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Input of trustedCertificates was null. Trusting nothing.");
            }
            return false;
        }
        if (trustedCertificates.size() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Input of trustedCertificates was empty. Trusting everything.");
            }
            return true;
        }
        BigInteger certSN = CertTools.getSerialNumber(certificate);
        for (Collection<Certificate> trustedCertChain : trustedCertificates) {
            Certificate trustedCert = trustedCertChain.iterator().next();
            BigInteger trustedCertSN = CertTools.getSerialNumber(trustedCert);
            if (certSN.equals(trustedCertSN) && trustedCertChain.size() > 1) {
                trustedCertChain.remove(trustedCert);
            }
            try {
                CertTools.verify(certificate, trustedCertChain, null, pkixCertPathCheckers);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trusting certificate with SubjectDN '" + CertTools.getSubjectDN(certificate) + "' and issuerDN '" + CertTools.getIssuerDN(certificate) + "'."));
                }
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public static void checkValidity(Certificate cert, Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (cert != null) {
            if (cert instanceof X509Certificate) {
                X509Certificate xcert = (X509Certificate)cert;
                xcert.checkValidity(date);
            } else if (StringUtils.equals((String)cert.getType(), (String)"CVC")) {
                CardVerifiableCertificate cvccert = (CardVerifiableCertificate)cert;
                try {
                    Date start = cvccert.getCVCertificate().getCertificateBody().getValidFrom();
                    Date end = cvccert.getCVCertificate().getCertificateBody().getValidTo();
                    if (start.after(date)) {
                        String msg = "Certificate startDate '" + start + "' is after check date '" + date + "'";
                        if (log.isTraceEnabled()) {
                            log.trace((Object)msg);
                        }
                        throw new CertificateNotYetValidException(msg);
                    }
                    if (end.before(date)) {
                        String msg = "Certificate endDate '" + end + "' is before check date '" + date + "'";
                        if (log.isTraceEnabled()) {
                            log.trace((Object)msg);
                        }
                        throw new CertificateExpiredException(msg);
                    }
                }
                catch (NoSuchFieldException e) {
                    log.error((Object)"NoSuchFieldException: ", (Throwable)e);
                }
            }
        }
    }

    public static URL getCrlDistributionPoint(Certificate certificate) throws CertificateParsingException {
        if (certificate instanceof X509Certificate) {
            X509Certificate x509cert = (X509Certificate)certificate;
            try {
                ASN1Primitive obj = CertTools.getExtensionValue(x509cert, Extension.cRLDistributionPoints.getId());
                if (obj == null) {
                    return null;
                }
                ASN1Sequence distributionPoints = (ASN1Sequence)obj;
                for (int i = 0; i < distributionPoints.size(); ++i) {
                    ASN1Sequence distrPoint = (ASN1Sequence)distributionPoints.getObjectAt(i);
                    for (int j = 0; j < distrPoint.size(); ++j) {
                        String url;
                        ASN1TaggedObject tagged = (ASN1TaggedObject)distrPoint.getObjectAt(j);
                        if (tagged.getTagNo() != 0 || (url = CertTools.getStringFromGeneralNames(tagged.getObject())) == null) continue;
                        return new URL(url);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Error parsing CrlDistributionPoint", (Throwable)e);
                throw new CertificateParsingException(e.toString());
            }
        }
        return null;
    }

    public static Collection<String> getAuthorityInformationAccess(CRL crl) {
        AuthorityInformationAccess authorityInformationAccess;
        AccessDescription[] accessDescriptions;
        X509CRL x509crl;
        ASN1Primitive derObject;
        ArrayList<String> result = new ArrayList<String>();
        if (crl instanceof X509CRL && (derObject = CertTools.getExtensionValue(x509crl = (X509CRL)crl, Extension.authorityInfoAccess.getId())) != null && (accessDescriptions = (authorityInformationAccess = AuthorityInformationAccess.getInstance((Object)derObject)).getAccessDescriptions()) != null && accessDescriptions.length > 0) {
            for (AccessDescription accessDescription : accessDescriptions) {
                GeneralName generalName;
                if (!accessDescription.getAccessMethod().equals((Object)X509ObjectIdentifiers.id_ad_caIssuers) || (generalName = accessDescription.getAccessLocation()).getTagNo() != 6) continue;
                ASN1Primitive obj = generalName.toASN1Primitive();
                if (obj instanceof ASN1TaggedObject) {
                    obj = ASN1TaggedObject.getInstance((Object)obj).getObject();
                }
                DERIA5String deria5String = DERIA5String.getInstance((Object)obj);
                result.add(deria5String.getString());
            }
        }
        return result;
    }

    public static String getAuthorityInformationAccessOcspUrl(Certificate cert) throws CertificateParsingException {
        String ret;
        block6: {
            ret = null;
            if (cert instanceof X509Certificate) {
                X509Certificate x509cert = (X509Certificate)cert;
                try {
                    ASN1Primitive obj = CertTools.getExtensionValue(x509cert, Extension.authorityInfoAccess.getId());
                    if (obj == null) {
                        return null;
                    }
                    AuthorityInformationAccess aia = AuthorityInformationAccess.getInstance((Object)obj);
                    AccessDescription[] ad = aia.getAccessDescriptions();
                    if (ad == null || ad.length <= 0) break block6;
                    for (int i = 0; i < ad.length; ++i) {
                        GeneralName gn;
                        if (!ad[i].getAccessMethod().equals((Object)X509ObjectIdentifiers.ocspAccessMethod) || (gn = ad[i].getAccessLocation()).getTagNo() != 6) continue;
                        ASN1Primitive gnobj = gn.toASN1Primitive();
                        if (gnobj instanceof ASN1TaggedObject) {
                            gnobj = ASN1TaggedObject.getInstance((Object)gnobj).getObject();
                        }
                        DERIA5String str = DERIA5String.getInstance((Object)gnobj);
                        ret = str.getString();
                        break;
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error parsing AuthorityInformationAccess", (Throwable)e);
                    throw new CertificateParsingException(e.toString());
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKeyUsagePeriod getPrivateKeyUsagePeriod(X509Certificate cert) {
        PrivateKeyUsagePeriod res = null;
        byte[] extvalue = cert.getExtensionValue(Extension.privateKeyUsagePeriod.getId());
        if (extvalue != null && extvalue.length > 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Found a PrivateKeyUsagePeriod in the certificate with subject: " + cert.getSubjectDN().toString()));
            }
            ASN1InputStream extAsn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(extvalue));
            try {
                try {
                    DEROctetString oct = (DEROctetString)extAsn1InputStream.readObject();
                    try (ASN1InputStream octAsn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));){
                        res = PrivateKeyUsagePeriod.getInstance((Object)((ASN1Sequence)octAsn1InputStream.readObject()));
                    }
                }
                finally {
                    extAsn1InputStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Unknown IOException caught when trying to parse certificate.", e);
            }
        }
        return res;
    }

    protected static ASN1Primitive getExtensionValue(X509Certificate cert, String oid) {
        if (cert == null) {
            return null;
        }
        byte[] bytes = cert.getExtensionValue(oid);
        return CertTools.getDerObjectFromByteArray(bytes);
    }

    protected static ASN1Primitive getExtensionValue(X509CRL crl, String oid) {
        if (crl == null || oid == null) {
            return null;
        }
        byte[] bytes = crl.getExtensionValue(oid);
        return CertTools.getDerObjectFromByteArray(bytes);
    }

    private static ASN1Primitive getDerObjectFromByteArray(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(bytes));
        try {
            ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
            aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(octs.getOctets()));
            return aIn.readObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Caught an unexected IOException", e);
        }
    }

    private static String getStringFromGeneralNames(ASN1Primitive names) {
        ASN1Sequence namesSequence = ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)names), (boolean)false);
        if (namesSequence.size() == 0) {
            return null;
        }
        DERTaggedObject taggedObject = (DERTaggedObject)namesSequence.getObjectAt(0);
        if (taggedObject.getTagNo() != 6) {
            return null;
        }
        return new String(ASN1OctetString.getInstance((ASN1TaggedObject)taggedObject, (boolean)false).getOctets());
    }

    public static String getFingerprintAsString(Certificate cert) {
        if (cert == null) {
            return null;
        }
        try {
            byte[] res = CertTools.generateSHA1Fingerprint(cert.getEncoded());
            return new String(Hex.encode((byte[])res));
        }
        catch (CertificateEncodingException cee) {
            log.error((Object)"Error encoding certificate.", (Throwable)cee);
            return null;
        }
    }

    public static String getFingerprintAsString(X509CRL crl) {
        try {
            byte[] res = CertTools.generateSHA1Fingerprint(crl.getEncoded());
            return new String(Hex.encode((byte[])res));
        }
        catch (CRLException ce) {
            log.error((Object)"Error encoding CRL.", (Throwable)ce);
            return null;
        }
    }

    public static String getFingerprintAsString(byte[] in) {
        byte[] res = CertTools.generateSHA1Fingerprint(in);
        return new String(Hex.encode((byte[])res));
    }

    public static byte[] generateSHA1Fingerprint(byte[] ba) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            return md.digest(ba);
        }
        catch (NoSuchAlgorithmException nsae) {
            log.error((Object)"SHA1 algorithm not supported", (Throwable)nsae);
            return null;
        }
    }

    public static byte[] generateSHA256Fingerprint(byte[] ba) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(ba);
        }
        catch (NoSuchAlgorithmException nsae) {
            log.error((Object)"SHA-256 algorithm not supported", (Throwable)nsae);
            return null;
        }
    }

    public static byte[] generateMD5Fingerprint(byte[] ba) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(ba);
        }
        catch (NoSuchAlgorithmException nsae) {
            log.error((Object)"MD5 algorithm not supported", (Throwable)nsae);
            return null;
        }
    }

    public static int sunKeyUsageToBC(boolean[] sku) {
        if (sku == null) {
            return -1;
        }
        int bcku = 0;
        if (sku[0]) {
            bcku |= 0x80;
        }
        if (sku[1]) {
            bcku |= 0x40;
        }
        if (sku[2]) {
            bcku |= 0x20;
        }
        if (sku[3]) {
            bcku |= 0x10;
        }
        if (sku[4]) {
            bcku |= 8;
        }
        if (sku[5]) {
            bcku |= 4;
        }
        if (sku[6]) {
            bcku |= 2;
        }
        if (sku[7]) {
            bcku |= 1;
        }
        if (sku[8]) {
            bcku |= 0x8000;
        }
        return bcku;
    }

    public static int bitStringToRevokedCertInfo(DERBitString reasonFlags) {
        int ret = RevokedCertInfo.REVOCATION_REASON_UNSPECIFIED;
        if (reasonFlags == null) {
            return ret;
        }
        int val = reasonFlags.intValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Int value of bitString revocation reason: " + val));
        }
        if ((val & 0x8000) != 0) {
            ret = RevokedCertInfo.REVOCATION_REASON_AACOMPROMISE;
        }
        if ((val & 0x10) != 0) {
            ret = RevokedCertInfo.REVOCATION_REASON_AFFILIATIONCHANGED;
        }
        if ((val & 0x20) != 0) {
            ret = RevokedCertInfo.REVOCATION_REASON_CACOMPROMISE;
        }
        if ((val & 2) != 0) {
            ret = RevokedCertInfo.REVOCATION_REASON_CERTIFICATEHOLD;
        }
        if ((val & 4) != 0) {
            ret = RevokedCertInfo.REVOCATION_REASON_CESSATIONOFOPERATION;
        }
        if ((val & 0x40) != 0) {
            ret = RevokedCertInfo.REVOCATION_REASON_KEYCOMPROMISE;
        }
        if ((val & 1) != 0) {
            ret = RevokedCertInfo.REVOCATION_REASON_PRIVILEGESWITHDRAWN;
        }
        if ((val & 8) != 0) {
            ret = RevokedCertInfo.REVOCATION_REASON_SUPERSEDED;
        }
        if ((val & 0x80) != 0) {
            ret = RevokedCertInfo.REVOCATION_REASON_UNSPECIFIED;
        }
        return ret;
    }

    public static String insertCNPostfix(String dn, String cnpostfix, X500NameStyle nameStyle) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(">insertCNPostfix: dn=" + dn + ", cnpostfix=" + cnpostfix));
        }
        if (dn == null) {
            return null;
        }
        RDN[] rdns = IETFUtils.rDNsFromString((String)dn, (X500NameStyle)nameStyle);
        X500NameBuilder nameBuilder = new X500NameBuilder(nameStyle);
        boolean replaced = false;
        for (RDN rdn : rdns) {
            AttributeTypeAndValue[] attributeTypeAndValues;
            for (AttributeTypeAndValue atav : attributeTypeAndValues = rdn.getTypesAndValues()) {
                if (atav.getType() == null) continue;
                String currentSymbol = CeSecoreNameStyle.DefaultSymbols.get(atav.getType());
                if (!replaced && "CN".equals(currentSymbol)) {
                    nameBuilder.addRDN(atav.getType(), IETFUtils.valueToString((ASN1Encodable)atav.getValue()) + cnpostfix);
                    replaced = true;
                    continue;
                }
                nameBuilder.addRDN(atav);
            }
        }
        String ret = nameBuilder.build().toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("<reverseDN: " + ret));
        }
        return ret;
    }

    public static List<String> getX500NameComponents(String dn) {
        ArrayList<String> ret = new ArrayList<String>();
        X509NameTokenizer tokenizer = new X509NameTokenizer(dn);
        while (tokenizer.hasMoreTokens()) {
            ret.add(tokenizer.nextToken());
        }
        return ret;
    }

    public static String getParentDN(String dn) {
        X509NameTokenizer tokenizer = new X509NameTokenizer(dn);
        tokenizer.nextToken();
        return tokenizer.getRemainingString();
    }

    public static List<ASN1ObjectIdentifier> getX509FieldOrder(boolean ldaporder) {
        ArrayList<ASN1ObjectIdentifier> fieldOrder = new ArrayList<ASN1ObjectIdentifier>();
        for (String dNObject : DnComponents.getDnObjects(ldaporder)) {
            fieldOrder.add(DnComponents.getOid(dNObject));
        }
        return fieldOrder;
    }

    private static X500Name getOrderedX500Name(X500Name x500Name, boolean ldaporder, X500NameStyle nameStyle) {
        boolean isLdapOrder = !CertTools.isDNReversed(x500Name.toString());
        ArrayList<ASN1ObjectIdentifier> newOrdering = new ArrayList<ASN1ObjectIdentifier>();
        ArrayList<ASN1Encodable> newValues = new ArrayList<ASN1Encodable>();
        ASN1ObjectIdentifier[] allOids = x500Name.getAttributeTypes();
        List<ASN1ObjectIdentifier> ordering = CertTools.getX509FieldOrder(isLdapOrder);
        HashSet<ASN1ObjectIdentifier> hs = new HashSet<ASN1ObjectIdentifier>(allOids.length + ordering.size());
        for (ASN1ObjectIdentifier oid : ordering) {
            RDN[] valueList;
            if (hs.contains(oid)) continue;
            hs.add(oid);
            for (RDN value : valueList = x500Name.getRDNs(oid)) {
                newOrdering.add(oid);
                newValues.add(value.getFirst().getValue());
            }
        }
        for (ASN1ObjectIdentifier oid : allOids) {
            RDN[] valueList;
            if (hs.contains(oid)) continue;
            hs.add(oid);
            for (RDN value : valueList = x500Name.getRDNs(oid)) {
                newOrdering.add(oid);
                newValues.add(value.getFirst().getValue());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("added --> " + oid + " val: " + value));
            }
        }
        if (ldaporder != isLdapOrder) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reversing order of DN, ldaporder=" + ldaporder + ", isLdapOrder=" + isLdapOrder));
            }
            Collections.reverse(newOrdering);
            Collections.reverse(newValues);
        }
        X500NameBuilder nameBuilder = new X500NameBuilder(nameStyle);
        for (int i = 0; i < newOrdering.size(); ++i) {
            nameBuilder.addRDN((ASN1ObjectIdentifier)newOrdering.get(i), (ASN1Encodable)newValues.get(i));
        }
        return nameBuilder.build();
    }

    private static String getDirectoryStringFromAltName(String altName) {
        String directoryName = CertTools.getPartFromDN(altName, DIRECTORYNAME);
        return "".equals(directoryName) ? null : directoryName;
    }

    public static List<Certificate> createCertChain(Collection<?> certlistin) throws CertPathValidatorException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        return CertTools.createCertChain(certlistin, new Date());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Certificate> createCertChain(Collection<?> certlistin, Date now) throws CertPathValidatorException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        ArrayList<Certificate> returnval = new ArrayList<Certificate>();
        Collection<Certificate> certlist = CertTools.orderCertificateChain(certlistin);
        Certificate rootcert = null;
        ArrayList<Certificate> calist = new ArrayList<Certificate>();
        for (Certificate next : certlist) {
            if (CertTools.isSelfSigned(next)) {
                rootcert = next;
                continue;
            }
            calist.add(next);
        }
        if (calist.isEmpty()) {
            returnval.add(rootcert);
            return returnval;
        } else {
            Certificate test = (Certificate)calist.get(0);
            if (test.getType().equals("CVC")) {
                if (calist.size() != 1) throw new CertPathValidatorException("CVC certificate chain can not be of length longer than two.");
                returnval.add(test);
                returnval.add(rootcert);
                return returnval;
            } else {
                HashSet<TrustAnchor> trustancors = new HashSet<TrustAnchor>();
                TrustAnchor trustanchor = null;
                trustanchor = new TrustAnchor((X509Certificate)rootcert, null);
                trustancors.add(trustanchor);
                PKIXParameters params = new PKIXParameters(trustancors);
                params.setRevocationEnabled(false);
                params.setDate(now);
                CertPathValidator certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType(), "BC");
                CertificateFactory fact = CertTools.getCertificateFactory();
                CertPath certpath = fact.generateCertPath(calist);
                CertPathValidatorResult result = certPathValidator.validate(certpath, params);
                PKIXCertPathValidatorResult pkixResult = (PKIXCertPathValidatorResult)result;
                returnval.addAll(certpath.getCertificates());
                TrustAnchor ta = pkixResult.getTrustAnchor();
                X509Certificate cert = ta.getTrustedCert();
                returnval.add(cert);
            }
        }
        return returnval;
    }

    private static Collection<Certificate> orderCertificateChain(Collection<?> certlist) throws CertPathValidatorException {
        int i;
        ArrayList<Certificate> returnval = new ArrayList<Certificate>();
        Certificate rootca = null;
        HashMap<String, Certificate> cacertmap = new HashMap<String, Certificate>();
        for (Object possibleCertificate : certlist) {
            Certificate cert = null;
            try {
                cert = (Certificate)possibleCertificate;
            }
            catch (ClassCastException e) {
                byte[] certBytes = (byte[])possibleCertificate;
                try {
                    cert = CertTools.getCertfromByteArray(certBytes);
                }
                catch (CertificateParsingException e1) {
                    throw new CertPathValidatorException(e1);
                }
            }
            if (CertTools.isSelfSigned(cert)) {
                rootca = cert;
                continue;
            }
            log.debug((Object)("Adding to cacertmap with index '" + CertTools.getIssuerDN(cert) + "'"));
            cacertmap.put(CertTools.getIssuerDN(cert), cert);
        }
        if (rootca == null) {
            throw new CertPathValidatorException("No root CA certificate found in certificatelist");
        }
        returnval.add(0, rootca);
        Certificate currentcert = rootca;
        for (i = 0; certlist.size() != returnval.size() && i <= certlist.size(); ++i) {
            Certificate nextcert;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking in cacertmap for '" + CertTools.getSubjectDN(currentcert) + "'"));
            }
            if ((nextcert = (Certificate)cacertmap.get(CertTools.getSubjectDN(currentcert))) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Dumping keys of CA certificate map:");
                    for (String issuerDn : cacertmap.keySet()) {
                        log.debug((Object)issuerDn);
                    }
                }
                throw new CertPathValidatorException("Error building certificate path. Could find certificate with SubjectDN " + CertTools.getSubjectDN(currentcert) + " in certificate map. See debug log for details.");
            }
            returnval.add(0, nextcert);
            currentcert = nextcert;
        }
        if (i > certlist.size()) {
            throw new CertPathValidatorException("Error building certificate path");
        }
        return returnval;
    }

    public static boolean compareCertificateChains(Certificate[] chainA, Certificate[] chainB) {
        if (chainA == null || chainB == null) {
            return false;
        }
        if (chainA.length != chainB.length) {
            return false;
        }
        for (int i = 0; i < chainA.length; ++i) {
            if (chainA[i] != null && chainA[i].equals(chainB[i])) continue;
            return false;
        }
        return true;
    }

    public static String dumpCertificateAsString(Certificate cert) {
        String ret = null;
        if (cert instanceof X509Certificate) {
            try {
                Certificate c = CertTools.getCertfromByteArray(cert.getEncoded());
                ret = c.toString();
            }
            catch (CertificateException e) {
                ret = e.getMessage();
            }
        } else if (StringUtils.equals((String)cert.getType(), (String)"CVC")) {
            CardVerifiableCertificate cvccert = (CardVerifiableCertificate)cert;
            CVCertificate obj = cvccert.getCVCertificate();
            ret = obj.getAsText("");
        } else {
            throw new IllegalArgumentException("dumpCertificateAsString: Certificate of type " + cert.getType() + " is not implemented");
        }
        return ret;
    }

    public static PKCS10CertificationRequest genPKCS10CertificationRequest(String signatureAlgorithm, X500Name subject, PublicKey publickey, ASN1Set attributes, PrivateKey privateKey, String provider) throws OperatorCreationException {
        BufferingContentSigner signer;
        CertificationRequestInfo reqInfo;
        try {
            ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])publickey.getEncoded());
            SubjectPublicKeyInfo pkinfo = new SubjectPublicKeyInfo(seq);
            reqInfo = new CertificationRequestInfo(subject, pkinfo, attributes);
            if (provider == null) {
                provider = "BC";
            }
            signer = new BufferingContentSigner(new JcaContentSignerBuilder(signatureAlgorithm).setProvider(provider).build(privateKey), 20480);
            signer.getOutputStream().write(reqInfo.getEncoded("DER"));
            signer.getOutputStream().flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException was caught.", e);
        }
        byte[] sig = signer.getSignature();
        DERBitString sigBits = new DERBitString(sig);
        CertificationRequest req = new CertificationRequest(reqInfo, signer.getAlgorithmIdentifier(), sigBits);
        return new PKCS10CertificationRequest(req);
    }

    public static ContentVerifierProvider genContentVerifierProvider(PublicKey pubkey) throws OperatorCreationException {
        return new JcaContentVerifierProviderBuilder().build(pubkey);
    }

    public static final JcaX509CertificateHolder[] convertToX509CertificateHolder(X509Certificate[] certificateChain) throws CertificateEncodingException {
        JcaX509CertificateHolder[] certificateHolderChain = new JcaX509CertificateHolder[certificateChain.length];
        for (int i = 0; i < certificateChain.length; ++i) {
            certificateHolderChain[i] = new JcaX509CertificateHolder(certificateChain[i]);
        }
        return certificateHolderChain;
    }

    public static final List<JcaX509CertificateHolder> convertToX509CertificateHolder(List<X509Certificate> certificateChain) throws CertificateEncodingException {
        ArrayList<JcaX509CertificateHolder> certificateHolderChain = new ArrayList<JcaX509CertificateHolder>();
        for (X509Certificate certificate : certificateChain) {
            certificateHolderChain.add(new JcaX509CertificateHolder(certificate));
        }
        return certificateHolderChain;
    }

    public static final List<X509Certificate> convertToX509CertificateList(Collection<X509CertificateHolder> certificateHolderChain) throws CertificateException {
        ArrayList<X509Certificate> ret = new ArrayList<X509Certificate>();
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        for (X509CertificateHolder certificateHolder : certificateHolderChain) {
            ret.add(jcaX509CertificateConverter.getCertificate(certificateHolder));
        }
        return ret;
    }

    public static final X509Certificate[] convertToX509CertificateArray(Collection<X509CertificateHolder> certificateHolderChain) throws CertificateException {
        return CertTools.convertToX509CertificateList(certificateHolderChain).toArray(new X509Certificate[0]);
    }

    public static final List<X509CRL> convertToX509CRLList(Collection<X509CRLHolder> crlHolders) throws CRLException {
        ArrayList<X509CRL> ret = new ArrayList<X509CRL>();
        JcaX509CRLConverter jcaX509CRLConverter = new JcaX509CRLConverter();
        for (X509CRLHolder crlHolder : crlHolders) {
            ret.add(jcaX509CRLConverter.getCRL(crlHolder));
        }
        return ret;
    }

    public static void checkNameConstraints(X509Certificate issuer, X500Name subjectDNName, GeneralNames subjectAltName) throws IllegalNameException {
        NameConstraints nc;
        byte[] ncbytes = issuer.getExtensionValue(Extension.nameConstraints.getId());
        ASN1OctetString ncstr = ncbytes != null ? DEROctetString.getInstance((Object)ncbytes) : null;
        ASN1Sequence ncseq = ncbytes != null ? DERSequence.getInstance((Object)ncstr.getOctets()) : null;
        NameConstraints nameConstraints = nc = ncseq != null ? NameConstraints.getInstance((Object)ncseq) : null;
        if (nc != null) {
            X500Name issuerDNName;
            if (subjectDNName != null && (issuerDNName = X500Name.getInstance((Object)issuer.getSubjectX500Principal().getEncoded())).equals((Object)subjectDNName)) {
                return;
            }
            PKIXNameConstraintValidator validator = new PKIXNameConstraintValidator();
            GeneralSubtree[] permitted = nc.getPermittedSubtrees();
            GeneralSubtree[] excluded = nc.getExcludedSubtrees();
            if (permitted != null) {
                validator.intersectPermittedSubtree(permitted);
            }
            if (excluded != null) {
                for (GeneralSubtree generalSubtree : excluded) {
                    validator.addExcludedSubtree(generalSubtree);
                }
            }
            if (subjectDNName != null) {
                GeneralName dngn = new GeneralName(subjectDNName);
                try {
                    validator.checkPermitted(dngn);
                    validator.checkExcluded(dngn);
                }
                catch (PKIXNameConstraintValidatorException e) {
                    boolean bl;
                    String dnStr = subjectDNName.toString();
                    boolean bl2 = bl = CertTools.dnHasMultipleComponents(dnStr) && !CertTools.isDNReversed(dnStr);
                    if (bl) {
                        String msg = intres.getLocalizedMessage("nameconstraints.x500dnorderrequired", new Object[0]);
                        throw new IllegalNameException(msg);
                    }
                    String msg = intres.getLocalizedMessage("nameconstraints.forbiddensubjectdn", subjectDNName);
                    throw new IllegalNameException(msg, (Exception)((Object)e));
                }
            }
            if (subjectAltName != null) {
                for (GeneralSubtree generalSubtree : subjectAltName.getNames()) {
                    try {
                        validator.checkPermitted((GeneralName)generalSubtree);
                        validator.checkExcluded((GeneralName)generalSubtree);
                    }
                    catch (PKIXNameConstraintValidatorException e) {
                        String msg = intres.getLocalizedMessage("nameconstraints.forbiddensubjectaltname", generalSubtree);
                        throw new IllegalNameException(msg, (Exception)((Object)e));
                    }
                }
            }
        }
    }

    static {
        DnComponents.getDnObjects(true);
        EMAILIDS = new String[]{EMAIL, EMAIL1, EMAIL2, EMAIL3};
    }

    private static class BasicX509NameTokenizer {
        private final String oid;
        private int index = -1;
        private StringBuilder buf = new StringBuilder();

        public BasicX509NameTokenizer(String oid) {
            this.oid = oid;
        }

        public boolean hasMoreTokens() {
            return this.index != this.oid.length();
        }

        public String nextToken() {
            int end;
            if (this.index == this.oid.length()) {
                return null;
            }
            boolean quoted = false;
            boolean escaped = false;
            this.buf.setLength(0);
            for (end = this.index + 1; end != this.oid.length(); ++end) {
                char c = this.oid.charAt(end);
                if (c == '\"') {
                    if (!escaped) {
                        this.buf.append(c);
                        quoted ^= true;
                    } else {
                        this.buf.append(c);
                    }
                    escaped = false;
                    continue;
                }
                if (escaped || quoted) {
                    this.buf.append(c);
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    this.buf.append(c);
                    escaped = true;
                    continue;
                }
                if (c == ',' && !escaped) break;
                this.buf.append(c);
            }
            this.index = end;
            return this.buf.toString().trim();
        }
    }

    private static class X509NameTokenizer {
        private String value;
        private int index;
        private char separator;
        private StringBuffer buf = new StringBuffer();

        public X509NameTokenizer(String oid) {
            this(oid, ',');
        }

        public X509NameTokenizer(String oid, char separator) {
            this.value = oid;
            this.index = -1;
            this.separator = separator;
        }

        public boolean hasMoreTokens() {
            return this.index != this.value.length();
        }

        public String nextToken() {
            int end;
            if (this.index == this.value.length()) {
                return null;
            }
            boolean quoted = false;
            boolean escaped = false;
            this.buf.setLength(0);
            for (end = this.index + 1; end != this.value.length(); ++end) {
                char c = this.value.charAt(end);
                if (c == '\"') {
                    if (!escaped) {
                        quoted = !quoted;
                    } else {
                        if (c == '#' && this.buf.charAt(this.buf.length() - 1) == '=') {
                            this.buf.append('\\');
                        } else if (c == '+' && this.separator != '+') {
                            this.buf.append('\\');
                        }
                        this.buf.append(c);
                    }
                    escaped = false;
                    continue;
                }
                if (escaped || quoted) {
                    if (c == '#' && this.buf.charAt(this.buf.length() - 1) == '=') {
                        this.buf.append('\\');
                    } else if (c == '+' && this.separator != '+') {
                        this.buf.append('\\');
                    }
                    this.buf.append(c);
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c == this.separator) break;
                this.buf.append(c);
            }
            this.index = end;
            return this.buf.toString().trim();
        }

        String getRemainingString() {
            return this.index + 1 < this.value.length() ? this.value.substring(this.index + 1) : "";
        }
    }
}

