/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.log4j.Logger;

public class CompressedCollection<T extends Serializable>
implements Collection<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(CompressedCollection.class);
    private ByteArrayOutputStream baos = null;
    private ObjectOutputStream oos = null;
    private byte[] compressedData = null;
    private int size = 0;
    private final List<ObjectInputStream> oiss = new ArrayList<ObjectInputStream>();

    public CompressedCollection() {
        this.clear();
    }

    @Override
    public boolean add(T object) {
        boolean ret = false;
        if (object != null) {
            try {
                this.getObjectOutputStream().writeObject(object);
                ret = true;
                ++this.size;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return ret;
    }

    private ObjectOutputStream getObjectOutputStream() throws IOException {
        if (this.oos == null) {
            this.baos = new ByteArrayOutputStream();
            DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)this.baos, new Deflater(9));
            this.oos = new ObjectOutputStream(dos);
        }
        return this.oos;
    }

    @Override
    public boolean addAll(Collection<? extends T> objects) {
        for (Serializable object : objects) {
            this.add((T)object);
        }
        return objects.size() != 0;
    }

    @Override
    public void clear() {
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            this.oos = null;
        }
        this.size = 0;
        this.compressedData = null;
        for (ObjectInputStream ois : this.oiss) {
            try {
                ois.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.oiss.clear();
    }

    @Override
    public boolean contains(Object object) {
        for (Serializable t : this) {
            if (!t.equals(object)) continue;
            try {
                this.oiss.get(this.oiss.size() - 1).close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.oiss.remove(this.oiss.size() - 1);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void closeForWrite() {
        if (this.compressedData == null) {
            if (this.oos == null) {
                this.compressedData = new byte[0];
            } else {
                try {
                    this.oos.flush();
                    this.oos.close();
                    this.oos = null;
                    this.compressedData = this.baos.toByteArray();
                    this.baos = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Compressed data of " + this.size + " entries to " + this.compressedData.length + " bytes."));
                    }
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public Iterator<T> iterator() {
        ObjectInputStream ois;
        this.closeForWrite();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.compressedData);
        InflaterInputStream iis = new InflaterInputStream(bais);
        if (this.compressedData.length == 0) {
            ois = null;
        } else {
            try {
                ois = new ObjectInputStream(iis);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.oiss.add(ois);
        }
        return new Iterator<T>(){
            private T next = null;

            @Override
            public boolean hasNext() {
                try {
                    this.next = this.readNext();
                }
                catch (NoSuchElementException e) {
                    return false;
                }
                return true;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    return this.readNext();
                }
                Object ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private T readNext() {
                if (ois == null) {
                    throw new NoSuchElementException();
                }
                try {
                    return (Serializable)ois.readObject();
                }
                catch (IOException e) {
                    this.cleanUp();
                    throw new NoSuchElementException();
                }
                catch (ClassNotFoundException e) {
                    this.cleanUp();
                    throw new NoSuchElementException();
                }
            }

            private void cleanUp() {
                CompressedCollection.this.oiss.remove(ois);
                try {
                    ois.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T2> T2[] toArray(T2[] arg0) {
        throw new UnsupportedOperationException();
    }
}

