/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public final class ConcurrentCache<K, V> {
    private static final Logger log = Logger.getLogger(ConcurrentCache.class);
    private final ConcurrentHashMap<K, InternalEntry<V>> cache = new ConcurrentHashMap();
    private final ConcurrentMap<K, Object> semaphores = new ConcurrentHashMap<K, Object>();
    public static final long NO_LIMIT = -1L;
    private volatile boolean enabled = true;
    private volatile long maxEntries = -1L;
    private AtomicLong numEntries = new AtomicLong(0L);
    private final Set<K> pendingRemoval = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Lock isCleaning = new ReentrantLock();
    private volatile long lastCleanup = 0L;
    private volatile long cleanupInterval = 1000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry openCacheEntry(K key, long timeout) {
        InternalEntry<V> entry;
        long toExpire;
        long timeAtEntry = System.currentTimeMillis();
        if (key == null) {
            throw new NullPointerException("key may not be null");
        }
        if (!this.enabled) {
            return new Entry(null, null);
        }
        if (this.maxEntries != -1L) {
            this.pendingRemoval.remove(key);
        }
        long l = toExpire = (entry = this.cache.get(key)) != null ? entry.expire : 0L;
        if (entry != null && toExpire > timeAtEntry) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found valid entry in cache for key " + key));
                log.trace((Object)"<ConcurrentCacheMap.openCacheEntry");
            }
            this.cleanupIfNeeded();
            return new Entry(key, entry);
        }
        if (entry != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache entry has expired " + key + ", expiry=" + entry.expire));
            }
            this.numEntries.decrementAndGet();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Entry was not present in cache " + key));
        }
        Object ourSemaphore = new Object();
        Object theirSemaphore = this.semaphores.putIfAbsent(key, ourSemaphore);
        if (theirSemaphore == null) {
            this.numEntries.incrementAndGet();
            this.cleanupIfHighlyNeeded();
            return new Entry(key, null, ourSemaphore);
        }
        try {
            Object object = theirSemaphore;
            synchronized (object) {
                if (!this.cache.containsKey(key)) {
                    this.cleanupIfNeeded();
                    theirSemaphore.wait(timeout);
                    while (!this.cache.containsKey(key) && System.currentTimeMillis() < timeAtEntry + timeout) {
                        theirSemaphore.wait(timeout / 10L + 1L);
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        entry = this.cache.get(key);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got " + entry.value + " after waiting for cache"));
            log.trace((Object)"<ConcurrentCacheMap.openCacheEntry");
        }
        return entry != null ? new Entry(key, entry) : null;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setMaxEntries(long maxEntries) {
        if (maxEntries != -1L && maxEntries <= 0L) {
            throw new IllegalArgumentException("max entries must be either a positive value or -1");
        }
        this.maxEntries = maxEntries;
    }

    public long getMaxEntries() {
        return this.maxEntries;
    }

    public void setCleanupInterval(long milliseconds) {
        this.cleanupInterval = milliseconds;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    private void cleanupIfNeeded() {
        if (this.maxEntries != -1L && this.numEntries.get() > this.maxEntries) {
            this.cleanup();
        }
    }

    private void cleanupIfHighlyNeeded() {
        if (this.maxEntries != -1L && 2L * this.numEntries.get() > 3L * this.maxEntries) {
            this.cleanup();
        }
    }

    void checkNumberOfEntries(long min, long max) {
        long b;
        long a = this.numEntries.get();
        if (a != (b = (long)this.cache.size())) {
            throw new IllegalStateException("cache.size() and numEntries does not match (" + a + " and " + b + ")");
        }
        if (a < min) {
            throw new IllegalStateException("number of entries (" + a + ") is less than minimum (" + min + ").");
        }
        if (a > max) {
            throw new IllegalStateException("number of entries (" + a + ") is greater than maximum (" + max + ").");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        long startTime = System.currentTimeMillis();
        if (startTime < this.lastCleanup + this.cleanupInterval || !this.isCleaning.tryLock()) {
            return;
        }
        try {
            Random random;
            float ratioToRemove;
            if (this.maxEntries == -1L) {
                ratioToRemove = 0.0f;
                random = null;
            } else {
                ratioToRemove = Math.max(0.0f, 1.0f - 0.8f * (float)this.maxEntries / (float)this.numEntries.get());
                for (K key : this.pendingRemoval) {
                    this.cache.remove(key);
                    this.numEntries.decrementAndGet();
                }
                this.pendingRemoval.clear();
                random = new Random(System.nanoTime());
            }
            long now = System.currentTimeMillis();
            Iterator<Map.Entry<K, InternalEntry<V>>> iter = this.cache.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<K, InternalEntry<V>> mapEntry = iter.next();
                if (mapEntry.getValue().expire <= now) {
                    iter.remove();
                    this.numEntries.decrementAndGet();
                    continue;
                }
                if (this.maxEntries == -1L || !(random.nextFloat() < ratioToRemove)) continue;
                this.pendingRemoval.add(mapEntry.getKey());
            }
        }
        finally {
            long endTime;
            this.isCleaning.unlock();
            this.lastCleanup = endTime = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Clean up took " + (endTime - startTime) + " ms"));
            }
        }
    }

    public void clear() {
        this.cache.clear();
        this.numEntries.set(0L);
        this.pendingRemoval.clear();
        this.lastCleanup = 0L;
    }

    public final class Entry {
        private final K key;
        private InternalEntry<V> entry;
        private final Object ourSemaphore;

        private Entry(K key, InternalEntry<V> entry) {
            this.key = key;
            this.entry = entry;
            this.ourSemaphore = null;
        }

        private Entry(K key, InternalEntry<V> entry, Object ourSemaphore) {
            if (ourSemaphore == null) {
                throw new IllegalArgumentException("ourSemaphore may not be null");
            }
            this.key = key;
            this.entry = entry;
            this.ourSemaphore = ourSemaphore;
        }

        public boolean isInCache() {
            return this.entry != null;
        }

        public V getValue() {
            if (this.entry == null) {
                throw new IllegalStateException("Tried to read from non-existent cache entry");
            }
            return this.entry.value;
        }

        public void putValue(V value) {
            if (this.key != null) {
                this.entry = new InternalEntry(value);
                ConcurrentCache.this.cache.put(this.key, this.entry);
            }
        }

        public void setCacheValidity(long validFor) {
            if (this.entry != null) {
                this.entry.expire = System.currentTimeMillis() + validFor;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.ourSemaphore != null) {
                Object object = this.ourSemaphore;
                synchronized (object) {
                    ConcurrentCache.this.semaphores.remove(this.key);
                    this.ourSemaphore.notifyAll();
                }
            }
        }
    }

    private static final class InternalEntry<V> {
        final V value;
        volatile long expire;

        private InternalEntry(V value) {
            this.value = value;
            this.expire = Long.MAX_VALUE;
        }
    }
}

