/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.encoders.Hex;
import org.cesecore.config.CesecoreConfiguration;
import org.ejbca.cvc.CVCProvider;

public final class CryptoProviderTools {
    private static final Logger log = Logger.getLogger(CryptoProviderTools.class);
    private static final String IMPLICITLYCA_Q = CesecoreConfiguration.getEcdsaImplicitlyCaQ();
    private static final String IMPLICITLYCA_A = CesecoreConfiguration.getEcdsaImplicitlyCaA();
    private static final String IMPLICITLYCA_B = CesecoreConfiguration.getEcdsaImplicitlyCaB();
    private static final String IMPLICITLYCA_G = CesecoreConfiguration.getEcdsaImplicitlyCaG();
    private static final String IMPLICITLYCA_N = CesecoreConfiguration.getEcdsaImplicitlyCaN();
    public static String SYSTEM_SECURITY_PROVIDER = "SUN";

    private CryptoProviderTools() {
    }

    public static boolean isUsingExportableCryptography() {
        boolean returnValue = true;
        try {
            int keylen = Cipher.getMaxAllowedKeyLength("DES");
            if (log.isDebugEnabled()) {
                log.debug((Object)("MaxAllowedKeyLength for DES is: " + keylen));
            }
            if (keylen == Integer.MAX_VALUE) {
                returnValue = false;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return returnValue;
    }

    public static synchronized void installBCProviderIfNotAvailable() {
        if (Security.getProvider("BC") == null) {
            CryptoProviderTools.installBCProvider();
        }
    }

    public static synchronized void removeBCProvider() {
        Security.removeProvider("BC");
        Security.removeProvider("CVC");
    }

    public static synchronized void installBCProvider() {
        boolean installImplicitlyCA = false;
        if (Security.addProvider((Provider)new BouncyCastleProvider()) < 0) {
            if (CesecoreConfiguration.isDevelopmentProviderInstallation()) {
                CryptoProviderTools.removeBCProvider();
                if (Security.addProvider((Provider)new BouncyCastleProvider()) < 0) {
                    log.error((Object)"Cannot even install BC provider again!");
                } else {
                    installImplicitlyCA = true;
                }
            }
        } else {
            installImplicitlyCA = true;
        }
        try {
            Security.addProvider((Provider)new CVCProvider());
        }
        catch (Exception e) {
            log.info((Object)"CVC provider can not be installed, CVC certificate will not work: ", (Throwable)e);
        }
        if (installImplicitlyCA) {
            ECCurve.Fp curve = new ECCurve.Fp(new BigInteger(IMPLICITLYCA_Q), new BigInteger(IMPLICITLYCA_A, 16), new BigInteger(IMPLICITLYCA_B, 16));
            ECParameterSpec implicitSpec = new ECParameterSpec((ECCurve)curve, curve.decodePoint(Hex.decode((String)IMPLICITLYCA_G)), new BigInteger(IMPLICITLYCA_N));
            ConfigurableProvider config = (ConfigurableProvider)Security.getProvider("BC");
            if (config != null) {
                config.setParameter("ecImplicitlyCa", (Object)implicitSpec);
            } else {
                log.error((Object)"Can not get ConfigurableProvider, implicitlyCA EC parameters NOT set!");
            }
        }
        X509Name.DefaultSymbols.put(X509Name.SN, "SN");
        Provider p = Security.getProvider(SYSTEM_SECURITY_PROVIDER);
        if (p == null) {
            log.debug((Object)"SUN security provider does not exist, using BC as system default provider.");
            SYSTEM_SECURITY_PROVIDER = "BC";
        }
    }
}

