/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cesecore.certificates.certificate.CertificateWrapper;
import org.cesecore.util.CertificateSerializableWrapper;

public final class EJBTools {
    private EJBTools() {
    }

    public static CertificateWrapper wrap(Certificate cert) {
        if (cert == null) {
            return null;
        }
        return new CertificateSerializableWrapper(cert);
    }

    public static Certificate unwrap(CertificateWrapper certWrapper) {
        if (certWrapper == null) {
            return null;
        }
        return certWrapper.getCertificate();
    }

    public static List<CertificateWrapper> wrapCertCollection(Collection<Certificate> certs) {
        if (certs == null) {
            return null;
        }
        ArrayList<CertificateWrapper> list = new ArrayList<CertificateWrapper>(certs.size());
        for (Certificate cert : certs) {
            list.add(EJBTools.wrap(cert));
        }
        return list;
    }

    public static List<Certificate> unwrapCertCollection(Collection<CertificateWrapper> wrappedCerts) {
        if (wrappedCerts == null) {
            return null;
        }
        ArrayList<Certificate> list = new ArrayList<Certificate>(wrappedCerts.size());
        for (CertificateWrapper wrapped : wrappedCerts) {
            list.add(EJBTools.unwrap(wrapped));
        }
        return list;
    }
}

