/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cesecore.jndi.JndiHelper;

public enum EjbRemoteHelper {
    INSTANCE;

    public static final String MODULE_EJBCA = "ejbca-ejb";
    public static final String MODULE_CESECORE = "cesecore-ejb";
    public static final String MODULE_CESECORE_OTHER = "cesecore-other-ejb";
    public static final String MODULE_TEST = "systemtests-ejb";
    private Map<Class<?>, Object> interfaceCache;

    public <T> T getRemoteSession(Class<T> key) {
        return this.getRemoteSession(key, null);
    }

    public <T> T getRemoteSession(Class<T> key, String module) {
        Object session;
        if (this.interfaceCache == null) {
            this.interfaceCache = new ConcurrentHashMap();
        }
        if ((session = this.interfaceCache.get(key)) == null) {
            if (module == null) {
                module = key.getName().startsWith("org.cesecore") ? MODULE_CESECORE : MODULE_EJBCA;
            }
            if ((session = JndiHelper.getRemoteSession(key, module)) != null) {
                this.interfaceCache.put(key, session);
            }
        }
        return (T)session;
    }
}

