/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.log4j.Logger;
import org.cesecore.util.Base64;

public abstract class FileTools {
    private static final Logger log = Logger.getLogger(FileTools.class);

    public static byte[] getBytesFromPEM(byte[] inbuf, String beginKey, String endKey) throws IOException {
        byte[] bytes;
        String temp;
        if (log.isTraceEnabled()) {
            log.trace((Object)">getBytesFromPEM");
        }
        ByteArrayInputStream instream = new ByteArrayInputStream(inbuf);
        BufferedReader bufRdr = new BufferedReader(new InputStreamReader(instream));
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        PrintStream opstr = new PrintStream(ostr);
        while ((temp = bufRdr.readLine()) != null && !temp.equals(beginKey)) {
        }
        if (temp == null) {
            throw new IOException("Error in input buffer, missing " + beginKey + " boundary");
        }
        while ((temp = bufRdr.readLine()) != null && !temp.equals(endKey)) {
            if (temp.trim().length() <= 0) continue;
            opstr.print(temp);
        }
        if (temp == null) {
            throw new IOException("Error in input buffer, missing " + endKey + " boundary");
        }
        opstr.close();
        try {
            bytes = Base64.decode(ostr.toByteArray());
        }
        catch (Exception e) {
            throw new IOException("Malformed PEM encoding or PEM of unknown type: " + e.getMessage());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"<getBytesFromPEM");
        }
        return bytes;
    }

    public static byte[] readFiletoBuffer(String file) throws FileNotFoundException {
        FileInputStream in = new FileInputStream(file);
        return FileTools.readInputStreamtoBuffer(in);
    }

    public static byte[] readInputStreamtoBuffer(InputStream in) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            int len = 0;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                os.write(buf, 0, len);
            }
            in.close();
            os.close();
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Caught IOException for unknown reason", e);
        }
    }

    public static void sortByName(File[] files) {
        if (files == null) {
            return;
        }
        Arrays.sort(files, new FileComp());
    }

    public static File createTempDirectory() throws IOException {
        return FileTools.createTempDirectory(null);
    }

    public static File createTempDirectory(File location) throws IOException {
        File temp = File.createTempFile("tmp", Long.toString(System.nanoTime()), location);
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                FileTools.delete(subFile);
            }
        }
        if (!file.delete()) {
            log.error((Object)("Could not delete directory " + file.getAbsolutePath()));
        }
    }

    private static class FileComp
    implements Comparator<File> {
        private final Collator c = Collator.getInstance();

        private FileComp() {
        }

        @Override
        public int compare(File f1, File f2) {
            if (f1 == f2) {
                return 0;
            }
            if (f1.isDirectory() && f2.isFile()) {
                return -1;
            }
            if (f1.isFile() && f2.isDirectory()) {
                return 1;
            }
            return this.c.compare(f1.getName(), f2.getName());
        }
    }
}

