/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import org.apache.log4j.Logger;

public class GUIDGenerator {
    private static final Logger log = Logger.getLogger(GUIDGenerator.class);
    private static String hexServerIP = null;
    private static final Random seeder = new Random();

    public static final String generateGUID(Object o) {
        if (hexServerIP == null) {
            InetAddress localInetAddress = null;
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                log.error((Object)"Could not get the local IP address using InetAddress.getLocalHost(): ", (Throwable)uhe);
                return null;
            }
            byte[] serverIP = localInetAddress.getAddress();
            hexServerIP = GUIDGenerator.hexFormat(GUIDGenerator.getInt(serverIP), 8);
        }
        String hashcode = GUIDGenerator.hexFormat(System.identityHashCode(o), 8);
        long timeNow = System.currentTimeMillis() ^ System.nanoTime();
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        int node = seeder.nextInt();
        StringBuilder guid = new StringBuilder(32);
        guid.append(GUIDGenerator.hexFormat(timeLow, 8));
        guid.append(hexServerIP);
        guid.append(hashcode);
        guid.append(GUIDGenerator.hexFormat(node, 8));
        return guid.toString();
    }

    private static int getInt(byte[] bytes) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = bytes[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i, int j) {
        String s = Integer.toHexString(i);
        return GUIDGenerator.padHex(s, j) + s;
    }

    private static String padHex(String s, int i) {
        StringBuilder tmpBuffer = new StringBuilder();
        if (s.length() < i) {
            for (int j = 0; j < i - s.length(); ++j) {
                tmpBuffer.append('0');
            }
        }
        return tmpBuffer.toString();
    }
}

