/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;
import org.cesecore.config.CesecoreConfiguration;

public final class JBossUnmarshaller {
    private static final Logger LOG = Logger.getLogger(JBossUnmarshaller.class);
    private static final String JBOSS_MARSHALL_CLASS = "org.jboss.invocation.MarshalledValue";
    private static boolean lookForJbossMarshaller = true;

    private JBossUnmarshaller() {
    }

    public static <T> T extractObject(Class<T> t, Serializable object) throws ClassCastException {
        Object ret = null;
        String className = object.getClass().getName();
        if (JBOSS_MARSHALL_CLASS.equals(className)) {
            try {
                Method m = object.getClass().getMethod("get", new Class[0]);
                ret = m.invoke((Object)object, new Object[0]);
            }
            catch (SecurityException e) {
                LOG.error((Object)"", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.error((Object)"", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)"", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)"", (Throwable)e);
            }
        } else {
            ret = object;
        }
        return (T)ret;
    }

    public static LinkedHashMap<?, ?> extractLinkedHashMap(Serializable object) {
        LinkedHashMap ret = null;
        try {
            ret = JBossUnmarshaller.extractObject(LinkedHashMap.class, object);
            if (ret != null) {
                return ret;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return new LinkedHashMap(JBossUnmarshaller.extractObject(HashMap.class, object));
    }

    public static Serializable serializeObject(Serializable object) {
        Serializable ret = object;
        if (lookForJbossMarshaller && CesecoreConfiguration.isKeepJbossSerializationIfUsed()) {
            try {
                ret = (Serializable)Class.forName(JBOSS_MARSHALL_CLASS).getConstructor(Object.class).newInstance(object);
            }
            catch (ClassNotFoundException e1) {
                LOG.debug((Object)"org.jboss.invocation.MarshalledValue does not exist. Assuming that this is a non-JBoss installation.");
                lookForJbossMarshaller = false;
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to store as JBoss MarshalledValue.", (Throwable)e);
            }
        }
        return ret;
    }
}

