/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public abstract class NetworkTools {
    private static final Logger log = Logger.getLogger(NetworkTools.class);

    public static URL getValidHttpUrl(String cdp) {
        URL url;
        if (cdp == null) {
            return null;
        }
        try {
            url = new URL(cdp);
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (!"http".equals(url.getProtocol().toLowerCase())) {
            return null;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] downloadDataFromUrl(URL url, int maxSize) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] data = new byte[32768];
        int downloadedBytes = 0;
        InputStream is = null;
        try {
            int count;
            is = url.openStream();
            while ((count = is.read(data)) != -1) {
                baos.write(data, 0, count);
            }
            if ((downloadedBytes += count) > maxSize) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed to download data from " + url.toString() + ". Size exceedes " + maxSize + " bytes."));
                }
                byte[] byArray = null;
                return byArray;
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to download data from " + url.toString()), (Throwable)e);
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            block19: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!log.isDebugEnabled()) break block19;
                        log.debug((Object)("Failed to download data from " + url.toString()), (Throwable)e);
                    }
                }
            }
        }
        return baos.toByteArray();
    }
}

