/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.cesecore.util.CeSecoreNameStyle;

public class PrintableStringNameStyle
extends CeSecoreNameStyle {
    public static final X500NameStyle INSTANCE = new PrintableStringNameStyle();

    protected PrintableStringNameStyle() {
    }

    private boolean canBePrintable(String str) {
        return DERPrintableString.isPrintableString((String)str);
    }

    @Override
    public ASN1Encodable stringToValue(ASN1ObjectIdentifier oid, String value) {
        if (value.length() != 0 && value.charAt(0) == '#') {
            try {
                return IETFUtils.valueFromHexString((String)value, (int)1);
            }
            catch (IOException e) {
                throw new RuntimeException("can't recode value for oid " + oid.getId());
            }
        }
        if (value.length() != 0 && value.charAt(0) == '\\') {
            value = value.substring(1);
        } else {
            if (oid.equals((Object)CeSecoreNameStyle.EmailAddress) || oid.equals((Object)CeSecoreNameStyle.DC)) {
                return new DERIA5String(value);
            }
            if (oid.equals((Object)DATE_OF_BIRTH)) {
                return new ASN1GeneralizedTime(value);
            }
            if (this.canBePrintable(value)) {
                return new DERPrintableString(value);
            }
        }
        return new DERUTF8String(value);
    }
}

