/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.util.List;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;

public abstract class QueryResultWrapper {
    public static <T> T getSingleResult(Query query) {
        return QueryResultWrapper.getSingleResult(query, null);
    }

    public static <T> T getSingleResult(Query query, T defaultValue) {
        List resultList = query.getResultList();
        switch (resultList.size()) {
            case 0: {
                return defaultValue;
            }
            case 1: {
                Object value = resultList.get(0);
                if (value == null) {
                    return defaultValue;
                }
                return (T)value;
            }
        }
        throw new NonUniqueResultException();
    }

    public static <T> T getLastResult(Query query) {
        List resultList = query.getResultList();
        switch (resultList.size()) {
            case 0: {
                return null;
            }
        }
        return (T)resultList.get(resultList.size() - 1);
    }
}

