/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cesecore.util.UnitParser;

public class SimpleTime {
    public static final long MILLISECONDS_PER_DAY = 86400000L;
    public static final long MILLISECONDS_PER_HOUR = 3600000L;
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    public static final long MILLISECONDS_PER_SECOND = 1000L;
    public static final String TYPE_DAYS = "d";
    public static final String TYPE_HOURS = "h";
    public static final String TYPE_MINUTES = "m";
    public static final String TYPE_SECONDS = "s";
    public static final String TYPE_MILLISECONDS = "ms";
    private static final Logger log = Logger.getLogger(SimpleTime.class);
    private static final UnitParser unitParser = new UnitParser(Arrays.asList("d", "h", "m", "s", "ms"));
    private long longTime = 0L;
    private long days = 0L;
    private long hours = 0L;
    private long minutes = 0L;
    private long seconds = 0L;
    private long milliSeconds = 0L;

    private SimpleTime(long time) {
        this.longTime = time;
        this.days = time / 86400000L;
        this.hours = (time %= 86400000L) / 3600000L;
        this.minutes = (time %= 3600000L) / 60000L;
        this.seconds = (time %= 60000L) / 1000L;
        this.milliSeconds = time % 1000L;
    }

    private SimpleTime(String time) throws Exception {
        this.parse(time);
    }

    private SimpleTime(String time, String defaultTime) throws Exception {
        if (time == null || time.trim().length() == 0) {
            time = defaultTime;
        }
        this.parse(time);
    }

    public static SimpleTime getInstance(long time) {
        return new SimpleTime(time);
    }

    public static SimpleTime getInstance(String time) {
        SimpleTime simpleTime = null;
        try {
            simpleTime = new SimpleTime(time);
        }
        catch (Exception e) {
            log.info((Object)("Failed to parse time \"" + time + "\". " + e.getMessage()));
        }
        return simpleTime;
    }

    public static SimpleTime getInstance(String time, String defaultTime) {
        SimpleTime simpleTime = null;
        try {
            simpleTime = new SimpleTime(time, defaultTime);
        }
        catch (Exception e) {
            log.info((Object)("Failed to parse time or defaultTime \"" + time + "\", \"" + defaultTime + "\". " + e.getMessage()));
        }
        return simpleTime;
    }

    private void parse(String time) throws Exception {
        Map<String, Long> values = unitParser.parse(time);
        this.days = values.get(TYPE_DAYS);
        this.hours = values.get(TYPE_HOURS);
        this.minutes = values.get(TYPE_MINUTES);
        this.seconds = values.get(TYPE_SECONDS);
        this.milliSeconds = values.get(TYPE_MILLISECONDS);
        this.longTime = this.days * 86400000L + this.hours * 3600000L + this.minutes * 60000L + this.seconds * 1000L + this.milliSeconds;
    }

    public long getLong() {
        return this.longTime;
    }

    public long getDays() {
        return this.days;
    }

    public long getHours() {
        return this.hours;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getMilliSeconds() {
        return this.milliSeconds;
    }

    public String toString() {
        return this.toString(TYPE_SECONDS);
    }

    public String toString(String zeroType) {
        String ret = "";
        if (this.getDays() != 0L) {
            ret = ret + this.getDays() + TYPE_DAYS;
        }
        if (this.getHours() != 0L) {
            ret = ret + (ret.length() == 0 ? "" : " ") + this.getHours() + TYPE_HOURS;
        }
        if (this.getMinutes() != 0L) {
            ret = ret + (ret.length() == 0 ? "" : " ") + this.getMinutes() + TYPE_MINUTES;
        }
        if (this.getSeconds() != 0L) {
            ret = ret + (ret.length() == 0 ? "" : " ") + this.getSeconds() + TYPE_SECONDS;
        }
        if (this.getMilliSeconds() != 0L) {
            ret = ret + (ret.length() == 0 ? "" : " ") + this.getMilliSeconds() + TYPE_MILLISECONDS;
        }
        if (ret.length() == 0) {
            ret = "0" + zeroType;
        }
        return ret;
    }
}

