/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;
import org.cesecore.config.CesecoreConfiguration;
import org.cesecore.util.Base64;
import org.cesecore.util.CryptoProviderTools;

public final class StringTools {
    private static final Logger log = Logger.getLogger(StringTools.class);
    private static Pattern VALID_IPV4_PATTERN = null;
    private static Pattern VALID_IPV6_PATTERN = null;
    private static final String ipv4Pattern = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static final String ipv6Pattern = "([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}";
    private static final CharSet stripXSS;
    private static final CharSet stripSqlChars;
    private static final CharSet stripFilenameChars;
    private static final CharSet allowedEscapeChars;
    private static final Pattern WS;
    public static final int KEY_SEQUENCE_FORMAT_NUMERIC = 1;
    public static final int KEY_SEQUENCE_FORMAT_ALPHANUMERIC = 2;
    public static final int KEY_SEQUENCE_FORMAT_COUNTRY_CODE_PLUS_NUMERIC = 4;
    public static final int KEY_SEQUENCE_FORMAT_COUNTRY_CODE_PLUS_ALPHANUMERIC = 8;
    private static final char[] p;
    private static final int iCount = 100;

    private StringTools() {
    }

    public static String strip(String str) {
        return StringTools.strip(str, CharSet.getForbidden());
    }

    public static String stripUsername(String str) {
        String xssStripped = StringTools.strip(str, stripXSS);
        return StringTools.strip(xssStripped);
    }

    public static String stripFilename(String str) {
        return StringTools.strip(str, stripFilenameChars);
    }

    private static String strip(String str, CharSet stripThis) {
        if (str == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(str);
        int end = buf.length();
        for (int index = 0; index < end; ++index) {
            if (buf.charAt(index) == '\\') {
                if (index + 1 == end) {
                    buf.setCharAt(index, '/');
                    continue;
                }
                if (!StringTools.isAllowedEscape(buf.charAt(index + 1))) {
                    buf.setCharAt(index, '/');
                    buf.deleteCharAt(index + 1);
                    --end;
                    continue;
                }
                ++index;
                continue;
            }
            if (!stripThis.contains(buf.charAt(index))) continue;
            buf.setCharAt(index, '/');
        }
        String result = buf.toString();
        if (log.isDebugEnabled() && !result.equals(str)) {
            log.debug((Object)("Some chars stripped. Was '" + str + "' is now '" + result + "'."));
        }
        return result;
    }

    public static boolean hasSqlStripChars(String str) {
        return StringTools.hasStripChars(str, stripSqlChars);
    }

    public static boolean hasStripChars(String str) {
        return StringTools.hasStripChars(str, CharSet.getForbidden());
    }

    private static boolean hasStripChars(String str, CharSet checkThese) {
        if (str == null) {
            return false;
        }
        int end = str.length();
        for (int index = 0; index < end; ++index) {
            if (str.charAt(index) == '\\') {
                if (index + 1 == end) {
                    return true;
                }
                if (!StringTools.isAllowedEscape(str.charAt(index + 1))) {
                    return true;
                }
                ++index;
                continue;
            }
            if (!checkThese.contains(str.charAt(index))) continue;
            return true;
        }
        return false;
    }

    private static boolean isAllowedEscape(char ch) {
        return allowedEscapeChars.contains(ch) && !CharSet.getForbidden().contains(ch);
    }

    public static String stripWhitespace(String str) {
        if (str == null) {
            return null;
        }
        return WS.matcher(str).replaceAll("");
    }

    public static String ipOctetsToString(byte[] octets) {
        String ret = null;
        if (octets.length == 4) {
            String ip = "";
            for (int i = 0; i < 4; ++i) {
                int intByte = 0xFF & octets[i];
                short t = (short)intByte;
                if (StringUtils.isNotEmpty((String)ip)) {
                    ip = ip + ".";
                }
                ip = ip + t;
            }
            ret = ip;
        }
        return ret;
    }

    public static byte[] ipStringToOctets(String str) {
        byte[] ret = null;
        if (StringTools.isIpAddress(str)) {
            try {
                InetAddress adr = InetAddress.getByName(str);
                ret = adr.getAddress();
            }
            catch (UnknownHostException e) {
                log.info((Object)"Error parsing ip address (ipv4 or ipv6): ", (Throwable)e);
            }
        }
        if (ret == null) {
            log.info((Object)"Not a IPv4 or IPv6 address, returning empty array.");
            ret = new byte[]{};
        }
        return ret;
    }

    public static boolean isIpAddress(String ipAddress) {
        Matcher m1 = VALID_IPV4_PATTERN.matcher(ipAddress);
        if (m1.matches()) {
            return true;
        }
        Matcher m2 = VALID_IPV6_PATTERN.matcher(ipAddress);
        return m2.matches();
    }

    public static String putBase64String(String s) {
        return StringTools.putBase64String(s, false);
    }

    public static String putBase64String(String s, boolean dontEncodeAsciiPrintable) {
        if (StringUtils.isEmpty((String)s)) {
            return s;
        }
        if (s.startsWith("B64:")) {
            return s;
        }
        if (dontEncodeAsciiPrintable && StringUtils.isAsciiPrintable((String)s)) {
            return s;
        }
        String n = null;
        try {
            n = "B64:" + new String(Base64.encode(s.getBytes("UTF-8"), false));
        }
        catch (UnsupportedEncodingException e) {
            n = s;
        }
        return n;
    }

    public static String getBase64String(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return s;
        }
        String s1 = null;
        if (s.startsWith("B64:")) {
            s1 = new String(s.substring(4));
            String n = null;
            try {
                n = new String(Base64.decode(s1.getBytes("UTF-8")), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                n = s;
            }
            catch (DecoderException e) {
                n = s;
            }
            return n;
        }
        return s;
    }

    public static String obfuscateIfNot(String s) {
        if (s.startsWith("OBF:")) {
            return s;
        }
        return StringTools.obfuscate(s);
    }

    public static String obfuscate(String s) {
        StringBuilder buf = new StringBuilder("OBF:");
        byte[] b = s.getBytes();
        block3: for (int i = 0; i < b.length; ++i) {
            byte b1 = b[i];
            byte b2 = b[s.length() - (i + 1)];
            int i1 = b1 + b2 + 127;
            int i2 = b1 - b2 + 127;
            int i0 = i1 * 256 + i2;
            String x = Integer.toString(i0, 36);
            switch (x.length()) {
                case 1: 
                case 2: 
                case 3: {
                    buf.append('0');
                    continue block3;
                }
                default: {
                    buf.append(x);
                }
            }
        }
        return buf.toString();
    }

    public static String deobfuscateIf(String s) {
        if (s.startsWith("OBF:")) {
            return StringTools.deobfuscate(s);
        }
        return s;
    }

    public static String deobfuscate(String in) {
        String s = in;
        if (s.startsWith("OBF:")) {
            s = s.substring(4);
        }
        byte[] b = new byte[s.length() / 2];
        int l = 0;
        for (int i = 0; i < s.length(); i += 4) {
            String x = s.substring(i, i + 4);
            int i0 = Integer.parseInt(x, 36);
            int i1 = i0 / 256;
            int i2 = i0 % 256;
            b[l++] = (byte)((i1 + i2 - 254) / 2);
        }
        return new String(b, 0, l);
    }

    private static byte[] getSalt() throws UnsupportedEncodingException {
        String saltStr = "1958473059684739584hfurmaqiekcmq";
        return "1958473059684739584hfurmaqiekcmq".getBytes("UTF-8");
    }

    public static String pbeEncryptStringWithSha256Aes192(String in) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        CryptoProviderTools.installBCProviderIfNotAvailable();
        if (CryptoProviderTools.isUsingExportableCryptography()) {
            log.warn((Object)"Obfuscation not possible due to weak crypto policy.");
            return in;
        }
        SHA256Digest digest = new SHA256Digest();
        PKCS12ParametersGenerator pGen = new PKCS12ParametersGenerator((Digest)digest);
        pGen.init(PBEParametersGenerator.PKCS12PasswordToBytes((char[])p), StringTools.getSalt(), 100);
        ParametersWithIV params = (ParametersWithIV)pGen.generateDerivedParameters(192, 128);
        SecretKeySpec encKey = new SecretKeySpec(((KeyParameter)params.getParameters()).getKey(), "AES");
        Cipher c = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
        c.init(1, (Key)encKey, new IvParameterSpec(params.getIV()));
        byte[] enc = c.doFinal(in.getBytes("UTF-8"));
        byte[] hex = Hex.encode((byte[])enc);
        return new String(hex);
    }

    public static String pbeDecryptStringWithSha256Aes192(String in) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, UnsupportedEncodingException {
        CryptoProviderTools.installBCProviderIfNotAvailable();
        if (CryptoProviderTools.isUsingExportableCryptography()) {
            log.warn((Object)"De-obfuscation not possible due to weak crypto policy.");
            return in;
        }
        String algorithm = "PBEWithSHA256And192BitAES-CBC-BC";
        Cipher c = Cipher.getInstance("PBEWithSHA256And192BitAES-CBC-BC", "BC");
        PBEKeySpec keySpec = new PBEKeySpec(p, StringTools.getSalt(), 100);
        SecretKeyFactory fact = SecretKeyFactory.getInstance("PBEWithSHA256And192BitAES-CBC-BC", "BC");
        c.init(2, fact.generateSecret(keySpec));
        byte[] dec = c.doFinal(Hex.decode((byte[])in.getBytes("UTF-8")));
        return new String(dec);
    }

    public static String passwordDecryption(String in, String sDebug) {
        try {
            String tmp = StringTools.pbeDecryptStringWithSha256Aes192(in);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using encrypted " + sDebug));
            }
            return tmp;
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using cleartext " + sDebug));
            }
            return in;
        }
    }

    public static String incrementKeySequence(int keySequenceFormat, String oldSequence) {
        String inc;
        String countryCode;
        if (log.isTraceEnabled()) {
            log.trace((Object)(">incrementKeySequence: " + keySequenceFormat + ", " + oldSequence));
        }
        String ret = null;
        if (keySequenceFormat == 1) {
            ret = StringTools.incrementNumeric(oldSequence);
        } else if (keySequenceFormat == 2) {
            ret = StringTools.incrementAlphaNumeric(oldSequence);
        } else if (keySequenceFormat == 4) {
            countryCode = oldSequence.substring(0, Math.min(2, oldSequence.length()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("countryCode: " + countryCode));
            }
            inc = StringTools.incrementNumeric(oldSequence.substring(2));
            if (oldSequence.length() > 2 && inc != null) {
                ret = countryCode + inc;
            }
        } else if (keySequenceFormat == 8) {
            countryCode = oldSequence.substring(0, Math.min(2, oldSequence.length()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("countryCode: " + countryCode));
            }
            inc = StringTools.incrementAlphaNumeric(oldSequence.substring(2));
            if (oldSequence.length() > 2 && inc != null) {
                ret = countryCode + inc;
            }
        }
        if (ret == null) {
            char c;
            ret = oldSequence;
            StringBuilder buf = new StringBuilder();
            for (int i = oldSequence.length() - 1; i >= 0 && CharUtils.isAsciiNumeric((char)(c = oldSequence.charAt(i))); --i) {
                buf.insert(0, c);
            }
            int restlen = oldSequence.length() - buf.length();
            String rest = oldSequence.substring(0, restlen);
            String intStr = buf.toString();
            if (StringUtils.isNotEmpty((String)intStr)) {
                Integer seq = Integer.valueOf(intStr);
                seq = seq + 1;
                DecimalFormat df = new DecimalFormat("0000000000".substring(0, intStr.length()));
                String fseq = df.format(seq);
                ret = rest + fseq;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("<incrementKeySequence: " + ret));
                }
            } else {
                log.info((Object)("incrementKeySequence - Sequence does not contain any nummeric part: " + ret));
            }
        }
        return ret;
    }

    private static String incrementNumeric(String s) {
        if (!s.matches("[0-9]{1,5}")) {
            return null;
        }
        int len = s.length();
        int incrSeq = Integer.parseInt(s, 10) + 1;
        if ((double)incrSeq == Math.pow(10.0, len)) {
            incrSeq = 0;
        }
        String newSeq = "00000" + Integer.toString(incrSeq, 10);
        newSeq = newSeq.substring(newSeq.length() - len);
        return newSeq.toUpperCase(Locale.ENGLISH);
    }

    private static String incrementAlphaNumeric(String s) {
        if (!s.matches("[0-9A-Z]{1,5}")) {
            return null;
        }
        int len = s.length();
        int incrSeq = Integer.parseInt(s, 36) + 1;
        if ((double)incrSeq == Math.pow(36.0, len)) {
            incrSeq = 0;
        }
        String newSeq = "00000" + Integer.toString(incrSeq, 36);
        newSeq = newSeq.substring(newSeq.length() - len);
        return newSeq.toUpperCase(Locale.ENGLISH);
    }

    public static Collection<String> splitURIs(String dPoints) {
        String dispPoints = dPoints.trim();
        LinkedList<String> result = new LinkedList<String>();
        for (int i = 0; i < dispPoints.length(); ++i) {
            int nextQ = dispPoints.indexOf(34, i);
            if (nextQ == i) {
                nextQ = dispPoints.indexOf(34, i + 1);
                if (nextQ == -1) {
                    nextQ = dispPoints.length();
                }
                result.add(dispPoints.substring(i + 1, nextQ).trim());
                i = nextQ;
                continue;
            }
            int nextSep = dispPoints.indexOf(59, i);
            if (nextSep == i) continue;
            if (nextSep != -1) {
                result.add(dispPoints.substring(i, nextSep).trim());
                i = nextSep;
                continue;
            }
            if (i >= dispPoints.length()) continue;
            result.add(dispPoints.substring(i).trim());
            break;
        }
        return result;
    }

    public static String[] parseCertData(String certdata) {
        if (certdata == null) {
            return null;
        }
        String dnStrings = "(unstructuredName|dnQualifier|postalAddress|name|emailAddress|E|UID|OU|NIF|CIF|ST|SN|businessCategory|streetAddress|CN|postalCode|O|pseudonym|DC|surname|C|initials|serialNumber|L|givenName|telephoneNumber|title|DC)";
        String[] formats = new String[]{"(^[0-9A-Fa-f]+), ?(((unstructuredName|dnQualifier|postalAddress|name|emailAddress|E|UID|OU|NIF|CIF|ST|SN|businessCategory|streetAddress|CN|postalCode|O|pseudonym|DC|surname|C|initials|serialNumber|L|givenName|telephoneNumber|title|DC)=[^,]+,)*((unstructuredName|dnQualifier|postalAddress|name|emailAddress|E|UID|OU|NIF|CIF|ST|SN|businessCategory|streetAddress|CN|postalCode|O|pseudonym|DC|surname|C|initials|serialNumber|L|givenName|telephoneNumber|title|DC)=[^,]+)*)", "(^[0-9A-Fa-f]+) : DN : \"([^\"]*)\"( ?: SubjectDN : \"[^\"]*\")?"};
        String[] ret = null;
        for (int i = 0; i < formats.length; ++i) {
            Pattern p = Pattern.compile(formats[i]);
            Matcher m = p.matcher(certdata);
            if (!m.find()) continue;
            ret = new String[]{m.group(1), m.group(2)};
            break;
        }
        return ret;
    }

    public static String getCleanXForwardedFor(String rawHeaderValue) {
        if (rawHeaderValue == null) {
            return null;
        }
        return rawHeaderValue.trim().toLowerCase().replaceAll("[^0-9a-f.,: ]", "?");
    }

    static {
        try {
            VALID_IPV4_PATTERN = Pattern.compile(ipv4Pattern, 2);
            VALID_IPV6_PATTERN = Pattern.compile(ipv6Pattern, 2);
        }
        catch (PatternSyntaxException e) {
            log.error((Object)"Unable to compile IP address validation pattern", (Throwable)e);
        }
        stripXSS = new CharSet(new char[]{'<', '>'});
        stripSqlChars = new CharSet(new char[]{'\'', '\"', '\n', '\r', '\\', ';', '&', '|', '!', '\u0000', '%', '`', '<', '>', '?', '$', '~'});
        stripFilenameChars = new CharSet(new char[]{'\u0000', '\n', '\r', '/', '\\', '?', '%', '*', ':', ';', '|', '\"', '<', '>'});
        allowedEscapeChars = new CharSet(new char[]{',', '\"', '\\', '+', '<', '>', ';', '=', '#', ' '});
        WS = Pattern.compile("\\s+");
        p = StringTools.deobfuscate("OBF:1m0r1kmo1ioe1ia01j8z17y41l0q1abo1abm1abg1abe1kyc17ya1j631i5y1ik01kjy1lxf").toCharArray();
    }

    private static class CharSet {
        private final Set<Character> charSet;

        CharSet(char[] array) {
            HashSet<Character> set = new HashSet<Character>();
            for (char c : array) {
                set.add(Character.valueOf(c));
            }
            this.charSet = set;
        }

        boolean contains(char c) {
            return this.charSet.contains(Character.valueOf(c));
        }

        static CharSet getForbidden() {
            return new CharSet(CesecoreConfiguration.getForbiddenCharacters());
        }
    }
}

