/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnitParser {
    private static final Pattern valuePattern = Pattern.compile("(\\d+)");
    private static final Pattern typePattern = Pattern.compile("(\\D+)");
    private Pattern pattern;
    private Map<String, Long> defaultValues;

    public UnitParser(List<String> units) {
        this.defaultValues = new LinkedHashMap<String, Long>(units.size());
        StringBuilder sb = new StringBuilder();
        sb.append("^");
        Iterator<String> i$ = units.iterator();
        while (i$.hasNext()) {
            String o;
            String unit = o = i$.next();
            this.defaultValues.put(unit.toLowerCase(), 0L);
            sb.append("(\\d+");
            for (char c : unit.toCharArray()) {
                sb.append("[");
                sb.append(Character.toLowerCase(c));
                sb.append(Character.toUpperCase(c));
                sb.append("]");
            }
            sb.append(")?");
        }
        sb.append("$");
        this.pattern = Pattern.compile(sb.toString());
    }

    public Map<String, Long> parse(String time) throws NumberFormatException {
        LinkedHashMap<String, Long> values = new LinkedHashMap<String, Long>(this.defaultValues);
        if (time == null) {
            throw new NullPointerException("Time is null.");
        }
        if ((time = time.replaceAll("\\s", "")).length() == 0) {
            throw new IllegalArgumentException("Time is empty.");
        }
        Matcher matcher = this.pattern.matcher(time);
        if (!matcher.find()) {
            throw new NumberFormatException("Not a match.");
        }
        for (int i = 0; i < matcher.groupCount(); ++i) {
            String match = matcher.group(i + 1);
            if (match == null) continue;
            Matcher valueMatcher = valuePattern.matcher(match);
            Matcher typeMatcher = typePattern.matcher(match);
            if (!valueMatcher.find() || !typeMatcher.find()) {
                throw new NumberFormatException("Not a match.");
            }
            long value = Long.parseLong(valueMatcher.group(1));
            String type = typeMatcher.group(1).toLowerCase();
            values.put(type, value);
        }
        return values;
    }

    public String toString(Map<String, Long> values, String zeroType) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Long> o : values.entrySet()) {
            Map.Entry<String, Long> entry = o;
            if (entry.getValue() == 0L) continue;
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(entry.getValue());
            sb.append(entry.getKey());
        }
        if (sb.length() == 0) {
            sb.append("0");
            sb.append(zeroType);
        }
        return sb.toString();
    }
}

