/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.cesecore.util.YearMonthDayTime;

public class ValidityDate {
    public static final String ISO8601_DATE_FORMAT = "yyyy-MM-dd HH:mm:ssZZ";
    public static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    public static final TimeZone TIMEZONE_SERVER = TimeZone.getDefault();
    private static final Logger log = Logger.getLogger(ValidityDate.class);
    private static final String[] IMPLIED_UTC_PATTERN = new String[]{"yyyy-MM-dd HH:mm"};
    private static final String[] IMPLIED_UTC_PATTERN_TZ = new String[]{"yyyy-MM-dd HH:mmZZ"};
    private static final String[] ISO8601_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ssZZ", "yyyy-MM-dd HH:mmZZ", "yyyy-MM-ddZZ"};

    private ValidityDate() {
    }

    public static Date parseAsUTC(String dateString) throws ParseException {
        return DateUtils.parseDateStrictly((String)(dateString + "+00:00"), (String[])IMPLIED_UTC_PATTERN_TZ);
    }

    public static Date parseAsIso8601(String dateString) throws ParseException {
        try {
            return DateUtils.parseDateStrictly((String)dateString, (String[])ISO8601_PATTERNS);
        }
        catch (ParseException e) {
            return DateUtils.parseDateStrictly((String)(dateString + "+00:00"), (String[])ISO8601_PATTERNS);
        }
    }

    public static String formatAsUTC(Date date) {
        return FastDateFormat.getInstance((String)IMPLIED_UTC_PATTERN[0], (TimeZone)TIMEZONE_UTC).format(date);
    }

    public static String formatAsUTC(long millis) {
        return FastDateFormat.getInstance((String)IMPLIED_UTC_PATTERN[0], (TimeZone)TIMEZONE_UTC).format(millis);
    }

    public static String formatAsISO8601(Date date, TimeZone timeZone) {
        return FastDateFormat.getInstance((String)ISO8601_PATTERNS[0], (TimeZone)timeZone).format(date);
    }

    public static String formatAsISO8601ServerTZ(long millis, TimeZone timeZone) {
        return FastDateFormat.getInstance((String)ISO8601_PATTERNS[0], (TimeZone)TIMEZONE_SERVER).format(millis);
    }

    public static String getImpliedUTCFromISO8601(String dateString) throws ParseException {
        return ValidityDate.formatAsUTC(ValidityDate.parseAsIso8601(dateString));
    }

    public static String getISO8601FromImpliedUTC(String dateString, TimeZone timeZone) throws ParseException {
        return ValidityDate.formatAsISO8601(ValidityDate.parseAsUTC(dateString), timeZone);
    }

    public static long encode(String sValidity) {
        long returnValue;
        block6: {
            returnValue = -1L;
            YearMonthDayTime yearMonthDayTime = YearMonthDayTime.getInstance(sValidity);
            if (yearMonthDayTime != null) {
                long days = yearMonthDayTime.daysFrom(new Date());
                if (ValidityDate.isDeltaTime(days)) {
                    returnValue = days;
                } else {
                    returnValue = 0x7FFFFFFEL;
                    log.info((Object)(sValidity + " was parsed as a relative time, but is too far in the future. Limiting to " + returnValue + " days."));
                }
            } else {
                try {
                    returnValue = ValidityDate.parseAsIso8601(sValidity).getTime();
                }
                catch (ParseException e) {
                    if (!log.isDebugEnabled()) break block6;
                    Date exampleDate = new Date();
                    log.debug((Object)("Not possible to decode the date '" + sValidity + "'. Example: The date '" + exampleDate + "' should be encoded as '" + ValidityDate.formatAsUTC(exampleDate) + "'"));
                }
            }
        }
        return returnValue;
    }

    public static String getString(long lEncoded) {
        if (ValidityDate.isDeltaTime(lEncoded)) {
            return "" + lEncoded + "d";
        }
        return ValidityDate.formatAsISO8601ServerTZ(lEncoded, TIMEZONE_SERVER);
    }

    public static Date getDate(long lEncoded, Date firstDate) {
        if (ValidityDate.isDeltaTime(lEncoded)) {
            return new Date(firstDate.getTime() + lEncoded * 24L * 60L * 60L * 1000L);
        }
        return new Date(lEncoded);
    }

    private static boolean isDeltaTime(long lEncoded) {
        return lEncoded < Integer.MAX_VALUE;
    }

    public static Date parseCaLatestValidDateTime(String sDate) {
        Date tooLateExpireDate;
        block8: {
            tooLateExpireDate = null;
            if (sDate.length() > 0) {
                try {
                    return ValidityDate.parseAsIso8601(sDate);
                }
                catch (ParseException e) {
                    log.debug((Object)("tooLateExpireDate could not be parsed as an ISO8601 date: " + e.getMessage()));
                    if (tooLateExpireDate != null) break block8;
                    try {
                        tooLateExpireDate = new Date(Long.parseLong(sDate, 16) * 1000L);
                    }
                    catch (NumberFormatException e2) {
                        log.debug((Object)("tooLateExpireDate could not be parsed as a hex value: " + e2.getMessage()));
                    }
                }
            }
        }
        if (tooLateExpireDate == null) {
            log.debug((Object)"Using default value for ca.toolateexpiredate.");
            tooLateExpireDate = new Date(Long.MAX_VALUE);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("tooLateExpireData is set to: " + tooLateExpireDate));
        }
        return tooLateExpireDate;
    }
}

