/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.log4j.Logger;

public abstract class ValueExtractor {
    private static final Logger LOG = Logger.getLogger(ValueExtractor.class);

    public static int extractIntValue(Object object) {
        try {
            Object o = ValueExtractor.getObject(object, Integer.class);
            Class<?> c = o.getClass();
            return (Integer)c.getMethod("intValue", new Class[0]).invoke(o, new Object[0]);
        }
        catch (Exception e) {
            Class<?> c = object.getClass();
            LOG.error((Object)(c.getName() + ", isPrimitive=" + c.isPrimitive()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static long extractLongValue(Object object) {
        try {
            Object o = ValueExtractor.getObject(object, Long.class);
            Class<?> c = o.getClass();
            return (Long)c.getMethod("longValue", new Class[0]).invoke(o, new Object[0]);
        }
        catch (Exception e) {
            Class<?> c = object.getClass();
            LOG.error((Object)(c.getName() + ", isPrimitive=" + c.isPrimitive()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Object getObject(Object object, Class<?> clazz) {
        Object ret = object;
        Class<?> c = object.getClass();
        if (c.isArray()) {
            Object[] objects = (Object[])object;
            if (LOG.isTraceEnabled()) {
                for (Object o : objects) {
                    LOG.trace((Object)(o.getClass().getName() + " isPrimitive=" + o.getClass().isPrimitive() + " toString=" + o.toString()));
                }
            }
            if (objects[0].getClass().equals(BigInteger.class)) {
                ret = objects[objects.length - 1];
            } else if (objects[objects.length - 1].getClass().equals(BigDecimal.class)) {
                ret = objects[0];
            } else if (objects[0].getClass().equals(Integer.class)) {
                ret = objects[0];
            } else {
                if (objects.length > 1) {
                    throw new RuntimeException("Unsupported object type to convert to " + clazz.getSimpleName() + ". Was: objects.length=" + objects.length + ", objects[0] is a " + objects[0].getClass().getName() + ": " + objects[0] + ", objects[1] is a " + objects[1].getClass().getName() + ": " + objects[1]);
                }
                throw new RuntimeException("Unsupported object type to convert to " + clazz.getSimpleName() + ". Was: objects.length=" + objects.length + ", objects[0] is a " + objects[0].getClass().getName() + ": " + objects[0]);
            }
        }
        return ret;
    }
}

