/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cesecore.util.UnitParser;

public class YearMonthDayTime {
    public static final String TYPE_YEARS = "y";
    public static final String TYPE_MONTHS = "mo";
    public static final String TYPE_DAYS = "d";
    private static final UnitParser unitParser = new UnitParser(Arrays.asList("y", "mo", "d"));
    private static final Logger log = Logger.getLogger(YearMonthDayTime.class);
    private Map<String, Long> values;

    private YearMonthDayTime(String time) throws NumberFormatException {
        this.values = unitParser.parse(time);
    }

    private YearMonthDayTime(String time, String defaultTime) throws NumberFormatException {
        if (time == null || time.trim().length() == 0) {
            time = defaultTime;
        }
        this.values = unitParser.parse(time);
    }

    public static YearMonthDayTime getInstance(String time) {
        YearMonthDayTime simpleTime = null;
        try {
            simpleTime = new YearMonthDayTime(time);
        }
        catch (Exception e) {
            log.info((Object)("Failed to parse time \"" + time + "\". " + e.getMessage()));
        }
        return simpleTime;
    }

    public static YearMonthDayTime getInstance(String time, String defaultTime) {
        YearMonthDayTime simpleTime = null;
        try {
            simpleTime = new YearMonthDayTime(time, defaultTime);
        }
        catch (Exception e) {
            log.info((Object)("Failed to parse time or defaultTime \"" + time + "\", \"" + defaultTime + "\". " + e.getMessage()));
        }
        return simpleTime;
    }

    public long getYears() {
        return this.values.get(TYPE_YEARS);
    }

    public long getMonths() {
        return this.values.get(TYPE_MONTHS);
    }

    public long getDays() {
        return this.values.get(TYPE_DAYS);
    }

    public long daysFrom(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 12);
        cal.set(13, 0);
        cal.set(14, 0);
        long fromTime = cal.getTimeInMillis();
        cal.add(1, (int)this.getYears());
        cal.add(2, (int)this.getMonths());
        cal.add(5, (int)this.getDays());
        double diff = (double)(cal.getTimeInMillis() - fromTime) / 8.64E7;
        long result = Math.round(diff);
        return result;
    }

    public String toString() {
        return this.toString(TYPE_DAYS);
    }

    public String toString(String zeroType) {
        return unitParser.toString(this.values, zeroType);
    }
}

