/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util.log;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.cesecore.util.log.SaferAppenderListener;

public class SaferDailyRollingFileAppender
extends DailyRollingFileAppender {
    private static SaferAppenderListener subscriber;

    public void append(LoggingEvent evt) {
        block5: {
            super.append(evt);
            try {
                File logfile = new File(super.getFile());
                if (subscriber != null && logfile != null) {
                    if (logfile.canWrite()) {
                        subscriber.setCanlog(true);
                    } else {
                        subscriber.setCanlog(false);
                    }
                }
            }
            catch (Exception e) {
                if (subscriber == null) break block5;
                subscriber.setCanlog(false);
            }
        }
    }

    public static void addSubscriber(SaferAppenderListener pSubscriber) {
        subscriber = pSubscriber;
    }

    public void setFile(String filename) {
        this.constructPath(filename);
        super.setFile(filename);
    }

    private void constructPath(String filename) {
        boolean success;
        File dir;
        try {
            URL url = new URL(filename.trim());
            dir = new File(url.getFile()).getParentFile();
        }
        catch (MalformedURLException e) {
            dir = new File(filename.trim()).getParentFile();
        }
        if (!dir.exists() && !(success = dir.mkdirs())) {
            LogLog.error((String)("Failed to create directory structure: " + dir));
        }
    }
}

