/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util.provider;

import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.x509.Extension;
import org.cesecore.util.CertTools;

public class EkuPKIXCertPathChecker
extends PKIXCertPathChecker {
    private static final Logger log = Logger.getLogger(EkuPKIXCertPathChecker.class);
    private static final List<String> EMPTY = new ArrayList<String>(0);
    private final List<String> requiredKeyPurposeOids;

    public EkuPKIXCertPathChecker(String ... requiredKeyPurposeOids) {
        this.requiredKeyPurposeOids = requiredKeyPurposeOids == null ? EMPTY : Arrays.asList(requiredKeyPurposeOids);
    }

    public EkuPKIXCertPathChecker(List<String> requiredKeyPurposeOids) {
        this.requiredKeyPurposeOids = requiredKeyPurposeOids == null ? EMPTY : requiredKeyPurposeOids;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        if (!CertTools.isCA(cert) && cert instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)cert;
            try {
                List<String> ekus = x509Certificate.getExtendedKeyUsage();
                if (ekus == null) {
                    ekus = EMPTY;
                }
                if (!ekus.containsAll(this.requiredKeyPurposeOids)) {
                    ArrayList<String> ekusMissing = new ArrayList<String>(this.requiredKeyPurposeOids);
                    ekusMissing.removeAll(ekus);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("EKUs in certificate: " + Arrays.toString(ekus.toArray()) + " EKUs required: " + Arrays.toString(this.requiredKeyPurposeOids.toArray())));
                    }
                    log.info((Object)("Validation of certificate with subject " + CertTools.getSubjectDN(cert) + " failed critical EKU validation. The missing EKUs were: " + Arrays.toString(ekusMissing.toArray())));
                    return;
                }
                unresolvedCritExts.remove(Extension.extendedKeyUsage.getId());
            }
            catch (CertificateParsingException e) {
                throw new CertPathValidatorException(e);
            }
        }
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.singleton(Extension.extendedKeyUsage.getId());
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return true;
    }
}

