/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;
import org.cesecore.util.provider.X509TrustManagerAcceptAll;

abstract class TrustManagerFactoryImpl
extends TrustManagerFactorySpi {
    private X509TrustManager trustManager = null;
    private boolean isInitialized = false;

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        if (!this.isInitialized) {
            throw new IllegalStateException("TrustManagerFactoryImpl is not initialized");
        }
        return new TrustManager[]{this.trustManager};
    }

    @Override
    protected void engineInit(KeyStore ks) throws KeyStoreException {
        this.trustManager = this.getInstance(ks);
        this.isInitialized = true;
    }

    @Override
    protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        this.trustManager = this.getInstance(spec);
        this.isInitialized = true;
    }

    abstract X509TrustManager getInstance(KeyStore var1) throws KeyStoreException;

    abstract X509TrustManager getInstance(ManagerFactoryParameters var1) throws InvalidAlgorithmParameterException;

    public static final class AcceptAll
    extends TrustManagerFactoryImpl {
        @Override
        X509TrustManager getInstance(KeyStore ks) throws KeyStoreException {
            return new X509TrustManagerAcceptAll();
        }

        @Override
        X509TrustManager getInstance(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
            return new X509TrustManagerAcceptAll();
        }
    }
}

