/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util.query;

import java.io.Serializable;
import java.util.AbstractMap;
import org.cesecore.util.query.Elem;
import org.cesecore.util.query.clauses.Order;
import org.cesecore.util.query.elems.LogicOperator;
import org.cesecore.util.query.elems.Operation;
import org.cesecore.util.query.elems.RelationalOperator;
import org.cesecore.util.query.elems.Term;

public class Criteria
implements Serializable {
    private static final long serialVersionUID = 3186042047323993627L;

    public static Elem eq(String name, Object value) {
        return new Term(RelationalOperator.EQ, name, value);
    }

    public static Elem neq(String name, Object value) {
        return new Term(RelationalOperator.NEQ, name, value);
    }

    public static Elem geq(String name, Object value) {
        return new Term(RelationalOperator.GE, name, value);
    }

    public static Elem grt(String name, Object value) {
        return new Term(RelationalOperator.GT, name, value);
    }

    public static Elem leq(String name, Object value) {
        return new Term(RelationalOperator.LE, name, value);
    }

    public static Elem lsr(String name, Object value) {
        return new Term(RelationalOperator.LT, name, value);
    }

    public static Elem between(String name, Object after, Object before) {
        return new Term(RelationalOperator.BETWEEN, name, new AbstractMap.SimpleEntry<Object, Object>(after, before));
    }

    public static Elem like(String name, Object value) {
        return new Term(RelationalOperator.LIKE, name, value);
    }

    public static Elem isNull(String name) {
        return new Term(RelationalOperator.NULL, name, null);
    }

    public static Elem isNotNull(String name) {
        return new Term(RelationalOperator.NOTNULL, name, null);
    }

    public static Elem and(Elem first, Elem second) {
        return new Operation(LogicOperator.AND, (Term)first, second);
    }

    public static Elem or(Elem first, Elem second) {
        return new Operation(LogicOperator.OR, (Term)first, second);
    }

    public static Elem orderAsc(String name) {
        return new Order(name, Order.Value.ASC);
    }

    public static Elem orderDesc(String name) {
        return new Order(name, Order.Value.DESC);
    }
}

