/*
 * Decompiled with CFR 0.152.
 */
package org.cesecore.util.query;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.lang.StringUtils;
import org.cesecore.util.QueryParameterException;
import org.cesecore.util.query.Elem;
import org.cesecore.util.query.QueryCriteria;
import org.cesecore.util.query.clauses.Order;
import org.cesecore.util.query.elems.LogicOperator;
import org.cesecore.util.query.elems.Operation;
import org.cesecore.util.query.elems.RelationalOperator;
import org.cesecore.util.query.elems.Term;

public final class QueryGenerator
implements Serializable {
    private static final long serialVersionUID = 1567027442267416376L;
    private final Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    private final Query query;
    private final List<String> availableFields = new ArrayList<String>();
    private final QueryCriteria criteria;

    private QueryGenerator(Class<?> clazz, QueryCriteria criteria, String alias) {
        this.query = new Query(alias);
        this.criteria = criteria;
        for (Field f : clazz.getDeclaredFields()) {
            this.availableFields.add(f.getName());
        }
    }

    public static QueryGenerator generator(Class<?> clazz, QueryCriteria criteria, String attrAlias) {
        if (criteria == null) {
            return null;
        }
        return new QueryGenerator(clazz, criteria, attrAlias);
    }

    public String generate() {
        if (this.query.isEmpty()) {
            List<Elem> elements = this.criteria.getElements();
            ArrayList<Elem> terms = new ArrayList<Elem>();
            ArrayList<Elem> clauses = new ArrayList<Elem>();
            CollectionUtils.selectRejected(elements, (Predicate)PredicateUtils.instanceofPredicate(Order.class), terms);
            CollectionUtils.select(elements, (Predicate)PredicateUtils.instanceofPredicate(Order.class), clauses);
            if (terms.size() > 0) {
                this.query.where();
            }
            this.termTraversal(terms);
            this.clauseTraversal(clauses);
        }
        return this.query.toString();
    }

    private void termTraversal(List<Elem> elements) {
        boolean first = true;
        for (Elem element : elements) {
            if (!first) {
                this.query.operator(LogicOperator.AND);
            } else {
                first = false;
            }
            this.generate(element);
        }
    }

    private void clauseTraversal(List<Elem> clauses) {
        for (Elem clause : clauses) {
            this.generate(clause);
        }
    }

    private void generate(Elem elem) {
        if (elem instanceof Operation) {
            this.generateRestriction((Operation)elem);
        } else if (elem instanceof Term) {
            this.generateRestriction((Term)elem);
        } else if (elem instanceof Order) {
            this.generateRestriction((Order)elem);
        } else {
            throw new QueryParameterException("No matched restriction");
        }
    }

    private void generateRestriction(Operation op) {
        this.generateRestriction(op.getTerm());
        this.query.operator(op.getOperator());
        Elem elem = op.getElement();
        if (elem != null) {
            this.generate(elem);
        }
    }

    private void generateRestriction(Term term) {
        this.validate(term.getName());
        this.query.attribute(term.getName()).operator(term.getOperator());
        if (term.getOperator() == RelationalOperator.BETWEEN) {
            AbstractMap.SimpleEntry values = (AbstractMap.SimpleEntry)term.getValue();
            this.query.parameter(this.genAndStoreParameter(term.getName(), values.getKey())).operator(LogicOperator.AND).parameter(this.genAndStoreParameter(term.getName(), values.getValue()));
        } else if (term.getOperator() != RelationalOperator.NULL && term.getOperator() != RelationalOperator.NOTNULL) {
            this.query.parameter(this.genAndStoreParameter(term.getName(), term.getValue()));
        }
    }

    private void generateRestriction(Order order) {
        this.validate(order.getName());
        this.query.order(order.getName(), order.getOrder());
    }

    public Set<String> getParameterKeys() {
        return this.parameters.keySet();
    }

    public Object getParameterValue(String key) {
        return this.parameters.get(key);
    }

    private void validate(String name) {
        if (!StringUtils.isAlphanumeric((String)name)) {
            throw new QueryParameterException("parameter is not alphanumeric " + name);
        }
        if (!this.availableFields.contains(name)) {
            throw new QueryParameterException("parameter is not valid field" + name);
        }
    }

    private String genAndStoreParameter(String name, Object value) {
        String parameter;
        int i = 0;
        while (this.parameters.containsKey(parameter = name + i++)) {
        }
        this.parameters.put(parameter, value);
        return parameter;
    }

    private final class Query {
        public final StringBuilder query = new StringBuilder();
        private final String attrAlias;
        private static final String WHERE = "WHERE";
        private static final String SEPARATOR = " ";

        public Query(String attrAlias) {
            this.attrAlias = attrAlias;
        }

        public Query where() {
            this.query.append(SEPARATOR).append(WHERE);
            return this;
        }

        public Query attribute(String name) {
            this.query.append(SEPARATOR).append(this.attrAlias).append(".").append(name);
            return this;
        }

        public Query parameter(String name) {
            this.query.append(SEPARATOR).append(":" + name);
            return this;
        }

        private Query operator(RelationalOperator op) {
            String operator;
            String string = op == RelationalOperator.EQ ? "=" : (op == RelationalOperator.GE ? ">=" : (op == RelationalOperator.GT ? ">" : (op == RelationalOperator.LE ? "<=" : (op == RelationalOperator.LT ? "<" : (op == RelationalOperator.NEQ ? "!=" : (op == RelationalOperator.BETWEEN ? "BETWEEN" : (op == RelationalOperator.LIKE ? "LIKE" : (op == RelationalOperator.NULL ? "IS NULL" : (operator = op == RelationalOperator.NOTNULL ? "IS NOT NULL" : "")))))))));
            if (operator.isEmpty()) {
                throw new QueryParameterException("operator not recognized");
            }
            this.query.append(SEPARATOR).append(operator);
            return this;
        }

        private Query operator(LogicOperator op) {
            this.query.append(SEPARATOR).append(op.toString());
            return this;
        }

        public Query order(String name, Order.Value order) {
            this.query.append(SEPARATOR).append("ORDER BY").append(SEPARATOR).append(this.attrAlias).append(".").append(name).append(SEPARATOR).append(order.toString());
            return this;
        }

        public boolean isEmpty() {
            return this.query.length() == 0;
        }

        public String toString() {
            return this.query.toString();
        }
    }
}

