/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.index.reindex.AbstractAsyncBulkByScrollAction;
import org.elasticsearch.index.reindex.AbstractBulkIndexByScrollRequest;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class AbstractAsyncBulkIndexByScrollAction<Request extends AbstractBulkIndexByScrollRequest<Request>, Response extends BulkIndexByScrollResponse>
extends AbstractAsyncBulkByScrollAction<Request, Response> {
    private final ScriptService scriptService;
    private final CompiledScript script;

    public AbstractAsyncBulkIndexByScrollAction(BulkByScrollTask task, ESLogger logger, ScriptService scriptService, Client client, ThreadPool threadPool, Version smallestNonClientVersion, Request mainRequest, SearchRequest firstSearchRequest, ActionListener<Response> listener) {
        super(task, logger, client, threadPool, smallestNonClientVersion, mainRequest, firstSearchRequest, listener);
        this.scriptService = scriptService;
        this.script = ((AbstractBulkIndexByScrollRequest)((Object)mainRequest)).getScript() == null ? null : scriptService.compile(((AbstractBulkIndexByScrollRequest)((Object)mainRequest)).getScript(), (ScriptContext)ScriptContext.Standard.UPDATE, mainRequest, Collections.emptyMap());
    }

    protected abstract IndexRequest buildIndexRequest(SearchHit var1);

    @Override
    protected BulkRequest buildBulk(Iterable<SearchHit> docs) {
        BulkRequest bulkRequest = new BulkRequest((ActionRequest)this.mainRequest);
        ExecutableScript executableScript = null;
        HashMap scriptCtx = null;
        for (SearchHit doc : docs) {
            IndexRequest index = this.buildIndexRequest(doc);
            this.copyMetadata(index, doc);
            if (this.script != null) {
                if (executableScript == null) {
                    executableScript = this.scriptService.executable(this.script, ((AbstractBulkIndexByScrollRequest)this.mainRequest).getScript().getParams());
                    scriptCtx = new HashMap();
                }
                if (!this.applyScript(index, doc, executableScript, scriptCtx)) continue;
            }
            bulkRequest.add(index);
        }
        return bulkRequest;
    }

    protected void copyMetadata(IndexRequest index, SearchHit doc) {
        Long ttl;
        index.parent((String)this.fieldValue(doc, "_parent"));
        this.copyRouting(index, doc);
        Long timestamp = (Long)this.fieldValue(doc, "_timestamp");
        if (timestamp != null) {
            index.timestamp(timestamp.toString());
        }
        if ((ttl = (Long)this.fieldValue(doc, "_ttl")) != null) {
            index.ttl(ttl.longValue());
        }
    }

    protected void copyRouting(IndexRequest index, SearchHit doc) {
        index.routing((String)this.fieldValue(doc, "_routing"));
    }

    protected <T> T fieldValue(SearchHit doc, String fieldName) {
        SearchHitField field = doc.field(fieldName);
        return (T)(field == null ? null : field.value());
    }

    protected boolean applyScript(IndexRequest index, SearchHit doc, ExecutableScript script, Map<String, Object> ctx) {
        if (script == null) {
            return true;
        }
        ctx.put("_index", doc.index());
        ctx.put("_type", doc.type());
        ctx.put("_id", doc.id());
        Long oldVersion = doc.getVersion();
        ctx.put("_version", oldVersion);
        String oldParent = (String)this.fieldValue(doc, "_parent");
        ctx.put("_parent", oldParent);
        String oldRouting = (String)this.fieldValue(doc, "_routing");
        ctx.put("_routing", oldRouting);
        Long oldTimestamp = (Long)this.fieldValue(doc, "_timestamp");
        ctx.put("_timestamp", oldTimestamp);
        Long oldTTL = (Long)this.fieldValue(doc, "_ttl");
        ctx.put("_ttl", oldTTL);
        ctx.put("_source", index.sourceAsMap());
        ctx.put("op", "update");
        script.setNextVar("ctx", ctx);
        script.run();
        Map resultCtx = (Map)script.unwrap(ctx);
        String newOp = (String)resultCtx.remove("op");
        if (newOp == null) {
            throw new IllegalArgumentException("Script cleared op!");
        }
        if ("noop".equals(newOp)) {
            this.task.countNoop();
            return false;
        }
        if (!"update".equals(newOp)) {
            throw new IllegalArgumentException("Invalid op [" + newOp + ']');
        }
        index.source((Map)resultCtx.remove("_source"));
        Object newValue = resultCtx.remove("_index");
        if (!doc.index().equals(newValue)) {
            this.scriptChangedIndex(index, newValue);
        }
        newValue = resultCtx.remove("_type");
        if (!doc.type().equals(newValue)) {
            this.scriptChangedType(index, newValue);
        }
        newValue = resultCtx.remove("_id");
        if (!doc.id().equals(newValue)) {
            this.scriptChangedId(index, newValue);
        }
        if (!Objects.equals(oldVersion, newValue = resultCtx.remove("_version"))) {
            this.scriptChangedVersion(index, newValue);
        }
        if (!Objects.equals(oldParent, newValue = resultCtx.remove("_parent"))) {
            this.scriptChangedParent(index, newValue);
        }
        if (!Objects.equals(oldRouting, newValue = resultCtx.remove("_routing"))) {
            this.scriptChangedRouting(index, newValue);
        }
        if (!Objects.equals(oldTimestamp, newValue = resultCtx.remove("_timestamp"))) {
            this.scriptChangedTimestamp(index, newValue);
        }
        if (!Objects.equals(oldTTL, newValue = resultCtx.remove("_ttl"))) {
            this.scriptChangedTTL(index, newValue);
        }
        if (!resultCtx.isEmpty()) {
            StringBuilder msg = new StringBuilder("Invalid fields added to ctx [");
            boolean first = true;
            for (String key : resultCtx.keySet()) {
                if (first) {
                    first = false;
                } else {
                    msg.append(',');
                }
                msg.append(key);
            }
            msg.append(']');
            throw new IllegalArgumentException(msg.toString());
        }
        return true;
    }

    protected abstract void scriptChangedIndex(IndexRequest var1, Object var2);

    protected abstract void scriptChangedType(IndexRequest var1, Object var2);

    protected abstract void scriptChangedId(IndexRequest var1, Object var2);

    protected abstract void scriptChangedVersion(IndexRequest var1, Object var2);

    protected abstract void scriptChangedRouting(IndexRequest var1, Object var2);

    protected abstract void scriptChangedParent(IndexRequest var1, Object var2);

    protected abstract void scriptChangedTimestamp(IndexRequest var1, Object var2);

    protected abstract void scriptChangedTTL(IndexRequest var1, Object var2);
}

