/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.hadoop.util.StringUtils;

class ErrorUtils {
    private static final Pattern XCONTENT_PAYLOAD = Pattern.compile("Elastic[s|S]earchParseException.+: \\[(.+)\\]]");
    private static final Pattern OFFSET = Pattern.compile("offset=(\\d+)");
    private static final Pattern LENGTH = Pattern.compile("length=(\\d+)");

    ErrorUtils() {
    }

    static String extractInvalidXContent(String errorMessage) {
        if (!StringUtils.hasText(errorMessage)) {
            return null;
        }
        String group = ErrorUtils.findMatch(XCONTENT_PAYLOAD.matcher(errorMessage));
        if (!StringUtils.hasText(group)) {
            return null;
        }
        String match = ErrorUtils.findMatch(OFFSET.matcher(errorMessage));
        int offset = StringUtils.hasText(match) ? Integer.valueOf(match) : 0;
        match = ErrorUtils.findMatch(LENGTH.matcher(errorMessage));
        int length = StringUtils.hasText(match) ? Integer.valueOf(match) : 0;
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        try {
            for (String byteValue : StringUtils.tokenize(group, ",")) {
                bytes.add(Byte.parseByte(byteValue));
            }
            if (length == 0) {
                length = bytes.size();
            }
            byte[] primitives = new byte[length];
            for (int index = 0; index < length; ++index) {
                primitives[index] = (Byte)bytes.get(index + offset);
            }
            return new String(primitives);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String findMatch(Matcher matcher) {
        return matcher.find() ? matcher.group(1) : null;
    }
}

