/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.builder;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.Parser;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.serialization.builder.ValueReader;
import org.elasticsearch.hadoop.util.StringUtils;

public class JdkValueReader
implements SettingsAware,
ValueReader {
    private boolean emptyAsNull = true;

    @Override
    public Object readValue(Parser parser, String value, FieldType esType) {
        if (esType == null) {
            return null;
        }
        switch (esType) {
            case NULL: {
                return this.nullValue();
            }
            case STRING: {
                return this.textValue(value);
            }
            case BYTE: {
                return this.byteValue(value);
            }
            case SHORT: {
                return this.shortValue(value);
            }
            case INTEGER: {
                return this.intValue(value);
            }
            case TOKEN_COUNT: 
            case LONG: {
                return this.longValue(value);
            }
            case FLOAT: {
                return this.floatValue(value);
            }
            case DOUBLE: {
                return this.doubleValue(value);
            }
            case BOOLEAN: {
                return this.booleanValue(value);
            }
            case BINARY: {
                return this.binaryValue(parser.binaryValue());
            }
            case DATE: {
                return this.date(value);
            }
        }
        return this.textValue(value);
    }

    @Override
    public Map createMap() {
        return new LinkedHashMap();
    }

    @Override
    public void addToMap(Object map, Object key, Object value) {
        ((Map)map).put(key, value != null ? value : this.nullValue());
    }

    @Override
    public Object createArray(FieldType type) {
        return Collections.emptyList();
    }

    @Override
    public Object addToArray(Object array, List<Object> value) {
        return value;
    }

    protected Object binaryValue(byte[] value) {
        return value;
    }

    protected Object booleanValue(String value) {
        return value != null ? (this.isEmpty(value) ? this.nullValue() : this.parseBoolean(value)) : this.nullValue();
    }

    private boolean isEmpty(String value) {
        return value.length() == 0 && this.emptyAsNull;
    }

    protected Object parseBoolean(String value) {
        return Boolean.parseBoolean(value);
    }

    protected Object doubleValue(String value) {
        return value != null ? (this.isEmpty(value) ? this.nullValue() : this.parseDouble(value)) : this.nullValue();
    }

    protected Object parseDouble(String value) {
        return Double.parseDouble(value);
    }

    protected Object floatValue(String value) {
        return value != null ? (this.isEmpty(value) ? this.nullValue() : this.parseFloat(value)) : this.nullValue();
    }

    protected Object parseFloat(String value) {
        return Float.valueOf(Float.parseFloat(value));
    }

    protected Object longValue(String value) {
        return value != null ? (this.isEmpty(value) ? this.nullValue() : this.parseLong(value)) : this.nullValue();
    }

    protected Object parseLong(String value) {
        return Long.parseLong(value);
    }

    protected Object intValue(String value) {
        return value != null ? (this.isEmpty(value) ? this.nullValue() : this.parseInteger(value)) : this.nullValue();
    }

    protected Object parseInteger(String value) {
        return Integer.parseInt(value);
    }

    protected Object byteValue(String value) {
        return value != null ? (this.isEmpty(value) ? this.nullValue() : this.parseByte(value)) : this.nullValue();
    }

    protected Object parseByte(String value) {
        return Byte.parseByte(value);
    }

    protected Object shortValue(String value) {
        return value != null ? (this.isEmpty(value) ? this.nullValue() : this.parseShort(value)) : this.nullValue();
    }

    protected Object parseShort(String value) {
        return Short.parseShort(value);
    }

    protected Object textValue(String value) {
        return value != null ? (!StringUtils.hasText(value) && this.emptyAsNull ? this.nullValue() : this.parseString(value)) : this.nullValue();
    }

    protected Object parseString(String value) {
        return value;
    }

    protected Object nullValue() {
        return null;
    }

    protected Object date(String value) {
        return value != null ? (this.isEmpty(value) ? this.nullValue() : this.parseDate(value)) : this.nullValue();
    }

    protected Object parseDate(String value) {
        return this.parseString(value);
    }

    @Override
    public void setSettings(Settings settings) {
        this.emptyAsNull = settings.getFieldReadEmptyAsNull();
    }
}

