/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.serialization.field.IndexExtractor;
import org.elasticsearch.hadoop.serialization.field.IndexFormatter;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class AbstractIndexExtractor
implements IndexExtractor,
SettingsAware {
    protected Settings settings;
    protected String pattern;
    protected boolean hasPattern = false;
    protected List<Object> index;
    protected List<Object> type;

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    public void compile(String pattern) {
        this.pattern = pattern;
        Object[] split = pattern.split("/");
        Assert.isTrue(!ObjectUtils.isEmpty(split), "invalid pattern given " + pattern);
        Assert.isTrue(split.length == 2, "invalid pattern given " + pattern);
        this.hasPattern = pattern.contains("{") && pattern.contains("}");
        this.index = this.parse(((String)split[0]).trim());
        this.type = this.parse(((String)split[1]).trim());
    }

    protected List<Object> parse(String string) {
        ArrayList<Object> template = new ArrayList<Object>();
        while (string.contains("{")) {
            int startPattern = string.indexOf("{");
            template.add(string.substring(0, startPattern));
            int endPattern = string.indexOf("}");
            Assert.isTrue(endPattern > startPattern + 1, "Invalid pattern given " + string);
            String nestedString = string.substring(startPattern + 1, endPattern);
            int separator = nestedString.indexOf(":");
            if (separator > 0) {
                Assert.isTrue(nestedString.length() > separator + 1, "Invalid format given " + nestedString);
                String format = nestedString.substring(separator + 1);
                nestedString = nestedString.substring(0, separator);
                template.add(this.wrapWithFormatter(format, this.createFieldExtractor(nestedString)));
            } else {
                template.add(this.createFieldExtractor(nestedString));
            }
            string = string.substring(endPattern + 1).trim();
        }
        if (StringUtils.hasText(string)) {
            template.add(string);
        }
        return template;
    }

    private Object wrapWithFormatter(String format, final FieldExtractor createFieldExtractor) {
        final IndexFormatter iformatter = (IndexFormatter)ObjectUtils.instantiate(this.settings.getMappingIndexFormatterClassName(), this.settings);
        iformatter.configure(format);
        return new FieldExtractor(){

            @Override
            public String field(Object target) {
                return iformatter.format(createFieldExtractor.field(target));
            }
        };
    }

    private void append(StringBuilder sb, List<Object> list, Object target) {
        for (Object object : list) {
            if (object instanceof FieldExtractor) {
                String field = ((FieldExtractor)object).field(target);
                if (field == null) {
                    throw new EsHadoopIllegalArgumentException(String.format("Cannot find match for %s", this.pattern));
                }
                sb.append(field);
                continue;
            }
            sb.append(object.toString());
        }
    }

    @Override
    public String field(Object target) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"_index\":\"");
        this.append(sb, this.index, target);
        sb.append("\",");
        sb.append("\"_type\":\"");
        this.append(sb, this.type, target);
        sb.append("\"");
        return sb.toString();
    }

    @Override
    public boolean hasPattern() {
        return this.hasPattern;
    }

    protected abstract FieldExtractor createFieldExtractor(String var1);
}

