/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cfg;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.FieldPresenceValidation;
import org.elasticsearch.hadoop.cfg.FilteredSettings;
import org.elasticsearch.hadoop.cfg.InternalConfigurationOptions;
import org.elasticsearch.hadoop.cfg.SettingsView;
import org.elasticsearch.hadoop.security.AuthenticationMethod;
import org.elasticsearch.hadoop.util.ClusterInfo;
import org.elasticsearch.hadoop.util.ClusterName;
import org.elasticsearch.hadoop.util.EsMajorVersion;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.unit.Booleans;
import org.elasticsearch.hadoop.util.unit.ByteSizeValue;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public abstract class Settings {
    public EsMajorVersion getInternalVersionOrThrow() {
        String version = this.getProperty("es.internal.es.version", null);
        if (version == null) {
            throw new IllegalArgumentException("Elasticsearch version:[ es.internal.es.version] not present in configuration");
        }
        return EsMajorVersion.parse(version);
    }

    @Deprecated
    public EsMajorVersion getInternalVersionOrLatest() {
        String version = this.getProperty("es.internal.es.version", null);
        if (version == null) {
            return EsMajorVersion.LATEST;
        }
        return EsMajorVersion.parse(version);
    }

    public ClusterInfo getClusterInfoOrThrow() {
        ClusterInfo clusterInfo = this.getClusterInfoOrNull();
        if (clusterInfo == null) {
            throw new IllegalArgumentException("Elasticsearch cluster name:[ es.internal.es.cluster.name] not present in configuration");
        }
        return clusterInfo;
    }

    public ClusterInfo getClusterInfoOrNull() {
        String clusterName = this.getProperty("es.internal.es.cluster.name");
        if (clusterName == null) {
            return null;
        }
        String clusterUUID = this.getProperty("es.internal.es.cluster.uuid");
        EsMajorVersion version = this.getInternalVersionOrThrow();
        return new ClusterInfo(new ClusterName(clusterName, clusterUUID), version);
    }

    @Deprecated
    public ClusterInfo getClusterInfoOrUnnamedLatest() {
        String clusterName = this.getProperty("es.internal.es.cluster.name");
        if (clusterName == null) {
            return ClusterInfo.unnamedLatest();
        }
        String clusterUUID = this.getProperty("es.internal.es.cluster.uuid");
        EsMajorVersion version = this.getInternalVersionOrLatest();
        return new ClusterInfo(new ClusterName(clusterName, clusterUUID), version);
    }

    public String getNodes() {
        return this.getProperty("es.nodes", "localhost");
    }

    public int getPort() {
        return Integer.valueOf(this.getProperty("es.port", "9200"));
    }

    public boolean getNodesDiscovery() {
        return Booleans.parseBoolean(this.getProperty("es.nodes.discovery"), !this.getNodesWANOnly());
    }

    public String getShardPreference() {
        return this.getProperty("es.read.shard.preference", "");
    }

    public String getNodesPathPrefix() {
        return this.getProperty("es.nodes.path.prefix", "");
    }

    public boolean getNodesDataOnly() {
        return Booleans.parseBoolean(this.getProperty("es.nodes.data.only"), !this.getNodesWANOnly() && !this.getNodesClientOnly() && !this.getNodesIngestOnly());
    }

    public boolean getNodesIngestOnly() {
        return Booleans.parseBoolean(this.getProperty("es.nodes.ingest.only", "false"));
    }

    public boolean getNodesClientOnly() {
        return Booleans.parseBoolean(this.getProperty("es.nodes.client.only", "false"));
    }

    public boolean getNodesWANOnly() {
        return Booleans.parseBoolean(this.getProperty("es.nodes.wan.only", "false"));
    }

    public long getHttpTimeout() {
        return TimeValue.parseTimeValue(this.getProperty("es.http.timeout", "1m")).getMillis();
    }

    public int getHttpRetries() {
        return Integer.valueOf(this.getProperty("es.http.retries", "3"));
    }

    public int getBatchSizeInBytes() {
        return ByteSizeValue.parseBytesSizeValue(this.getProperty("es.batch.size.bytes", "1mb")).bytesAsInt();
    }

    public int getBatchSizeInEntries() {
        return Integer.valueOf(this.getProperty("es.batch.size.entries", "1000"));
    }

    public int getBatchWriteRetryCount() {
        return Integer.parseInt(this.getProperty("es.batch.write.retry.count", "3"));
    }

    public int getBatchWriteRetryLimit() {
        return Integer.parseInt(this.getProperty("es.batch.write.retry.limit", "50"));
    }

    public long getBatchWriteRetryWait() {
        return TimeValue.parseTimeValue(this.getProperty("es.batch.write.retry.wait", "10s")).getMillis();
    }

    public String getBatchWriteRetryPolicy() {
        return this.getProperty("es.batch.write.retry.policy", "simple");
    }

    public boolean getBatchRefreshAfterWrite() {
        return Booleans.parseBoolean(this.getProperty("es.batch.write.refresh", "true"));
    }

    public boolean getBatchFlushManual() {
        return Booleans.parseBoolean(this.getProperty("es.batch.flush.manual", "false"));
    }

    public long getScrollKeepAlive() {
        return TimeValue.parseTimeValue(this.getProperty("es.scroll.keepalive", "5m")).getMillis();
    }

    public long getScrollSize() {
        return Long.valueOf(this.getProperty("es.scroll.size", "50"));
    }

    public long getScrollLimit() {
        return Long.valueOf(this.getProperty("es.scroll.limit", "-1"));
    }

    public String getScrollFields() {
        return this.getProperty("es.internal.mr.target.fields");
    }

    public boolean getExcludeSource() {
        return Booleans.parseBoolean(this.getProperty("es.internal.exclude.source", "false"));
    }

    public String getSerializerValueWriterClassName() {
        return this.getProperty("es.ser.writer.value.class");
    }

    public String getSerializerBytesConverterClassName() {
        return this.getProperty("es.ser.writer.bytes.class");
    }

    public String getSerializerValueReaderClassName() {
        return this.getProperty("es.ser.reader.value.class");
    }

    public boolean getIndexAutoCreate() {
        return Booleans.parseBoolean(this.getProperty("es.index.auto.create", "yes"));
    }

    public boolean getIndexReadMissingAsEmpty() {
        return Booleans.parseBoolean(this.getProperty("es.index.read.missing.as.empty", "false"));
    }

    public boolean getIndexReadAllowRedStatus() {
        return Booleans.parseBoolean(this.getProperty("es.index.read.allow.red.status", "false"));
    }

    public boolean getInputAsJson() {
        return Booleans.parseBoolean(this.getProperty("es.input.json", "no"));
    }

    public boolean getOutputAsJson() {
        return Booleans.parseBoolean(this.getProperty("es.output.json", "no"));
    }

    public String getOperation() {
        return this.getProperty("es.write.operation", "index").toLowerCase(Locale.ROOT);
    }

    public String getMappingId() {
        return this.getProperty("es.mapping.id");
    }

    public String getMappingParent() {
        return this.getProperty("es.mapping.parent");
    }

    public String getMappingJoin() {
        return this.getProperty("es.mapping.join");
    }

    public String getMappingVersion() {
        return this.getProperty("es.mapping.version");
    }

    public boolean hasMappingVersionType() {
        String versionType = this.getMappingVersionType();
        return StringUtils.hasText(this.getMappingVersion()) && StringUtils.hasText(versionType) && !versionType.equals("internal");
    }

    public String getMappingVersionType() {
        return this.getProperty("es.mapping.version.type", "external");
    }

    public String getMappingRouting() {
        return this.getProperty("es.mapping.routing");
    }

    public String getMappingTtl() {
        return this.getProperty("es.mapping.ttl");
    }

    public String getMappingTimestamp() {
        return this.getProperty("es.mapping.timestamp");
    }

    public String getMappingDefaultClassExtractor() {
        return this.getProperty("es.mapping.default.extractor.class");
    }

    public String getMappingMetadataExtractorClassName() {
        return this.getProperty("es.mapping.metadata.extractor.class");
    }

    public String getMappingIdExtractorClassName() {
        return this.getProperty("es.mapping.id.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingParentExtractorClassName() {
        return this.getProperty("es.mapping.parent.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingJoinExtractorClassName() {
        return this.getProperty("es.mapping.join.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingVersionExtractorClassName() {
        return this.getProperty("es.mapping.version.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingRoutingExtractorClassName() {
        return this.getProperty("es.mapping.routing.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingTtlExtractorClassName() {
        return this.getProperty("es.mapping.ttl.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingTimestampExtractorClassName() {
        return this.getProperty("es.mapping.timestamp.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingIndexExtractorClassName() {
        return this.getProperty("es.mapping.index.extractor.class", InternalConfigurationOptions.ES_MAPPING_DEFAULT_INDEX_EXTRACTOR_CLASS);
    }

    public String getMappingIndexFormatterClassName() {
        return this.getProperty("es.mapping.index.formatter.class", InternalConfigurationOptions.ES_MAPPING_DEFAULT_INDEX_FORMATTER_CLASS);
    }

    public String getMappingParamsExtractorClassName() {
        return this.getProperty("es.mapping.params.extractor.class", InternalConfigurationOptions.ES_MAPPING_PARAMS_DEFAULT_EXTRACTOR_CLASS);
    }

    public boolean getMappingConstantAutoQuote() {
        return Booleans.parseBoolean(this.getProperty("es.mapping.constant.auto.quote", "true"));
    }

    public boolean getMappingDateRich() {
        return Booleans.parseBoolean(this.getProperty("es.mapping.date.rich", "true"));
    }

    public String getMappingIncludes() {
        return this.getProperty("es.mapping.include", "");
    }

    public String getMappingExcludes() {
        return this.getProperty("es.mapping.exclude", "");
    }

    public String getIngestPipeline() {
        return this.getProperty("es.ingest.pipeline", "");
    }

    public int getUpdateRetryOnConflict() {
        return Integer.parseInt(this.getProperty("es.update.retry.on.conflict", "0"));
    }

    public String getUpdateScript() {
        return this.getProperty("es.update.script");
    }

    public String getUpdateScriptInline() {
        return this.getLegacyProperty("es.update.script", "es.update.script.inline", null);
    }

    public String getUpdateScriptFile() {
        return this.getProperty("es.update.script.file");
    }

    public String getUpdateScriptStored() {
        return this.getProperty("es.update.script.stored");
    }

    public String getUpdateScriptLang() {
        return this.getProperty("es.update.script.lang");
    }

    public String getUpdateScriptParams() {
        return this.getProperty("es.update.script.params");
    }

    public String getUpdateScriptParamsJson() {
        return this.getProperty("es.update.script.params.json");
    }

    public boolean hasUpdateScript() {
        String op = this.getOperation();
        boolean hasScript = false;
        if ("update".equals(op) || "upsert".equals(op)) {
            hasScript = StringUtils.hasText(this.getUpdateScriptInline());
            hasScript |= StringUtils.hasText(this.getUpdateScriptFile());
            hasScript |= StringUtils.hasText(this.getUpdateScriptStored());
        }
        return hasScript;
    }

    public boolean hasUpdateScriptParams() {
        return this.hasUpdateScript() && StringUtils.hasText(this.getUpdateScriptParams());
    }

    public boolean hasUpdateScriptParamsJson() {
        return this.hasUpdateScript() && StringUtils.hasText(this.getUpdateScriptParamsJson());
    }

    private String getLegacyProperty(String legacyProperty, String newProperty, String defaultValue) {
        String legacy = this.getProperty(legacyProperty);
        if (StringUtils.hasText(legacy)) {
            LogFactory.getLog(Settings.class).warn((Object)String.format(Locale.ROOT, "[%s] property has been deprecated - use [%s] instead", legacyProperty, newProperty));
            return legacy;
        }
        return this.getProperty(newProperty, defaultValue);
    }

    public boolean getReadFieldEmptyAsNull() {
        return Booleans.parseBoolean(this.getLegacyProperty("es.field.read.empty.as.null", "es.read.field.empty.as.null", "yes"));
    }

    public FieldPresenceValidation getReadFieldExistanceValidation() {
        return FieldPresenceValidation.valueOf(this.getLegacyProperty("es.field.read.validate.presence", "es.read.field.validate.presence", "warn").toUpperCase(Locale.ENGLISH));
    }

    public String getReadFieldInclude() {
        return this.getProperty("es.read.field.include", "");
    }

    public String getReadFieldExclude() {
        return this.getProperty("es.read.field.exclude", "");
    }

    public String getReadFieldAsArrayInclude() {
        return this.getProperty("es.read.field.as.array.include", "");
    }

    public String getReadFieldAsArrayExclude() {
        return this.getProperty("es.read.field.as.array.exclude", "");
    }

    public String getReadSourceFilter() {
        return this.getProperty("es.read.source.filter", "");
    }

    public TimeValue getHeartBeatLead() {
        return TimeValue.parseTimeValue(this.getProperty("es.action.heart.beat.lead", "15s"));
    }

    public TimeValue getTransportPoolingExpirationTimeout() {
        return TimeValue.parseTimeValue(this.getProperty("es.net.transport.pooling.expiration.timeout", "5m"));
    }

    public boolean getNetworkSSLEnabled() {
        return Booleans.parseBoolean(this.getProperty("es.net.ssl", "false"));
    }

    public String getNetworkSSLKeyStoreLocation() {
        return this.getProperty("es.net.ssl.keystore.location");
    }

    public String getNetworkSSLProtocol() {
        return this.getProperty("es.net.ssl.protocol", "TLS");
    }

    public String getNetworkSSLKeyStoreType() {
        return this.getProperty("es.net.ssl.keystore.type", "JKS");
    }

    @Deprecated
    public String getNetworkSSLKeyStorePass() {
        return this.getProperty("es.net.ssl.keystore.pass");
    }

    public String getNetworkSSLTrustStoreLocation() {
        return this.getProperty("es.net.ssl.truststore.location");
    }

    @Deprecated
    public String getNetworkSSLTrustStorePass() {
        return this.getProperty("es.net.ssl.truststore.pass");
    }

    public boolean getNetworkSSLAcceptSelfSignedCert() {
        return Booleans.parseBoolean(this.getProperty("es.net.ssl.cert.allow.self.signed", "false"));
    }

    public String getNetworkHttpAuthUser() {
        return this.getProperty("es.net.http.auth.user");
    }

    @Deprecated
    public String getNetworkHttpAuthPass() {
        return this.getProperty("es.net.http.auth.pass");
    }

    public String getNetworkSpnegoAuthElasticsearchPrincipal() {
        return this.getProperty("es.net.spnego.auth.elasticsearch.principal");
    }

    public boolean getNetworkSpnegoAuthMutual() {
        return Booleans.parseBoolean(this.getProperty("es.net.spnego.auth.mutual", "false"));
    }

    public String getNetworkProxyHttpHost() {
        return this.getProperty("es.net.proxy.http.host");
    }

    public int getNetworkProxyHttpPort() {
        return Integer.valueOf(this.getProperty("es.net.proxy.http.port", "-1"));
    }

    public String getNetworkProxyHttpUser() {
        return this.getProperty("es.net.proxy.http.user");
    }

    @Deprecated
    public String getNetworkProxyHttpPass() {
        return this.getProperty("es.net.proxy.http.pass");
    }

    public boolean getNetworkHttpUseSystemProperties() {
        return Booleans.parseBoolean(this.getProperty("es.net.proxy.http.use.system.props", "yes"));
    }

    public String getNetworkProxyHttpsHost() {
        return this.getProperty("es.net.proxy.https.host");
    }

    public int getNetworkProxyHttpsPort() {
        return Integer.valueOf(this.getProperty("es.net.proxy.https.port", "-1"));
    }

    public String getNetworkProxyHttpsUser() {
        return this.getProperty("es.net.proxy.https.user");
    }

    @Deprecated
    public String getNetworkProxyHttpsPass() {
        return this.getProperty("es.net.proxy.https.pass");
    }

    public boolean getNetworkHttpsUseSystemProperties() {
        return Booleans.parseBoolean(this.getProperty("es.net.proxy.https.use.system.props", "yes"));
    }

    public String getNetworkProxySocksHost() {
        return this.getProperty("es.net.proxy.socks.host");
    }

    public int getNetworkProxySocksPort() {
        return Integer.valueOf(this.getProperty("es.net.proxy.socks.port", "-1"));
    }

    public String getNetworkProxySocksUser() {
        return this.getProperty("es.net.proxy.socks.user");
    }

    @Deprecated
    public String getNetworkProxySocksPass() {
        return this.getProperty("es.net.proxy.socks.pass");
    }

    public boolean getNetworkSocksUseSystemProperties() {
        return Booleans.parseBoolean(this.getProperty("es.net.proxy.socks.use.system.props", "yes"));
    }

    public boolean getNodesResolveHostnames() {
        return Booleans.parseBoolean(this.getProperty("es.nodes.resolve.hostname"), !this.getNodesWANOnly());
    }

    public Settings setInternalClusterInfo(ClusterInfo clusterInfo) {
        this.setProperty("es.internal.es.cluster.name", clusterInfo.getClusterName().getName());
        if (clusterInfo.getClusterName().getUUID() != null) {
            this.setProperty("es.internal.es.cluster.uuid", clusterInfo.getClusterName().getUUID());
        }
        this.setProperty("es.internal.es.version", clusterInfo.getMajorVersion().toString());
        return this;
    }

    @Deprecated
    public Settings setInternalVersion(EsMajorVersion version) {
        this.setProperty("es.internal.es.version", version.toString());
        return this;
    }

    public Settings setNodes(String hosts) {
        this.setProperty("es.nodes", hosts);
        return this;
    }

    @Deprecated
    public Settings setHosts(String hosts) {
        return this.setNodes(hosts);
    }

    public Settings setPort(int port) {
        this.setProperty("es.port", "" + port);
        return this;
    }

    public Settings setResourceRead(String index) {
        this.setProperty("es.resource.read", index);
        return this;
    }

    public Settings setResourceWrite(String index) {
        this.setProperty("es.resource.write", index);
        return this;
    }

    public Settings setQuery(String query) {
        this.setProperty("es.query", StringUtils.hasText(query) ? query : "");
        return this;
    }

    public Settings setMaxDocsPerPartition(int size) {
        this.setProperty("es.input.max.docs.per.partition", Integer.toString(size));
        return this;
    }

    protected String getResource() {
        return this.getProperty("es.resource");
    }

    public String getResourceRead() {
        return this.getProperty("es.resource.read", this.getResource());
    }

    public String getResourceWrite() {
        return this.getProperty("es.resource.write", this.getResource());
    }

    public String getQuery() {
        return this.getProperty("es.query");
    }

    public Integer getMaxDocsPerPartition() {
        String value = this.getProperty("es.input.max.docs.per.partition");
        if (StringUtils.hasText(value)) {
            return Integer.parseInt(value);
        }
        return null;
    }

    public boolean getReadMetadata() {
        return Booleans.parseBoolean(this.getProperty("es.read.metadata", "false"));
    }

    public String getReadMetadataField() {
        return this.getProperty("es.read.metadata.field", "_metadata");
    }

    public boolean getReadMetadataVersion() {
        return Booleans.parseBoolean(this.getProperty("es.read.metadata.version", "false"));
    }

    public boolean getReadMappingMissingFieldsIgnore() {
        return Booleans.parseBoolean(this.getProperty("es.read.unmapped.fields.ignore", "true"));
    }

    public boolean getDataFrameWriteNullValues() {
        return Booleans.parseBoolean(this.getProperty("es.spark.dataframe.write.null", "false"));
    }

    public AuthenticationMethod getSecurityAuthenticationMethod() {
        AuthenticationMethod authMode = null;
        String authSetting = this.getProperty("es.security.authentication");
        if (authSetting != null && (authMode = AuthenticationMethod.get(authSetting)) == null) {
            throw new EsHadoopIllegalArgumentException("Could not determine auth mode. Property [es.security.authentication] was set to unknown mode [" + authSetting + "]. Use a valid auth mode from the following: " + AuthenticationMethod.getAvailableMethods());
        }
        if (authMode == null && this.getNetworkHttpAuthUser() != null) {
            authMode = AuthenticationMethod.BASIC;
        } else if (authMode == null) {
            authMode = AuthenticationMethod.SIMPLE;
        }
        return authMode;
    }

    public String getSecurityUserProviderClass() {
        return this.getProperty("es.security.user.provider.class");
    }

    public abstract InputStream loadResource(String var1);

    public abstract Settings copy();

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (!StringUtils.hasText(value)) {
            return defaultValue;
        }
        return value;
    }

    public abstract String getProperty(String var1);

    public abstract void setProperty(String var1, String var2);

    public Settings getSettingsView(String name) {
        return new SettingsView(this, name);
    }

    public Settings excludeFilter(String prefix) {
        return new FilteredSettings(this, prefix);
    }

    public Settings merge(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return this;
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        Object prop = null;
        while (propertyNames.hasMoreElements()) {
            prop = propertyNames.nextElement();
            if (!(prop instanceof String)) continue;
            Object value = properties.get(prop);
            this.setProperty(prop, value.toString());
        }
        return this;
    }

    public Settings merge(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return this;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Settings load(String source) {
        Properties copy = IOUtils.propsFromString(source);
        this.merge(copy);
        return this;
    }

    public String save() {
        Properties copy = this.asProperties();
        return IOUtils.propsToString(copy);
    }

    public abstract Properties asProperties();

    public Settings setOpaqueId(String opaqueId) {
        this.setProperty("es.net.http.header.X-Opaque-ID", this.cleanOpaqueId(opaqueId));
        return this;
    }

    private String cleanOpaqueId(String opaqueId) {
        char[] chars = opaqueId.toCharArray();
        StringBuilder cleanedOpaqueId = new StringBuilder(chars.length);
        for (int i = 0; i < chars.length; ++i) {
            char character = chars[i];
            if (character <= '\u001f' || character >= '\u007f') continue;
            cleanedOpaqueId.append(chars[i]);
        }
        return cleanedOpaqueId.toString();
    }

    public String getOpaqueId() {
        return this.getProperty("es.net.http.header.X-Opaque-ID");
    }
}

