/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.sql.Timestamp;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.io.Writable;
import org.elasticsearch.hadoop.mr.WritableValueReader;
import org.elasticsearch.hadoop.util.ObjectUtils;

public class HiveValueReader
extends WritableValueReader {
    private static Log LOG = LogFactory.getLog(HiveValueReader.class);
    private final boolean timestampV2Present;
    private final Class<? extends Writable> timestampClass;

    public HiveValueReader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        this.timestampV2Present = ObjectUtils.isClassPresent("org.apache.hadoop.hive.serde2.io.TimestampWritableV2", contextClassLoader);
        if (this.timestampV2Present) {
            Class<Object> clazz;
            try {
                Class<?> c;
                clazz = c = Class.forName("org.apache.hadoop.hive.serde2.io.TimestampWritableV2");
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Object)"Could not load org.apache.hadoop.hive.serde2.io.TimestampWritableV2. Continuing with legacy Timestamp class.");
                clazz = TimestampWritable.class;
            }
            this.timestampClass = clazz;
        } else {
            this.timestampClass = TimestampWritable.class;
        }
    }

    @Override
    protected Class<? extends Writable> dateType() {
        return this.timestampClass;
    }

    @Override
    protected Class<? extends Writable> doubleType() {
        return DoubleWritable.class;
    }

    @Override
    protected Class<? extends Writable> byteType() {
        return ByteWritable.class;
    }

    @Override
    protected Class<? extends Writable> shortType() {
        return ShortWritable.class;
    }

    @Override
    protected Object parseDate(Long value, boolean richDate) {
        if (richDate) {
            return this.timestampV2Present ? TimestampWritableV2Reader.readTimestampV2(value) : TimestampWritableReader.readTimestamp(value);
        }
        return this.processLong(value);
    }

    @Override
    protected Object parseDate(String value, boolean richDate) {
        if (richDate) {
            long millis = DatatypeConverter.parseDateTime((String)value).getTimeInMillis();
            return this.timestampV2Present ? TimestampWritableV2Reader.readTimestampV2(millis) : TimestampWritableReader.readTimestamp(millis);
        }
        return this.parseString(value);
    }

    @Override
    protected Object processDouble(Double value) {
        return new DoubleWritable(value.doubleValue());
    }

    @Override
    protected Object processByte(Byte value) {
        return new ByteWritable(value.byteValue());
    }

    @Override
    protected Object processShort(Short value) {
        return new ShortWritable(value.shortValue());
    }

    private static class TimestampWritableV2Reader {
        private TimestampWritableV2Reader() {
        }

        public static Object readTimestampV2(Long value) {
            return new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)value));
        }
    }

    private static class TimestampWritableReader {
        private TimestampWritableReader() {
        }

        public static Object readTimestamp(Long value) {
            return new TimestampWritable(new Timestamp(value));
        }
    }
}

