/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.elasticsearch.hadoop.util.EsMajorVersion;

public class EsToken {
    private final String name;
    private final String id;
    private final String apiKey;
    private final long expirationTime;
    private final String clusterName;
    private final EsMajorVersion majorVersion;

    public EsToken(String name, String id, String apiKey, long expirationTime, String clusterName, EsMajorVersion majorVersion) {
        this.name = name;
        this.id = id;
        this.apiKey = apiKey;
        this.expirationTime = expirationTime;
        this.clusterName = clusterName;
        this.majorVersion = majorVersion;
    }

    public EsToken(DataInput inputStream) throws IOException {
        this.name = inputStream.readUTF();
        this.id = inputStream.readUTF();
        this.apiKey = inputStream.readUTF();
        this.expirationTime = inputStream.readLong();
        this.clusterName = inputStream.readUTF();
        this.majorVersion = EsMajorVersion.parse(inputStream.readUTF());
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public EsMajorVersion getMajorVersion() {
        return this.majorVersion;
    }

    public void writeOut(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.name);
        dataOutput.writeUTF(this.id);
        dataOutput.writeUTF(this.apiKey);
        dataOutput.writeLong(this.expirationTime);
        dataOutput.writeUTF(this.clusterName);
        dataOutput.writeUTF(this.majorVersion.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EsToken esToken = (EsToken)o;
        if (this.expirationTime != esToken.expirationTime) {
            return false;
        }
        if (this.name != null ? !this.name.equals(esToken.name) : esToken.name != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(esToken.id) : esToken.id != null) {
            return false;
        }
        if (this.apiKey != null ? !this.apiKey.equals(esToken.apiKey) : esToken.apiKey != null) {
            return false;
        }
        if (this.clusterName != null ? !this.clusterName.equals(esToken.clusterName) : esToken.clusterName != null) {
            return false;
        }
        return this.majorVersion != null ? this.majorVersion.equals(esToken.majorVersion) : esToken.majorVersion == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.apiKey != null ? this.apiKey.hashCode() : 0);
        result = 31 * result + (int)(this.expirationTime ^ this.expirationTime >>> 32);
        result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
        result = 31 * result + (this.majorVersion != null ? this.majorVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EsToken{name='" + this.name + '\'' + ", id='" + this.id + '\'' + ", apiKey='" + this.apiKey + '\'' + ", expirationTime=" + this.expirationTime + ", clusterName='" + this.clusterName + '\'' + ", majorVersion=" + this.majorVersion + '}';
    }
}

