/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;

public class FastByteArrayOutputStream
extends OutputStream {
    private BytesArray data;

    public FastByteArrayOutputStream() {
        this(1024);
    }

    public FastByteArrayOutputStream(int size) {
        Assert.isTrue(size >= 0, "Negative initial size: " + size);
        this.data = new BytesArray(size);
    }

    public FastByteArrayOutputStream(BytesArray data) {
        this.data = data;
    }

    @Override
    public void write(int b) {
        this.data.add(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.data.add(b, off, len);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.data.bytes, 0, this.data.size);
    }

    public BytesArray bytes() {
        return this.data;
    }

    public void setBytes(byte[] data, int size) {
        this.data.bytes(data, size);
    }

    public long size() {
        return this.data.length();
    }

    public void reset() {
        this.data.reset();
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public void close() throws IOException {
    }
}

