/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.storm.security;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.storm.security.INimbusCredentialPlugin;
import org.apache.storm.security.auth.IAutoCredentials;
import org.apache.storm.security.auth.ICredentialsRenewer;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.CompositeSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.security.AuthenticationMethod;
import org.elasticsearch.hadoop.security.EsToken;
import org.elasticsearch.hadoop.security.JdkUser;
import org.elasticsearch.hadoop.security.JdkUserProvider;
import org.elasticsearch.hadoop.security.LoginUtil;
import org.elasticsearch.hadoop.util.FastByteArrayInputStream;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.storm.cfg.StormSettings;

public class AutoElasticsearch
implements IAutoCredentials,
ICredentialsRenewer,
INimbusCredentialPlugin {
    private static final Log LOG = LogFactory.getLog(AutoElasticsearch.class);
    private static final String ELASTICSEARCH_CREDENTIALS = "ELASTICSEARCH_CREDENTIALS";
    public static final String USER_PRINCIPAL = "es.storm.autocredentials.user.principal";
    public static final String USER_KEYTAB = "es.storm.autocredentials.user.keytab";
    private StormSettings clusterSettings;

    public void prepare(Map stormClusterConfiguration) {
        LOG.debug((Object)"Receiving cluster configuration");
        this.clusterSettings = new StormSettings(stormClusterConfiguration);
    }

    public void populateCredentials(Map<String, String> credentials, Map topologyConfiguration) {
        this.populateCredentials(credentials, topologyConfiguration, null);
    }

    public void populateCredentials(Map<String, String> credentials, Map<String, Object> topologyConfiguration, String topologyOwnerPrincipal) {
        EsToken token;
        LoginContext loginContext;
        LOG.debug((Object)"Populating credentials...");
        StormSettings topologyConf = new StormSettings(topologyConfiguration);
        final CompositeSettings topologyAndClusterSettings = new CompositeSettings(Arrays.asList(topologyConf, this.clusterSettings));
        if (!AuthenticationMethod.KERBEROS.equals((Object)topologyAndClusterSettings.getSecurityAuthenticationMethod())) {
            throw new EsHadoopIllegalArgumentException("Configured Elasticsearch autocredential plugin but did not enable ES Kerberos [es.security.authentication]. Bailing out...");
        }
        String userPrincipal = ((Settings)topologyAndClusterSettings).getProperty(USER_PRINCIPAL);
        if (userPrincipal == null) {
            throw new EsHadoopIllegalArgumentException("Configured Elasticsearch autocredential plugin but did not provide [es.storm.autocredentials.user.principal] setting. Bailing out...");
        }
        String userKeytab = ((Settings)topologyAndClusterSettings).getProperty(USER_KEYTAB);
        if (userKeytab == null) {
            throw new EsHadoopIllegalArgumentException("Configured Elasticsearch autocredential plugin but did not provide [es.storm.autocredentials.user.keytab] setting. Bailing out...");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Performing login for [%s] using [%s]", userPrincipal, userKeytab));
        }
        try {
            loginContext = LoginUtil.keytabLogin(userPrincipal, userKeytab);
        }
        catch (LoginException e) {
            throw new EsHadoopException("Could not perform keytab login", e);
        }
        InitializationUtils.setUserProviderIfNotSet(topologyAndClusterSettings, JdkUserProvider.class, LOG);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Obtaining token for [%s]", userPrincipal));
        }
        try {
            token = Subject.doAs(loginContext.getSubject(), new PrivilegedExceptionAction<EsToken>(){

                @Override
                public EsToken run() throws Exception {
                    try (RestClient client = new RestClient(topologyAndClusterSettings);){
                        EsToken esToken = client.createNewApiToken("ESHADOOP_" + UUID.randomUUID().toString());
                        return esToken;
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new EsHadoopException("Could not retrieve delegation token", e);
        }
        finally {
            try {
                loginContext.logout();
            }
            catch (LoginException e) {
                LOG.warn((Object)"Could not complete logout operation", (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Obtained token [%s] for principal [%s]", token.getName(), userPrincipal));
        }
        this.putCred(ELASTICSEARCH_CREDENTIALS, token, credentials);
    }

    public void shutdown() {
    }

    public void renew(Map<String, String> credentials, Map topologyConf) {
        this.renew(credentials, topologyConf, null);
    }

    public void renew(Map<String, String> credentials, Map<String, Object> topologyConf, String topologyOwnerPrincipal) {
        LOG.debug((Object)"Checking for credential renewal");
        EsToken token = this.getCred(ELASTICSEARCH_CREDENTIALS, credentials);
        if (token != null) {
            LOG.debug((Object)"Checking token lifetime to see if refresh is required...");
            long currentTime = System.currentTimeMillis();
            long expiration = token.getExpirationTime();
            if (currentTime > expiration) {
                LOG.debug((Object)"ES Token expired. Renewing token...");
                this.populateCredentials(credentials, topologyConf, topologyOwnerPrincipal);
                return;
            }
            int renewalWindowSeconds = this.clusterSettings.getNimbusCredentialRenewersFrequencySeconds();
            if (renewalWindowSeconds < 0) {
                LOG.debug((Object)"Invalid renewal window configured. Renewing token...");
                this.populateCredentials(credentials, topologyConf, topologyOwnerPrincipal);
                return;
            }
            long renewalWindow = TimeUnit.SECONDS.convert(renewalWindowSeconds, TimeUnit.MILLISECONDS);
            long nextRenewal = currentTime + renewalWindow;
            if (nextRenewal > expiration) {
                LOG.debug((Object)"ES Token will expire before next renewal window. Renewing token...");
                this.populateCredentials(credentials, topologyConf, topologyOwnerPrincipal);
                return;
            }
            LOG.debug((Object)"Token expiration is longer than renewal window. Token will be renewed at a later time.");
        } else {
            LOG.debug((Object)"Could not locate token to refresh!");
        }
    }

    public void populateCredentials(Map<String, String> credentials) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Auto Credential Class Loaded on submission client");
        }
        credentials.put(ELASTICSEARCH_CREDENTIALS, "placeholder");
    }

    public void populateSubject(Subject subject, Map<String, String> credentials) {
        EsToken token;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Loading credentials to subject on worker side");
        }
        if ((token = this.getCred(ELASTICSEARCH_CREDENTIALS, credentials)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Loaded token [%s]. Adding to subject...", token.getName()));
            }
            JdkUser user = new JdkUser(subject, this.clusterSettings);
            user.addEsToken(token);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Found no credentials to load");
        }
    }

    public void updateSubject(Subject subject, Map<String, String> credentials) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Performing subject update");
        }
        this.populateSubject(subject, credentials);
    }

    private void putCred(String key, EsToken token, Map<String, String> credentials) {
        FastByteArrayOutputStream stream = new FastByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(stream);
        try {
            token.writeOut(output);
        }
        catch (IOException e) {
            throw new EsHadoopException("Could not serialize EsToken", e);
        }
        String credential = new String(Base64.encodeBase64((byte[])stream.bytes().bytes()), StringUtils.UTF_8);
        credentials.put(key, credential);
    }

    private EsToken getCred(String key, Map<String, String> credentials) {
        EsToken token = null;
        String serializedToken = credentials.get(key);
        if (serializedToken != null && !serializedToken.equals("placeholder")) {
            byte[] rawData = Base64.decodeBase64((String)serializedToken);
            try {
                token = new EsToken(new DataInputStream(new FastByteArrayInputStream(rawData)));
            }
            catch (IOException e) {
                throw new EsHadoopException("Could not deserialize EsToken", e);
            }
        }
        return token;
    }
}

