/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.dto.mapping;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.elasticsearch.hadoop.serialization.FieldType;

public class Field
implements Serializable {
    static final Field[] NO_FIELDS = new Field[0];
    private final String name;
    private final FieldType type;
    private final Field[] properties;

    public Field(String name, FieldType type) {
        this(name, type, NO_FIELDS);
    }

    public Field(String name, FieldType type, Collection<Field> properties) {
        this(name, type, properties != null ? properties.toArray(new Field[properties.size()]) : NO_FIELDS);
    }

    Field(String name, FieldType type, Field[] properties) {
        this.name = name;
        this.type = type;
        this.properties = properties;
    }

    public Field[] properties() {
        return this.properties;
    }

    public FieldType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return String.format("%s=%s", this.name, this.type == FieldType.OBJECT || this.type == FieldType.NESTED ? Arrays.toString(this.properties) : this.type);
    }
}

