/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.io.Closeable;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentType;

public interface XContentParser
extends Closeable {
    public XContentType contentType();

    public void allowDuplicateKeys(boolean var1);

    public Token nextToken() throws IOException;

    @Nullable
    default public String nextFieldName() throws IOException {
        return this.nextToken() == Token.FIELD_NAME ? this.currentName() : null;
    }

    public void skipChildren() throws IOException;

    public Token currentToken();

    public String currentName() throws IOException;

    public Map<String, Object> map() throws IOException;

    public Map<String, Object> mapOrdered() throws IOException;

    public Map<String, String> mapStrings() throws IOException;

    public <T> Map<String, T> map(Supplier<Map<String, T>> var1, CheckedFunction<XContentParser, T, IOException> var2) throws IOException;

    public List<Object> list() throws IOException;

    public List<Object> listOrderedMap() throws IOException;

    public String text() throws IOException;

    public String textOrNull() throws IOException;

    public CharBuffer charBufferOrNull() throws IOException;

    public CharBuffer charBuffer() throws IOException;

    public Object objectText() throws IOException;

    public Object objectBytes() throws IOException;

    public boolean hasTextCharacters();

    public char[] textCharacters() throws IOException;

    public int textLength() throws IOException;

    public int textOffset() throws IOException;

    public Number numberValue() throws IOException;

    public NumberType numberType() throws IOException;

    public short shortValue(boolean var1) throws IOException;

    public int intValue(boolean var1) throws IOException;

    public long longValue(boolean var1) throws IOException;

    public float floatValue(boolean var1) throws IOException;

    public double doubleValue(boolean var1) throws IOException;

    public short shortValue() throws IOException;

    public int intValue() throws IOException;

    public long longValue() throws IOException;

    public float floatValue() throws IOException;

    public double doubleValue() throws IOException;

    public boolean isBooleanValue() throws IOException;

    public boolean booleanValue() throws IOException;

    public byte[] binaryValue() throws IOException;

    public XContentLocation getTokenLocation();

    public <T> T namedObject(Class<T> var1, String var2, Object var3) throws IOException;

    public NamedXContentRegistry getXContentRegistry();

    public boolean isClosed();

    public RestApiVersion getRestApiVersion();

    public DeprecationHandler getDeprecationHandler();

    public static enum Token {
        START_OBJECT(false),
        END_OBJECT(false),
        START_ARRAY(false),
        END_ARRAY(false),
        FIELD_NAME(false),
        VALUE_STRING(true),
        VALUE_NUMBER(true),
        VALUE_BOOLEAN(true),
        VALUE_EMBEDDED_OBJECT(true),
        VALUE_NULL(false);

        private final boolean isValue;

        private Token(boolean isValue) {
            this.isValue = isValue;
        }

        public boolean isValue() {
            return this.isValue;
        }
    }

    public static enum NumberType {
        INT,
        BIG_INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        BIG_DECIMAL;

    }
}

