/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.domain;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eluder.coveralls.maven.plugin.domain.Git;

public class GitRepository {
    private final File sourceDirectory;

    public GitRepository(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public Git load() throws IOException {
        try (Repository repository = ((RepositoryBuilder)new RepositoryBuilder().findGitDir(this.sourceDirectory)).build();){
            Git.Head head = this.getHead(repository);
            String branch = this.getBranch(repository);
            List<Git.Remote> remotes = this.getRemotes(repository);
            Git git = new Git(repository.getWorkTree(), head, branch, remotes);
            return git;
        }
    }

    private Git.Head getHead(Repository repository) throws IOException {
        ObjectId revision = repository.resolve("HEAD");
        RevCommit commit = new RevWalk(repository).parseCommit((AnyObjectId)revision);
        Git.Head head = new Git.Head(revision.getName(), commit.getAuthorIdent().getName(), commit.getAuthorIdent().getEmailAddress(), commit.getCommitterIdent().getName(), commit.getCommitterIdent().getEmailAddress(), commit.getFullMessage());
        return head;
    }

    private String getBranch(Repository repository) throws IOException {
        return repository.getBranch();
    }

    private List<Git.Remote> getRemotes(Repository repository) {
        StoredConfig config = repository.getConfig();
        ArrayList<Git.Remote> remotes = new ArrayList<Git.Remote>();
        for (String remote : config.getSubsections("remote")) {
            String url = config.getString("remote", remote, "url");
            remotes.add(new Git.Remote(remote, url));
        }
        return remotes;
    }
}

