/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eluder.coveralls.maven.plugin.domain.JsonObject;

public final class Source
implements JsonObject {
    private static final Pattern NEWLINE = Pattern.compile("\r\n|\r|\n");
    private final String name;
    private final String digest;
    private final Integer[] coverage;
    private String classifier;

    public Source(String name, String source, String digest) {
        this(name, Source.getLines(source), digest, null);
    }

    protected Source(String name, int lines, String digest, String classifier) {
        this.name = name;
        this.digest = digest;
        this.coverage = new Integer[lines];
        this.classifier = classifier;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public String getFullName() {
        return this.name;
    }

    @JsonProperty(value="source_digest")
    public String getDigest() {
        return this.digest;
    }

    @JsonProperty(value="coverage")
    public Integer[] getCoverage() {
        return this.coverage;
    }

    @JsonIgnore
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void addCoverage(int lineNumber, Integer coverage) {
        int index = lineNumber - 1;
        if (index >= this.coverage.length) {
            throw new IllegalArgumentException("Line number " + lineNumber + " is greater than the source file " + this.name + " size");
        }
        this.coverage[lineNumber - 1] = coverage;
    }

    public Source merge(Source source) {
        Source copy = new Source(this.name, this.coverage.length, this.digest, this.classifier);
        System.arraycopy(this.coverage, 0, copy.coverage, 0, this.coverage.length);
        if (copy.equals(source)) {
            for (int i = 0; i < copy.coverage.length; ++i) {
                if (source.coverage[i] == null) continue;
                int base = copy.coverage[i] != null ? copy.coverage[i] : 0;
                copy.coverage[i] = base + source.coverage[i];
            }
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.digest, other.digest) && Objects.equals(this.coverage.length, other.coverage.length);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.digest, this.coverage.length);
    }

    private static int getLines(String source) {
        int lines = 1;
        Matcher matcher = NEWLINE.matcher(source);
        while (matcher.find()) {
            ++lines;
        }
        return lines;
    }
}

