/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.service;

import java.util.Map;
import java.util.Properties;
import org.eluder.coveralls.maven.plugin.service.AbstractServiceSetup;

public class Shippable
extends AbstractServiceSetup {
    public static final String SHIPPABLE_NAME = "shippable";
    public static final String SHIPPABLE = "SHIPPABLE";
    public static final String SHIPPABLE_BUILD_NUMBER = "SHIPPABLE_BUILD_NUMBER";
    public static final String SHIPPABLE_BUILD_ID = "SHIPPABLE_BUILD_ID";
    public static final String SHIPPABLE_BRANCH = "BRANCH";
    public static final String SHIPPABLE_COMMIT = "COMMIT";
    public static final String SHIPPABLE_PULL_REQUEST = "PULL_REQUEST";

    public Shippable(Map<String, String> env) {
        super(env);
    }

    @Override
    public boolean isSelected() {
        return "true".equalsIgnoreCase(this.getProperty(SHIPPABLE));
    }

    @Override
    public String getName() {
        return SHIPPABLE_NAME;
    }

    @Override
    public String getBuildNumber() {
        return this.getProperty(SHIPPABLE_BUILD_NUMBER);
    }

    @Override
    public String getBuildUrl() {
        return "https://app.shippable.com/builds/" + this.getProperty(SHIPPABLE_BUILD_ID);
    }

    @Override
    public String getBranch() {
        return this.getProperty(SHIPPABLE_BRANCH);
    }

    @Override
    public String getPullRequest() {
        String pullRequest = this.getProperty(SHIPPABLE_PULL_REQUEST);
        if ("false".equals(pullRequest)) {
            return null;
        }
        return pullRequest;
    }

    @Override
    public Properties getEnvironment() {
        Properties environment = new Properties();
        this.addProperty(environment, "shippable_build_number", this.getProperty(SHIPPABLE_BUILD_NUMBER));
        this.addProperty(environment, "shippable_build_id", this.getProperty(SHIPPABLE_BUILD_ID));
        this.addProperty(environment, "shippable_build_url", this.getBuildUrl());
        this.addProperty(environment, "branch", this.getProperty(SHIPPABLE_BRANCH));
        this.addProperty(environment, "commit_sha", this.getProperty(SHIPPABLE_COMMIT));
        return environment;
    }
}

