/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.eluder.coveralls.maven.plugin.source.DirectorySourceLoader;
import org.eluder.coveralls.maven.plugin.source.MultiSourceLoader;
import org.eluder.coveralls.maven.plugin.source.ScanSourceLoader;
import org.eluder.coveralls.maven.plugin.source.SourceLoader;
import org.eluder.coveralls.maven.plugin.util.MavenProjectCollector;

public class SourceLoaderFactory {
    private final File baseDir;
    private final MavenProject project;
    private final String sourceEncoding;
    private List<File> sourceDirectories;
    private boolean scanForSources;

    public SourceLoaderFactory(File baseDir, MavenProject project, String sourceEncoding) {
        this.baseDir = baseDir;
        this.project = project;
        this.sourceEncoding = sourceEncoding;
    }

    public SourceLoaderFactory withSourceDirectories(List<File> sourceDirectories) {
        this.sourceDirectories = sourceDirectories;
        return this;
    }

    public SourceLoaderFactory withScanForSources(boolean scanForSources) {
        this.scanForSources = scanForSources;
        return this;
    }

    public SourceLoader createSourceLoader() {
        MultiSourceLoader multiSourceLoader = new MultiSourceLoader();
        ArrayList<File> directories = new ArrayList<File>();
        List<MavenProject> modules = new MavenProjectCollector(this.project).collect();
        for (MavenProject module : modules) {
            for (String sourceRoot : module.getCompileSourceRoots()) {
                File sourceDirectory = new File(sourceRoot);
                directories.add(sourceDirectory);
            }
        }
        if (this.sourceDirectories != null) {
            directories.addAll(this.sourceDirectories);
        }
        for (File directory : directories) {
            if (!directory.exists() || !directory.isDirectory()) continue;
            DirectorySourceLoader moduleSourceLoader = new DirectorySourceLoader(this.baseDir, directory, this.sourceEncoding);
            multiSourceLoader.add(moduleSourceLoader);
        }
        if (this.scanForSources) {
            for (File directory : directories) {
                if (!directory.exists() || !directory.isDirectory()) continue;
                ScanSourceLoader scanSourceLoader = new ScanSourceLoader(this.baseDir, directory, this.sourceEncoding);
                multiSourceLoader.add(scanSourceLoader);
            }
        }
        return multiSourceLoader;
    }
}

