/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.eobjects.analyzer.beans.BooleanAnalyzerColumnDelegate;
import org.eobjects.analyzer.beans.BooleanAnalyzerResult;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.AnnotatedRowsResult;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.CrosstabNavigator;
import org.eobjects.analyzer.storage.InMemoryRowAnnotationFactory;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;
import org.eobjects.analyzer.util.ValueCombination;

@AnalyzerBean(value="Boolean analyzer")
@Description(value="Inspect your boolean values. How is the distribution of true/false? Are there null values?")
public class BooleanAnalyzer
implements Analyzer<BooleanAnalyzerResult> {
    public static final String MEASURE_LEAST_FREQUENT = "Least frequent";
    public static final String MEASURE_MOST_FREQUENT = "Most frequent";
    public static final String VALUE_COMBINATION_COLUMN_FREQUENCY = "Frequency";
    public static final String MEASURE_FALSE_COUNT = "False count";
    public static final String MEASURE_TRUE_COUNT = "True count";
    public static final String MEASURE_NULL_COUNT = "Null count";
    public static final String MEASURE_ROW_COUNT = "Row count";
    public static final String DIMENSION_COLUMN = "Column";
    public static final String DIMENSION_MEASURE = "Measure";
    private static final Comparator<Map.Entry<ValueCombination<Boolean>, RowAnnotation>> frequentValueCombinationComparator = new Comparator<Map.Entry<ValueCombination<Boolean>, RowAnnotation>>(){

        @Override
        public int compare(Map.Entry<ValueCombination<Boolean>, RowAnnotation> o1, Map.Entry<ValueCombination<Boolean>, RowAnnotation> o2) {
            int result = o2.getValue().getRowCount() - o1.getValue().getRowCount();
            if (result == 0) {
                result = o2.getKey().compareTo(o1.getKey());
            }
            return result;
        }
    };
    private final Map<InputColumn<Boolean>, BooleanAnalyzerColumnDelegate> _columnDelegates = new HashMap<InputColumn<Boolean>, BooleanAnalyzerColumnDelegate>();
    private final Map<ValueCombination<Boolean>, RowAnnotation> _valueCombinations = new HashMap<ValueCombination<Boolean>, RowAnnotation>();
    @Configured
    InputColumn<Boolean>[] _columns;
    @Provided
    RowAnnotationFactory _annotationFactory;

    public BooleanAnalyzer(InputColumn<Boolean>[] columns) {
        this._columns = columns;
        this._annotationFactory = new InMemoryRowAnnotationFactory();
    }

    public BooleanAnalyzer() {
    }

    @Initialize
    public void init() {
        for (InputColumn<Boolean> col : this._columns) {
            this._columnDelegates.put(col, new BooleanAnalyzerColumnDelegate(this._annotationFactory));
        }
    }

    public void run(InputRow row, int distinctCount) {
        Boolean[] values = new Boolean[this._columns.length];
        for (int i = 0; i < values.length; ++i) {
            InputColumn<Boolean> col = this._columns[i];
            Boolean value = (Boolean)row.getValue(col);
            BooleanAnalyzerColumnDelegate delegate = this._columnDelegates.get(col);
            values[i] = value;
            delegate.run(value, row, distinctCount);
        }
        if (this._columns.length > 1) {
            ValueCombination<Boolean> valueCombination = new ValueCombination<Boolean>(values);
            RowAnnotation annotation = this._valueCombinations.get(valueCombination);
            if (annotation == null) {
                annotation = this._annotationFactory.createAnnotation();
                this._valueCombinations.put(valueCombination, annotation);
            }
            this._annotationFactory.annotate(row, distinctCount, annotation);
        }
    }

    public BooleanAnalyzerResult getResult() {
        Crosstab valueCombinationCrosstab;
        CrosstabDimension measureDimension = new CrosstabDimension(DIMENSION_MEASURE);
        measureDimension.addCategory(MEASURE_ROW_COUNT);
        measureDimension.addCategory(MEASURE_NULL_COUNT);
        measureDimension.addCategory(MEASURE_TRUE_COUNT);
        measureDimension.addCategory(MEASURE_FALSE_COUNT);
        CrosstabDimension columnDimension = new CrosstabDimension(DIMENSION_COLUMN);
        for (InputColumn<Boolean> column : this._columns) {
            columnDimension.addCategory(column.getName());
        }
        Crosstab crosstab = new Crosstab(Number.class, new CrosstabDimension[]{columnDimension, measureDimension});
        for (InputColumn<Boolean> column : this._columns) {
            CrosstabNavigator crosstabNavigator = crosstab.navigate().where(columnDimension, column.getName());
            BooleanAnalyzerColumnDelegate delegate = this._columnDelegates.get(column);
            crosstabNavigator.where(measureDimension, MEASURE_ROW_COUNT).put((Serializable)Integer.valueOf(delegate.getRowCount()));
            int nullCount = delegate.getNullCount();
            crosstabNavigator.where(measureDimension, MEASURE_NULL_COUNT).put((Serializable)Integer.valueOf(nullCount));
            if (nullCount > 0) {
                crosstabNavigator.attach((AnalyzerResult)new AnnotatedRowsResult(delegate.getNullAnnotation(), this._annotationFactory, new InputColumn[]{column}));
            }
            RowAnnotation annotation = delegate.getTrueAnnotation();
            crosstabNavigator.where(measureDimension, MEASURE_TRUE_COUNT).put((Serializable)Integer.valueOf(annotation.getRowCount()));
            if (annotation.getRowCount() > 0) {
                crosstabNavigator.attach((AnalyzerResult)new AnnotatedRowsResult(annotation, this._annotationFactory, new InputColumn[]{column}));
            }
            annotation = delegate.getFalseAnnotation();
            crosstabNavigator.where(measureDimension, MEASURE_FALSE_COUNT).put((Serializable)Integer.valueOf(annotation.getRowCount()));
            if (annotation.getRowCount() <= 0) continue;
            crosstabNavigator.attach((AnalyzerResult)new AnnotatedRowsResult(annotation, this._annotationFactory, new InputColumn[]{column}));
        }
        if (this._columns.length > 1) {
            measureDimension = new CrosstabDimension(DIMENSION_MEASURE);
            columnDimension = new CrosstabDimension(DIMENSION_COLUMN);
            for (InputColumn<Boolean> inputColumn : this._columns) {
                columnDimension.addCategory(inputColumn.getName());
            }
            columnDimension.addCategory(VALUE_COMBINATION_COLUMN_FREQUENCY);
            valueCombinationCrosstab = new Crosstab(Number.class, new CrosstabDimension[]{columnDimension, measureDimension});
            TreeSet<Map.Entry<ValueCombination<Boolean>, RowAnnotation>> entries = new TreeSet<Map.Entry<ValueCombination<Boolean>, RowAnnotation>>(frequentValueCombinationComparator);
            entries.addAll(this._valueCombinations.entrySet());
            int row = 0;
            for (Map.Entry entry : entries) {
                String measureName = row == 0 ? MEASURE_MOST_FREQUENT : (row + 1 == entries.size() ? MEASURE_LEAST_FREQUENT : "Combination " + row);
                measureDimension.addCategory(measureName);
                CrosstabNavigator nav = valueCombinationCrosstab.where(measureDimension, measureName);
                ValueCombination valueCombination = (ValueCombination)entry.getKey();
                RowAnnotation annotation = (RowAnnotation)entry.getValue();
                nav.where(columnDimension, VALUE_COMBINATION_COLUMN_FREQUENCY);
                nav.put((Serializable)Integer.valueOf(annotation.getRowCount()));
                nav.attach((AnalyzerResult)new AnnotatedRowsResult(annotation, this._annotationFactory, this._columns));
                for (int i = 0; i < valueCombination.getValueCount(); ++i) {
                    InputColumn<Boolean> column = this._columns[i];
                    Boolean value = (Boolean)valueCombination.getValueAt(i);
                    Byte numberValue = null;
                    if (value != null) {
                        numberValue = value != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                    }
                    nav.where(columnDimension, column.getName());
                    nav.put((Serializable)numberValue);
                }
                ++row;
            }
        } else {
            valueCombinationCrosstab = null;
        }
        return new BooleanAnalyzerResult((Crosstab<Number>)crosstab, valueCombinationCrosstab);
    }
}

