/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;

final class BooleanAnalyzerColumnDelegate {
    private final RowAnnotationFactory _annotationFactory;
    private final RowAnnotation _nullAnnotation;
    private final RowAnnotation _trueAnnotation;
    private final RowAnnotation _falseAnnotation;
    private volatile int _rowCount;

    public BooleanAnalyzerColumnDelegate(RowAnnotationFactory annotationFactory) {
        this._annotationFactory = annotationFactory;
        this._nullAnnotation = this._annotationFactory.createAnnotation();
        this._trueAnnotation = this._annotationFactory.createAnnotation();
        this._falseAnnotation = this._annotationFactory.createAnnotation();
    }

    public void run(Boolean value, InputRow row, int distinctCount) {
        this._rowCount += distinctCount;
        if (value == null) {
            this._annotationFactory.annotate(row, distinctCount, this._nullAnnotation);
        } else if (value.booleanValue()) {
            this._annotationFactory.annotate(row, distinctCount, this._trueAnnotation);
        } else {
            this._annotationFactory.annotate(row, distinctCount, this._falseAnnotation);
        }
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public int getNullCount() {
        return this._nullAnnotation.getRowCount();
    }

    public RowAnnotation getFalseAnnotation() {
        return this._falseAnnotation;
    }

    public RowAnnotation getTrueAnnotation() {
        return this._trueAnnotation;
    }

    public RowAnnotation getNullAnnotation() {
        return this._nullAnnotation;
    }
}

