/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eobjects.analyzer.beans.api.ParameterizableMetric;
import org.eobjects.analyzer.beans.convert.ConvertToBooleanTransformer;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.CrosstabNavigator;

final class BooleanAnalyzerCombinationMetric
implements ParameterizableMetric {
    private final Crosstab<Number> _valueCombinationCrosstab;

    public BooleanAnalyzerCombinationMetric(Crosstab<Number> valueCombinationCrosstab) {
        this._valueCombinationCrosstab = valueCombinationCrosstab;
    }

    public Number getValue(String parameter) {
        if (this._valueCombinationCrosstab == null) {
            return 0;
        }
        CrosstabDimension measureDimension = this._valueCombinationCrosstab.getDimension("Measure");
        if (measureDimension.containsCategory(parameter)) {
            return (Number)this._valueCombinationCrosstab.where(measureDimension, parameter).where("Column", "Frequency").get();
        }
        String[] tokens = parameter.split(",");
        boolean[] bools = new boolean[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i].trim();
            if (!"true".equalsIgnoreCase(token) && !"false".equalsIgnoreCase(token)) {
                return 0;
            }
            bools[i] = ConvertToBooleanTransformer.transformValue((Object)token);
        }
        List columnCategories = this._valueCombinationCrosstab.getDimension("Column").getCategories();
        if (bools.length != columnCategories.size() - 1) {
            return 0;
        }
        List measureCategories = this._valueCombinationCrosstab.getDimension("Measure").getCategories();
        for (String category : measureCategories) {
            CrosstabNavigator nav = this._valueCombinationCrosstab.where("Measure", category);
            boolean[] combination = new boolean[bools.length];
            int i = 0;
            for (String column : columnCategories) {
                if ("Frequency".equals(column)) continue;
                Number number = (Number)nav.where("Column", column).get();
                combination[i] = Byte.valueOf((byte)1).equals(number);
                ++i;
            }
            if (!Arrays.equals(combination, bools)) continue;
            Number number = (Number)nav.where("Column", "Frequency").get();
            return number;
        }
        return 0;
    }

    public Collection<String> getParameterSuggestions() {
        if (this._valueCombinationCrosstab == null) {
            return Collections.emptyList();
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        suggestions.add("Most frequent");
        suggestions.add("Least frequent");
        List columnCategories = this._valueCombinationCrosstab.getDimension("Column").getCategories();
        List measureCategories = this._valueCombinationCrosstab.getDimension("Measure").getCategories();
        for (String category : measureCategories) {
            StringBuilder sb = new StringBuilder();
            CrosstabNavigator nav = this._valueCombinationCrosstab.where("Measure", category);
            for (String column : columnCategories) {
                if ("Frequency".equals(column)) continue;
                if (sb.length() != 0) {
                    sb.append(',');
                }
                Number number = (Number)nav.where("Column", column).get();
                if (Byte.valueOf((byte)1).equals(number)) {
                    sb.append("true");
                    continue;
                }
                sb.append("false");
            }
            suggestions.add(sb.toString());
        }
        return suggestions;
    }
}

