/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.eobjects.analyzer.beans.BooleanAnalyzerCombinationMetric;
import org.eobjects.analyzer.beans.api.ParameterizableMetric;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.Metric;

public class BooleanAnalyzerResult
implements AnalyzerResult {
    private static final long serialVersionUID = 1L;
    private final Crosstab<Number> _columnStatisticsCrosstab;
    private final Crosstab<Number> _valueCombinationCrosstab;

    public BooleanAnalyzerResult(Crosstab<Number> columnStatisticsCrosstab, Crosstab<Number> valueCombinationCrosstab) {
        this._columnStatisticsCrosstab = columnStatisticsCrosstab;
        this._valueCombinationCrosstab = valueCombinationCrosstab;
    }

    public Crosstab<Number> getColumnStatisticsCrosstab() {
        return this._columnStatisticsCrosstab;
    }

    public Crosstab<Number> getValueCombinationCrosstab() {
        return this._valueCombinationCrosstab;
    }

    private List<String> getColumnNameSuggestions() {
        CrosstabDimension columnDimension = this._columnStatisticsCrosstab.getDimension("Column");
        return columnDimension.getCategories();
    }

    @Metric(order=1, value="Row count")
    public Number getRowCount() {
        CrosstabDimension columnDimension = this._columnStatisticsCrosstab.getDimension("Column");
        return (Number)this._columnStatisticsCrosstab.where("Measure", "Row count").where(columnDimension, (String)columnDimension.getCategories().get(0)).get();
    }

    @Metric(order=2, value="Null count")
    public ParameterizableMetric getNullCount() {
        return new ParameterizableMetric(){

            public Number getValue(String parameter) {
                return (Number)BooleanAnalyzerResult.this._columnStatisticsCrosstab.where("Measure", "Null count").where("Column", parameter).safeGet((Serializable)Integer.valueOf(0));
            }

            public Collection<String> getParameterSuggestions() {
                return BooleanAnalyzerResult.this.getColumnNameSuggestions();
            }
        };
    }

    @Metric(order=3, value="True count")
    public ParameterizableMetric getTrueCount() {
        return new ParameterizableMetric(){

            public Number getValue(String parameter) {
                return (Number)BooleanAnalyzerResult.this._columnStatisticsCrosstab.where("Measure", "True count").where("Column", parameter).safeGet((Serializable)Integer.valueOf(0));
            }

            public Collection<String> getParameterSuggestions() {
                return BooleanAnalyzerResult.this.getColumnNameSuggestions();
            }
        };
    }

    @Metric(order=4, value="False count")
    public ParameterizableMetric getFalseCount() {
        return new ParameterizableMetric(){

            public Number getValue(String parameter) {
                return (Number)BooleanAnalyzerResult.this._columnStatisticsCrosstab.where("Measure", "False count").where("Column", parameter).safeGet((Serializable)Integer.valueOf(0));
            }

            public Collection<String> getParameterSuggestions() {
                return BooleanAnalyzerResult.this.getColumnNameSuggestions();
            }
        };
    }

    @Metric(order=5, value="Total combination count")
    public int getTotalCombinationCount() {
        if (this._valueCombinationCrosstab == null) {
            return 0;
        }
        return this._valueCombinationCrosstab.getDimension("Measure").getCategoryCount();
    }

    @Metric(order=6, value="Combination count")
    public ParameterizableMetric getCombinationCount() {
        return new BooleanAnalyzerCombinationMetric(this._valueCombinationCrosstab);
    }
}

