/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.CompletenessAnalyzerResult;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.beans.categories.ValidationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.metamodel.util.HasName;

@AnalyzerBean(value="Completeness analyzer")
@Description(value="Asserts the completeness of your data by ensuring that all required fields are filled.")
@Categorized(value={ValidationCategory.class})
public class CompletenessAnalyzer
implements Analyzer<CompletenessAnalyzerResult> {
    @Inject
    @Configured(value="Values")
    @Description(value="Values to check for completeness")
    InputColumn<?>[] _valueColumns;
    @Inject
    @Configured(value="Conditions")
    @Description(value="The conditions of which a value is determined to be filled or not")
    Condition[] _conditions;
    @Inject
    @Configured(value="Evaluation mode")
    EvaluationMode _evaluationMode = EvaluationMode.ANY_FIELD;
    @Inject
    @Provided
    RowAnnotation _invalidRecords;
    @Inject
    @Provided
    RowAnnotationFactory _annotationFactory;
    private final AtomicInteger _rowCount = new AtomicInteger();

    @Initialize
    public void init() {
        this._rowCount.set(0);
    }

    public void run(InputRow row, int distinctCount) {
        this._rowCount.addAndGet(distinctCount);
        boolean allInvalid = true;
        for (int i = 0; i < this._valueColumns.length; ++i) {
            boolean valid;
            Object value = row.getValue(this._valueColumns[i]);
            if (value instanceof String && this._conditions[i] == Condition.NOT_BLANK_OR_NULL) {
                valid = !StringUtils.isNullOrEmpty((String)((String)value));
            } else {
                boolean bl = valid = value != null;
            }
            if (this._evaluationMode == EvaluationMode.ANY_FIELD && !valid) {
                this._annotationFactory.annotate(row, distinctCount, this._invalidRecords);
                return;
            }
            if (!valid) continue;
            allInvalid = false;
        }
        if (this._evaluationMode == EvaluationMode.ALL_FIELDS && allInvalid) {
            this._annotationFactory.annotate(row, distinctCount, this._invalidRecords);
            return;
        }
    }

    public CompletenessAnalyzerResult getResult() {
        return new CompletenessAnalyzerResult(this._rowCount.get(), this._invalidRecords, this._annotationFactory, this._valueColumns);
    }

    public void setConditions(Condition[] conditions) {
        this._conditions = conditions;
    }

    public void setValueColumns(InputColumn<?>[] valueColumns) {
        this._valueColumns = valueColumns;
    }

    public void fillAllConditions(Condition condition) {
        if (this._valueColumns != null) {
            Condition[] conditions = new Condition[this._valueColumns.length];
            Arrays.fill((Object[])conditions, (Object)condition);
            this._conditions = conditions;
        }
    }

    public static enum EvaluationMode implements HasName
    {
        ALL_FIELDS("When all fields are incomplete, the record is incomplete"),
        ANY_FIELD("When any field is incomplete, the record is incomplete");

        private final String _name;

        private EvaluationMode(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }

    public static enum Condition implements HasName
    {
        NOT_BLANK_OR_NULL("Not <blank> or <null>"),
        NOT_NULL("Not <null>");

        private final String _name;

        private Condition(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }
}

