/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import org.eobjects.analyzer.beans.CompletenessAnalyzerResultReducer;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Distributed;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.AnnotatedRowsResult;
import org.eobjects.analyzer.result.Metric;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;

@Description(value="Incomplete records")
@Distributed(reducer=CompletenessAnalyzerResultReducer.class)
public class CompletenessAnalyzerResult
extends AnnotatedRowsResult
implements AnalyzerResult {
    private static final long serialVersionUID = 1L;
    private final int _rowCount;

    public CompletenessAnalyzerResult(int rowCount, RowAnnotation annotation, RowAnnotationFactory annotationFactory, InputColumn<?>[] highlightedColumns) {
        super(annotation, annotationFactory, highlightedColumns);
        this._rowCount = rowCount;
    }

    @Metric(order=1, value="Row count")
    public int getTotalRowCount() {
        return this._rowCount;
    }

    @Metric(order=2, value="Valid row count")
    public int getValidRowCount() {
        return this._rowCount - this.getInvalidRowCount();
    }

    @Metric(order=3, value="Invalid row count")
    public int getInvalidRowCount() {
        return this.getAnnotation().getRowCount();
    }
}

