/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import java.util.Collection;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.CompletenessAnalyzerResult;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.result.AnalyzerResultReducer;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;

public class CompletenessAnalyzerResultReducer
implements AnalyzerResultReducer<CompletenessAnalyzerResult> {
    @Inject
    @Provided
    RowAnnotationFactory _rowAnnotationFactory;

    public CompletenessAnalyzerResult reduce(Collection<? extends CompletenessAnalyzerResult> results) {
        CompletenessAnalyzerResult firstResult = results.iterator().next();
        RowAnnotation annotation = this._rowAnnotationFactory.createAnnotation();
        InputColumn[] highlightedColumns = firstResult.getHighlightedColumns();
        int totalRowCount = 0;
        for (CompletenessAnalyzerResult completenessAnalyzerResult : results) {
            InputRow[] rows = completenessAnalyzerResult.getRows();
            int invalidRowCount = completenessAnalyzerResult.getInvalidRowCount();
            if (invalidRowCount == rows.length) {
                this._rowAnnotationFactory.annotate(rows, annotation);
            } else {
                this._rowAnnotationFactory.transferAnnotations(completenessAnalyzerResult.getAnnotation(), annotation);
            }
            totalRowCount += completenessAnalyzerResult.getTotalRowCount();
        }
        return new CompletenessAnalyzerResult(totalRowCount, annotation, this._rowAnnotationFactory, highlightedColumns);
    }
}

