/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import java.util.Date;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.descriptive.StatisticalSummary;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

final class DateAndTimeAnalyzerColumnDelegate {
    private final RowAnnotationFactory _annotationFactory;
    private final RowAnnotation _nullAnnotation;
    private final RowAnnotation _maxDateAnnotation;
    private final RowAnnotation _minDateAnnotation;
    private final RowAnnotation _maxTimeAnnotation;
    private final RowAnnotation _minTimeAnnotation;
    private final StatisticalSummary _statistics;
    private volatile int _numRows;
    private volatile LocalDate _minDate;
    private volatile LocalDate _maxDate;
    private volatile LocalTime _minTime;
    private volatile LocalTime _maxTime;

    public DateAndTimeAnalyzerColumnDelegate(boolean descriptiveStatistics, RowAnnotationFactory annotationFactory) {
        this._annotationFactory = annotationFactory;
        this._nullAnnotation = this._annotationFactory.createAnnotation();
        this._maxDateAnnotation = this._annotationFactory.createAnnotation();
        this._minDateAnnotation = this._annotationFactory.createAnnotation();
        this._maxTimeAnnotation = this._annotationFactory.createAnnotation();
        this._minTimeAnnotation = this._annotationFactory.createAnnotation();
        this._numRows = 0;
        this._statistics = descriptiveStatistics ? new DescriptiveStatistics() : new SummaryStatistics();
    }

    public synchronized void run(Date value, InputRow row, int distinctCount) {
        this._numRows += distinctCount;
        if (value == null) {
            this._annotationFactory.annotate(row, distinctCount, this._nullAnnotation);
        } else {
            long timestamp = value.getTime();
            for (int i = 0; i < distinctCount; ++i) {
                if (this._statistics instanceof DescriptiveStatistics) {
                    ((DescriptiveStatistics)this._statistics).addValue((double)timestamp);
                    continue;
                }
                ((SummaryStatistics)this._statistics).addValue((double)timestamp);
            }
            LocalDate localDate = new LocalDate((Object)value);
            LocalTime localTime = new LocalTime((Object)value);
            if (this._minDate == null) {
                this._minDate = localDate;
                this._maxDate = localDate;
                this._minTime = localTime;
                this._maxTime = localTime;
            } else {
                if (localDate.isAfter((ReadablePartial)this._maxDate)) {
                    this._maxDate = localDate;
                    this._annotationFactory.reset(this._maxDateAnnotation);
                } else if (localDate.isBefore((ReadablePartial)this._minDate)) {
                    this._minDate = localDate;
                    this._annotationFactory.reset(this._minDateAnnotation);
                }
                if (localTime.isAfter((ReadablePartial)this._maxTime)) {
                    this._maxTime = localTime;
                    this._annotationFactory.reset(this._maxTimeAnnotation);
                } else if (localTime.isBefore((ReadablePartial)this._minTime)) {
                    this._minTime = localTime;
                    this._annotationFactory.reset(this._minTimeAnnotation);
                }
            }
            if (localDate.isEqual((ReadablePartial)this._maxDate)) {
                this._annotationFactory.annotate(row, distinctCount, this._maxDateAnnotation);
            }
            if (localDate.isEqual((ReadablePartial)this._minDate)) {
                this._annotationFactory.annotate(row, distinctCount, this._minDateAnnotation);
            }
            if (localTime.isEqual((ReadablePartial)this._maxTime)) {
                this._annotationFactory.annotate(row, distinctCount, this._maxTimeAnnotation);
            }
            if (localTime.isEqual((ReadablePartial)this._minTime)) {
                this._annotationFactory.annotate(row, distinctCount, this._minTimeAnnotation);
            }
        }
    }

    public Date getMean() {
        double meanTimestamp = this._statistics.getMean();
        if (Double.isNaN(meanTimestamp)) {
            return null;
        }
        return new Date(Double.valueOf(meanTimestamp).longValue());
    }

    public Date getMedian() {
        if (this._statistics instanceof DescriptiveStatistics) {
            double medianTimestamp = ((DescriptiveStatistics)this._statistics).getPercentile(50.0);
            if (Double.isNaN(medianTimestamp)) {
                return null;
            }
            return new Date(Double.valueOf(medianTimestamp).longValue());
        }
        return null;
    }

    public Date getPercentile25() {
        if (this._statistics instanceof DescriptiveStatistics) {
            double percentileTimestamp = ((DescriptiveStatistics)this._statistics).getPercentile(25.0);
            if (Double.isNaN(percentileTimestamp)) {
                return null;
            }
            return new Date(Double.valueOf(percentileTimestamp).longValue());
        }
        return null;
    }

    public Date getPercentile75() {
        if (this._statistics instanceof DescriptiveStatistics) {
            double percentileTimestamp = ((DescriptiveStatistics)this._statistics).getPercentile(75.0);
            if (Double.isNaN(percentileTimestamp)) {
                return null;
            }
            return new Date(Double.valueOf(percentileTimestamp).longValue());
        }
        return null;
    }

    public Number getKurtosis() {
        if (this._statistics instanceof DescriptiveStatistics) {
            double result = ((DescriptiveStatistics)this._statistics).getKurtosis();
            if (Double.isNaN(result)) {
                return null;
            }
            return result;
        }
        return null;
    }

    public Number getSkewness() {
        if (this._statistics instanceof DescriptiveStatistics) {
            double result = ((DescriptiveStatistics)this._statistics).getSkewness();
            if (Double.isNaN(result)) {
                return null;
            }
            return result;
        }
        return null;
    }

    public LocalDate getMaxDate() {
        return this._maxDate;
    }

    public LocalTime getMaxTime() {
        return this._maxTime;
    }

    public LocalDate getMinDate() {
        return this._minDate;
    }

    public LocalTime getMinTime() {
        return this._minTime;
    }

    public int getNumRows() {
        return this._numRows;
    }

    public RowAnnotation getNullAnnotation() {
        return this._nullAnnotation;
    }

    public RowAnnotation getMaxDateAnnotation() {
        return this._maxDateAnnotation;
    }

    public RowAnnotation getMinDateAnnotation() {
        return this._minDateAnnotation;
    }

    public RowAnnotation getMaxTimeAnnotation() {
        return this._maxTimeAnnotation;
    }

    public RowAnnotation getMinTimeAnnotation() {
        return this._minTimeAnnotation;
    }

    public int getNumNull() {
        return this._nullAnnotation.getRowCount();
    }
}

