/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import java.util.Date;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.convert.ConvertToDateTransformer;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabResult;
import org.eobjects.analyzer.result.Metric;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateAndTimeAnalyzerResult
extends CrosstabResult {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DateAndTimeAnalyzerResult.class);

    public DateAndTimeAnalyzerResult(Crosstab<?> crosstab) {
        super(crosstab);
    }

    @Metric(order=1, value="Row count")
    public int getRowCount(InputColumn<?> col) {
        Number n = (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Row count").get();
        return n.intValue();
    }

    @Metric(order=2, value="Null count")
    public int getNullCount(InputColumn<?> col) {
        Number n = (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Null count").get();
        return n.intValue();
    }

    @Metric(order=3, value="Highest date")
    @Description(value="The highest date value for the given column. The value is measured in number of days since 1970-01-01.")
    public Number getHighestDate(InputColumn<?> col) {
        String s = (String)((Object)this.getCrosstab().where("Column", col.getName()).where("Measure", "Highest date").safeGet(null));
        return DateAndTimeAnalyzerResult.convertToDaysSinceEpoch(s);
    }

    @Metric(order=3, value="Lowest date")
    @Description(value="The lowest date value for the given column. The value is measured in number of days since 1970-01-01.")
    public Number getLowestDate(InputColumn<?> col) {
        String s = (String)((Object)this.getCrosstab().where("Column", col.getName()).where("Measure", "Lowest date").safeGet(null));
        return DateAndTimeAnalyzerResult.convertToDaysSinceEpoch(s);
    }

    @Metric(order=4, value="Mean")
    @Description(value="The mean value for the given column. The value is measured in number of days since 1970-01-01.")
    public Number getMean(InputColumn<?> col) {
        String s = (String)((Object)this.getCrosstab().where("Column", col.getName()).where("Measure", "Mean").safeGet(null));
        return DateAndTimeAnalyzerResult.convertToDaysSinceEpoch(s);
    }

    @Metric(order=5, value="Median")
    @Description(value="The median value for the given column. The value is measured in number of days since 1970-01-01.")
    public Number getMedian(InputColumn<?> col) {
        String s = (String)((Object)this.getCrosstab().where("Column", col.getName()).where("Measure", "Median").safeGet(null));
        return DateAndTimeAnalyzerResult.convertToDaysSinceEpoch(s);
    }

    @Metric(order=6, value="25th percentile")
    @Description(value="The 25th percentile value for the given column. The value is measured in number of days since 1970-01-01.")
    public Number getPercentile25(InputColumn<?> col) {
        String s = (String)((Object)this.getCrosstab().where("Column", col.getName()).where("Measure", "25th percentile").safeGet(null));
        return DateAndTimeAnalyzerResult.convertToDaysSinceEpoch(s);
    }

    @Metric(order=7, value="75th percentile")
    @Description(value="The 75th percentile value for the given column. The value is measured in number of days since 1970-01-01.")
    public Number getPercentile75(InputColumn<?> col) {
        String s = (String)((Object)this.getCrosstab().where("Column", col.getName()).where("Measure", "75th percentile").safeGet(null));
        return DateAndTimeAnalyzerResult.convertToDaysSinceEpoch(s);
    }

    @Metric(order=8, value="Kurtosis")
    public Number getKurtosis(InputColumn<?> col) {
        Number n = (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Kurtosis").safeGet(null);
        return n;
    }

    @Metric(order=9, value="Skewness")
    public Number getSkewness(InputColumn<?> col) {
        Number n = (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Skewness").safeGet(null);
        return n;
    }

    protected static Number convertToDaysSinceEpoch(String s) {
        if (s == null) {
            return null;
        }
        LocalDate epoch = new LocalDate(1970, 1, 1);
        Date date = ConvertToDateTransformer.getInternalInstance().transformValue((Object)s);
        if (date == null) {
            logger.warn("Could not parse date string: '{}', returning null metric value.", (Object)s);
            return null;
        }
        int days = Days.daysBetween((ReadablePartial)epoch, (ReadablePartial)new LocalDate((Object)date)).getDays();
        return days;
    }
}

