/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.descriptive.StatisticalSummary;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.apache.commons.math.stat.descriptive.moment.SecondMoment;
import org.eobjects.analyzer.beans.NumberAnalyzerColumnDelegate;
import org.eobjects.analyzer.beans.NumberAnalyzerResult;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Concurrent;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.AnnotatedRowsResult;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.CrosstabNavigator;
import org.eobjects.analyzer.storage.InMemoryRowAnnotationFactory;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;

@AnalyzerBean(value="Number analyzer")
@Description(value="Provides insight into number-column values.")
@Concurrent(value=true)
public class NumberAnalyzer
implements Analyzer<NumberAnalyzerResult> {
    public static final String DIMENSION_COLUMN = "Column";
    public static final String DIMENSION_MEASURE = "Measure";
    public static final String MEASURE_ROW_COUNT = "Row count";
    public static final String MEASURE_NULL_COUNT = "Null count";
    public static final String MEASURE_HIGHEST_VALUE = "Highest value";
    public static final String MEASURE_LOWEST_VALUE = "Lowest value";
    public static final String MEASURE_SUM = "Sum";
    public static final String MEASURE_MEAN = "Mean";
    public static final String MEASURE_GEOMETRIC_MEAN = "Geometric mean";
    public static final String MEASURE_STANDARD_DEVIATION = "Standard deviation";
    public static final String MEASURE_VARIANCE = "Variance";
    public static final String MEASURE_SUM_OF_SQUARES = "Sum of squares";
    public static final String MEASURE_SECOND_MOMENT = "Second moment";
    public static final String MEASURE_MEDIAN = "Median";
    public static final String MEASURE_PERCENTILE25 = "25th percentile";
    public static final String MEASURE_PERCENTILE75 = "75th percentile";
    public static final String MEASURE_KURTOSIS = "Kurtosis";
    public static final String MEASURE_SKEWNESS = "Skewness";
    private Map<InputColumn<? extends Number>, NumberAnalyzerColumnDelegate> _columnDelegates = new HashMap<InputColumn<? extends Number>, NumberAnalyzerColumnDelegate>();
    @Inject
    @Configured
    InputColumn<? extends Number>[] _columns;
    @Inject
    @Configured
    @Description(value="Gather so-called descriptive statistics, including median, skewness, kurtosis and percentiles, which have a larger memory-footprint.")
    boolean descriptiveStatistics = false;
    @Inject
    @Provided
    RowAnnotationFactory _annotationFactory;

    public NumberAnalyzer() {
    }

    public NumberAnalyzer(InputColumn<? extends Number> ... columns) {
        this();
        this._columns = columns;
        this._annotationFactory = new InMemoryRowAnnotationFactory();
        this.init();
    }

    @Initialize
    public void init() {
        for (InputColumn<? extends Number> column : this._columns) {
            this._columnDelegates.put(column, new NumberAnalyzerColumnDelegate(this.descriptiveStatistics, this._annotationFactory));
        }
    }

    public void run(InputRow row, int distinctCount) {
        for (InputColumn<? extends Number> column : this._columns) {
            NumberAnalyzerColumnDelegate delegate = this._columnDelegates.get(column);
            Number value = (Number)row.getValue(column);
            delegate.run(row, value, distinctCount);
        }
    }

    public NumberAnalyzerResult getResult() {
        CrosstabDimension measureDimension = new CrosstabDimension(DIMENSION_MEASURE);
        measureDimension.addCategory(MEASURE_ROW_COUNT);
        measureDimension.addCategory(MEASURE_NULL_COUNT);
        measureDimension.addCategory(MEASURE_HIGHEST_VALUE);
        measureDimension.addCategory(MEASURE_LOWEST_VALUE);
        measureDimension.addCategory(MEASURE_SUM);
        measureDimension.addCategory(MEASURE_MEAN);
        measureDimension.addCategory(MEASURE_GEOMETRIC_MEAN);
        measureDimension.addCategory(MEASURE_STANDARD_DEVIATION);
        measureDimension.addCategory(MEASURE_VARIANCE);
        measureDimension.addCategory(MEASURE_SECOND_MOMENT);
        measureDimension.addCategory(MEASURE_SUM_OF_SQUARES);
        if (this.descriptiveStatistics) {
            measureDimension.addCategory(MEASURE_MEDIAN);
            measureDimension.addCategory(MEASURE_PERCENTILE25);
            measureDimension.addCategory(MEASURE_PERCENTILE75);
            measureDimension.addCategory(MEASURE_SKEWNESS);
            measureDimension.addCategory(MEASURE_KURTOSIS);
        }
        CrosstabDimension columnDimension = new CrosstabDimension(DIMENSION_COLUMN);
        for (InputColumn<? extends Number> column : this._columns) {
            columnDimension.addCategory(column.getName());
        }
        Crosstab crosstab = new Crosstab(Number.class, new CrosstabDimension[]{columnDimension, measureDimension});
        for (InputColumn<? extends Number> column : this._columns) {
            double secondMoment;
            double sumOfSquares;
            double geometricMean;
            CrosstabNavigator nav = crosstab.navigate().where(columnDimension, column.getName());
            NumberAnalyzerColumnDelegate delegate = this._columnDelegates.get(column);
            StatisticalSummary s = delegate.getStatistics();
            int nullCount = delegate.getNullCount();
            nav.where(measureDimension, MEASURE_NULL_COUNT).put((Serializable)Integer.valueOf(nullCount));
            if (nullCount > 0) {
                this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getNullAnnotation(), column);
            }
            int numRows = delegate.getNumRows();
            nav.where(measureDimension, MEASURE_ROW_COUNT).put((Serializable)Integer.valueOf(numRows));
            long nonNullCount = s.getN();
            if (nonNullCount <= 0L) continue;
            double highestValue = s.getMax();
            double lowestValue = s.getMin();
            double sum = s.getSum();
            double mean = s.getMean();
            double standardDeviation = s.getStandardDeviation();
            double variance = s.getVariance();
            if (this.descriptiveStatistics) {
                DescriptiveStatistics descriptiveStats = (DescriptiveStatistics)s;
                geometricMean = descriptiveStats.getGeometricMean();
                sumOfSquares = descriptiveStats.getSumsq();
                secondMoment = new SecondMoment().evaluate(descriptiveStats.getValues());
            } else {
                SummaryStatistics summaryStats = (SummaryStatistics)s;
                geometricMean = summaryStats.getGeometricMean();
                secondMoment = summaryStats.getSecondMoment();
                sumOfSquares = summaryStats.getSumsq();
            }
            nav.where(measureDimension, MEASURE_HIGHEST_VALUE).put((Serializable)Double.valueOf(highestValue));
            this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getMaxAnnotation(), column);
            nav.where(measureDimension, MEASURE_LOWEST_VALUE).put((Serializable)Double.valueOf(lowestValue));
            this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getMinAnnotation(), column);
            nav.where(measureDimension, MEASURE_SUM).put((Serializable)Double.valueOf(sum));
            nav.where(measureDimension, MEASURE_MEAN).put((Serializable)Double.valueOf(mean));
            nav.where(measureDimension, MEASURE_GEOMETRIC_MEAN).put((Serializable)Double.valueOf(geometricMean));
            nav.where(measureDimension, MEASURE_STANDARD_DEVIATION).put((Serializable)Double.valueOf(standardDeviation));
            nav.where(measureDimension, MEASURE_VARIANCE).put((Serializable)Double.valueOf(variance));
            nav.where(measureDimension, MEASURE_SUM_OF_SQUARES).put((Serializable)Double.valueOf(sumOfSquares));
            nav.where(measureDimension, MEASURE_SECOND_MOMENT).put((Serializable)Double.valueOf(secondMoment));
            if (!this.descriptiveStatistics) continue;
            DescriptiveStatistics descriptiveStatistics = (DescriptiveStatistics)s;
            double kurtosis = descriptiveStatistics.getKurtosis();
            double skewness = descriptiveStatistics.getSkewness();
            double median = descriptiveStatistics.getPercentile(50.0);
            double percentile25 = descriptiveStatistics.getPercentile(25.0);
            double percentile75 = descriptiveStatistics.getPercentile(75.0);
            nav.where(measureDimension, MEASURE_MEDIAN).put((Serializable)Double.valueOf(median));
            nav.where(measureDimension, MEASURE_PERCENTILE25).put((Serializable)Double.valueOf(percentile25));
            nav.where(measureDimension, MEASURE_PERCENTILE75).put((Serializable)Double.valueOf(percentile75));
            nav.where(measureDimension, MEASURE_SKEWNESS).put((Serializable)Double.valueOf(skewness));
            nav.where(measureDimension, MEASURE_KURTOSIS).put((Serializable)Double.valueOf(kurtosis));
        }
        return new NumberAnalyzerResult(this._columns, crosstab);
    }

    private void addAttachment(CrosstabNavigator<Number> nav, RowAnnotation annotation, InputColumn<?> column) {
        nav.attach((AnalyzerResult)new AnnotatedRowsResult(annotation, this._annotationFactory, new InputColumn[]{column}));
    }
}

